/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.impl.commands.parse;

import ca.stellardrift.permissionsex.ext.kotlin.Metadata;
import ca.stellardrift.permissionsex.ext.kotlin.jvm.internal.Intrinsics;
import ca.stellardrift.permissionsex.ext.net.kyori.adventure.text.TranslatableComponent;
import ca.stellardrift.permissionsex.ext.org.jetbrains.annotations.NotNull;
import ca.stellardrift.permissionsex.impl.commands.parse.CommandArgs;
import ca.stellardrift.permissionsex.impl.commands.parse.Messages;
import ca.stellardrift.permissionsex.impl.commands.parse.Value;
import ca.stellardrift.permissionsex.util.TextExtensionsKt;
import java.util.UUID;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lca/stellardrift/permissionsex/impl/commands/parse/Uuid;", "Lca/stellardrift/permissionsex/impl/commands/parse/Value;", "Ljava/util/UUID;", "()V", "parse", "args", "Lca/stellardrift/permissionsex/impl/commands/parse/CommandArgs;", "core"})
final class Uuid
extends Value<UUID> {
    @NotNull
    public static final Uuid INSTANCE;

    @Override
    @NotNull
    public UUID parse(@NotNull CommandArgs args2) {
        Intrinsics.checkNotNullParameter(args2, "args");
        String input = args2.next();
        try {
            UUID uUID = UUID.fromString(input);
            Intrinsics.checkNotNullExpressionValue(uUID, "UUID.fromString(input)");
            return uUID;
        }
        catch (IllegalArgumentException ex) {
            TranslatableComponent translatableComponent = Messages.UUID_ERROR_FORMAT.tr(input);
            Intrinsics.checkNotNullExpressionValue(translatableComponent, "Messages.UUID_ERROR_FORMAT.tr(input)");
            throw (Throwable)args2.createError(translatableComponent);
        }
    }

    private Uuid() {
        super(TextExtensionsKt.unaryPlus("a UUID in RFC format"));
    }

    static {
        Uuid uuid;
        INSTANCE = uuid = new Uuid();
    }
}

