/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.impl.commands.parse;

import ca.stellardrift.permissionsex.ext.kotlin.Metadata;
import ca.stellardrift.permissionsex.ext.kotlin.TuplesKt;
import ca.stellardrift.permissionsex.ext.kotlin.collections.ArraysKt;
import ca.stellardrift.permissionsex.ext.kotlin.collections.CollectionsKt;
import ca.stellardrift.permissionsex.ext.kotlin.collections.MapsKt;
import ca.stellardrift.permissionsex.ext.kotlin.jvm.functions.Function0;
import ca.stellardrift.permissionsex.ext.kotlin.jvm.functions.Function1;
import ca.stellardrift.permissionsex.ext.kotlin.jvm.internal.Intrinsics;
import ca.stellardrift.permissionsex.ext.kotlin.jvm.internal.Reflection;
import ca.stellardrift.permissionsex.ext.kotlin.sequences.Sequence;
import ca.stellardrift.permissionsex.ext.kotlin.sequences.SequencesKt;
import ca.stellardrift.permissionsex.ext.kotlin.text.StringsKt;
import ca.stellardrift.permissionsex.ext.net.kyori.adventure.text.Component;
import ca.stellardrift.permissionsex.ext.net.kyori.adventure.text.TextComponent;
import ca.stellardrift.permissionsex.ext.net.kyori.adventure.text.TranslatableComponent;
import ca.stellardrift.permissionsex.ext.org.jetbrains.annotations.NotNull;
import ca.stellardrift.permissionsex.impl.commands.commander.Commander;
import ca.stellardrift.permissionsex.impl.commands.parse.CommandArgs;
import ca.stellardrift.permissionsex.impl.commands.parse.CommandContext;
import ca.stellardrift.permissionsex.impl.commands.parse.CommandElement;
import ca.stellardrift.permissionsex.impl.commands.parse.EnumArgument;
import ca.stellardrift.permissionsex.impl.commands.parse.IntVal;
import ca.stellardrift.permissionsex.impl.commands.parse.Messages;
import ca.stellardrift.permissionsex.impl.commands.parse.RawRemainingArguments;
import ca.stellardrift.permissionsex.impl.commands.parse.RemainingJoinedStrings;
import ca.stellardrift.permissionsex.impl.commands.parse.StrVal;
import ca.stellardrift.permissionsex.impl.commands.parse.Uuid;
import ca.stellardrift.permissionsex.impl.commands.parse.Value;
import ca.stellardrift.permissionsex.impl.commands.parse.ValuesKt;
import ca.stellardrift.permissionsex.util.TextExtensionsKt;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=2, d1={"\u0000X\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u001a8\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u0001\"\u0004\b\u0000\u0010\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u0002H\u000f0\u00042\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u0002\u001a!\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u0001\"\u0010\b\u0000\u0010\u000f\u0018\u0001*\b\u0012\u0004\u0012\u0002H\u000f0\u0015H\u0086\b\u001a\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u0001\u001a%\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0012\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u001a\"\u00020\u0005\u00a2\u0006\u0002\u0010\u001b\u001a3\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u001c0\u0001\"\u0004\b\u0000\u0010\u001c2\u0012\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u001a\"\u00020\u00052\u0006\u0010\u001d\u001a\u0002H\u001c\u00a2\u0006\u0002\u0010\u001e\u001a\u0006\u0010\u001f\u001a\u00020 \u001a\u0016\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00050\u00012\b\b\u0002\u0010\"\u001a\u00020\u0002\u001a\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00050\u0001\u001a*\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00050\u00012\u0012\u0010%\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050'0&2\b\b\u0002\u0010\u0011\u001a\u00020\u0012\u001a\f\u0010(\u001a\b\u0012\u0004\u0012\u00020)0\u0001\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0019\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\"\u0019\u0010\u000b\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\n\u00a8\u0006*"}, d2={"BOOLEAN", "Lca/stellardrift/permissionsex/impl/commands/parse/Value;", "", "BOOLEAN_CHOICES", "", "", "ELIPSES", "Lca/stellardrift/permissionsex/ext/net/kyori/adventure/text/TextComponent;", "Lorg/checkerframework/checker/nullness/qual/NonNull;", "getELIPSES", "()Lnet/kyori/adventure/text/TextComponent;", "PIPE", "getPIPE", "boolean", "choices", "T", "values", "description", "Lca/stellardrift/permissionsex/ext/net/kyori/adventure/text/Component;", "valuesInUsage", "enum", "", "int", "", "literal", "elements", "", "([Ljava/lang/String;)Lca/stellardrift/permissionsex/impl/commands/parse/Value;", "V", "putValue", "([Ljava/lang/String;Ljava/lang/Object;)Lca/stellardrift/permissionsex/impl/commands/parse/Value;", "none", "Lca/stellardrift/permissionsex/impl/commands/parse/CommandElement;", "remainingJoinedStrings", "raw", "string", "suggestibleString", "completions", "Lca/stellardrift/permissionsex/ext/kotlin/Function0;", "Lca/stellardrift/permissionsex/ext/kotlin/sequences/Sequence;", "uuid", "Ljava/util/UUID;", "core"})
public final class ValuesKt {
    @NotNull
    private static final TextComponent PIPE = TextExtensionsKt.unaryPlus("|");
    @NotNull
    private static final TextComponent ELIPSES = TextExtensionsKt.unaryPlus("\u2026");
    private static final Map<String, Boolean> BOOLEAN_CHOICES = MapsKt.mapOf(TuplesKt.to("true", true), TuplesKt.to("t", true), TuplesKt.to("y", true), TuplesKt.to("yes", true), TuplesKt.to("verymuchso", true), TuplesKt.to("false", false), TuplesKt.to("f", false), TuplesKt.to("n", false), TuplesKt.to("no", false), TuplesKt.to("notatall", false));
    private static final Value<Boolean> BOOLEAN = ValuesKt.choices(BOOLEAN_CHOICES, TextExtensionsKt.unaryPlus("a true or false value"), false);

    @NotNull
    public static final TextComponent getPIPE() {
        return PIPE;
    }

    @NotNull
    public static final TextComponent getELIPSES() {
        return ELIPSES;
    }

    @NotNull
    public static final CommandElement none() {
        return new CommandElement(){

            public void parse(@NotNull CommandArgs args2, @NotNull CommandContext context) {
                Intrinsics.checkNotNullParameter(args2, "args");
                Intrinsics.checkNotNullParameter(context, "context");
            }

            @NotNull
            public List<String> tabComplete(@NotNull Commander src, @NotNull CommandArgs args2, @NotNull CommandContext context) {
                Intrinsics.checkNotNullParameter(src, "src");
                Intrinsics.checkNotNullParameter(args2, "args");
                Intrinsics.checkNotNullParameter(context, "context");
                return CollectionsKt.emptyList();
            }

            @NotNull
            public Component getUsage(@NotNull Commander src) {
                Intrinsics.checkNotNullParameter(src, "src");
                TextComponent textComponent = Component.empty();
                Intrinsics.checkNotNullExpressionValue(textComponent, "empty()");
                return textComponent;
            }
        };
    }

    @NotNull
    public static final <T> Value<T> choices(@NotNull Map<String, ? extends T> values, @NotNull Component description, boolean valuesInUsage) {
        Intrinsics.checkNotNullParameter(values, "values");
        Intrinsics.checkNotNullParameter(description, "description");
        return new Value<T>(values, valuesInUsage, description, description){
            final /* synthetic */ Map $values;
            final /* synthetic */ boolean $valuesInUsage;
            final /* synthetic */ Component $description;

            public T parse(@NotNull CommandArgs args2) {
                Intrinsics.checkNotNullParameter(args2, "args");
                V v = this.$values.get(args2.next());
                if (v == null) {
                    TranslatableComponent translatableComponent = Messages.CHOICES_ERROR_INVALID.tr(this.$values.keySet().toString());
                    Intrinsics.checkNotNullExpressionValue(translatableComponent, "Messages.CHOICES_ERROR_I\u2026r(values.keys.toString())");
                    throw (Throwable)args2.createError(translatableComponent);
                }
                return (T)v;
            }

            @NotNull
            public Sequence<String> tabComplete(@NotNull Commander src, @NotNull CommandArgs args2) {
                Intrinsics.checkNotNullParameter(src, "src");
                Intrinsics.checkNotNullParameter(args2, "args");
                String string = args2.nextIfPresent();
                if (string == null) {
                    string = "";
                }
                String prefix = string;
                return SequencesKt.filter(CollectionsKt.asSequence((Iterable)this.$values.keySet()), (Function1)new Function1<String, Boolean>(prefix){
                    final /* synthetic */ String $prefix;

                    public final boolean invoke(@NotNull String it) {
                        Intrinsics.checkNotNullParameter(it, "it");
                        return StringsKt.startsWith(it, this.$prefix, true);
                    }
                    {
                        this.$prefix = string;
                        super(1);
                    }
                });
            }

            @NotNull
            public Component usage(@NotNull Component key) {
                Intrinsics.checkNotNullParameter(key, "key");
                return this.$valuesInUsage ? TextExtensionsKt.join((Iterable<? extends Object>)this.$values.keySet(), (Component)ValuesKt.getPIPE()) : key;
            }
            {
                this.$values = $captured_local_variable$0;
                this.$valuesInUsage = $captured_local_variable$1;
                this.$description = $captured_local_variable$2;
                super($super_call_param$3);
            }
        };
    }

    public static /* synthetic */ Value choices$default(Map map, Component component, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = map.size() < 5;
        }
        return ValuesKt.choices(map, component, bl);
    }

    @NotNull
    public static final Value<String> string() {
        return StrVal.INSTANCE;
    }

    @NotNull
    public static final Value<Integer> int() {
        return IntVal.INSTANCE;
    }

    @NotNull
    public static final Value<UUID> uuid() {
        return Uuid.INSTANCE;
    }

    @NotNull
    public static final Value<Boolean> boolean() {
        return BOOLEAN;
    }

    public static final /* synthetic */ <T extends Enum<T>> Value<T> enum() {
        int $i$f$enum = 0;
        StringBuilder stringBuilder = new StringBuilder().append("values of ");
        Intrinsics.reifiedOperationMarker(4, "T");
        Component component = TextExtensionsKt.unaryPlus(stringBuilder.append(Reflection.getOrCreateKotlinClass(Enum.class).getSimpleName()).toString());
        Intrinsics.needClassReification();
        Function1 function1 = enum.1.INSTANCE;
        Intrinsics.needClassReification();
        return new EnumArgument(component, function1, enum.2.INSTANCE);
    }

    @NotNull
    public static final Value<String> remainingJoinedStrings(boolean raw) {
        return raw ? (Value)RawRemainingArguments.INSTANCE : (Value)RemainingJoinedStrings.INSTANCE;
    }

    public static /* synthetic */ Value remainingJoinedStrings$default(boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return ValuesKt.remainingJoinedStrings(bl);
    }

    @NotNull
    public static final Value<Boolean> literal(String ... elements) {
        Intrinsics.checkNotNullParameter(elements, "elements");
        return ValuesKt.literal(Arrays.copyOf(elements, elements.length), true);
    }

    @NotNull
    public static final <V> Value<V> literal(@NotNull String[] elements, V putValue) {
        Intrinsics.checkNotNullParameter(elements, "elements");
        return new Value<V>(elements, putValue, TextExtensionsKt.unaryPlus("The literal text " + ArraysKt.joinToString$default(elements, (CharSequence)" ", null, null, 0, null, null, 62, null))){
            final /* synthetic */ String[] $elements;
            final /* synthetic */ Object $putValue;

            public V parse(@NotNull CommandArgs args2) {
                Intrinsics.checkNotNullParameter(args2, "args");
                for (String arg : this.$elements) {
                    String current = args2.next();
                    if (StringsKt.equals(current, arg, true)) continue;
                    TranslatableComponent translatableComponent = Messages.LITERAL_ERROR_INVALID.tr(current, arg);
                    Intrinsics.checkNotNullExpressionValue(translatableComponent, "Messages.LITERAL_ERROR_INVALID.tr(current, arg)");
                    throw (Throwable)args2.createError(translatableComponent);
                }
                return (V)this.$putValue;
            }

            @NotNull
            public Sequence<String> tabComplete(@NotNull Commander src, @NotNull CommandArgs args2) {
                Intrinsics.checkNotNullParameter(src, "src");
                Intrinsics.checkNotNullParameter(args2, "args");
                for (String arg : this.$elements) {
                    String next = args2.nextIfPresent();
                    if (next == null) {
                        return SequencesKt.sequenceOf(arg);
                    }
                    if (args2.hasNext()) {
                        if (StringsKt.equals(next, arg, true)) continue;
                        break;
                    }
                    String string = next;
                    boolean bl = false;
                    String string2 = string.toLowerCase();
                    Intrinsics.checkNotNullExpressionValue(string2, "(this as java.lang.String).toLowerCase()");
                    if (!StringsKt.startsWith(arg, string2, true)) continue;
                    return SequencesKt.sequenceOf(arg);
                }
                return SequencesKt.sequenceOf(new String[0]);
            }
            {
                this.$elements = $captured_local_variable$0;
                this.$putValue = $captured_local_variable$1;
                super($super_call_param$2);
            }
        };
    }

    @NotNull
    public static final Value<String> suggestibleString(@NotNull Function0<? extends Sequence<String>> completions, @NotNull Component description) {
        Intrinsics.checkNotNullParameter(completions, "completions");
        Intrinsics.checkNotNullParameter(description, "description");
        return new Value<String>(completions, description, description){
            final /* synthetic */ Function0 $completions;
            final /* synthetic */ Component $description;

            @NotNull
            public String parse(@NotNull CommandArgs args2) {
                Intrinsics.checkNotNullParameter(args2, "args");
                return args2.next();
            }

            @NotNull
            public Sequence<String> tabComplete(@NotNull Commander src, @NotNull CommandArgs args2) {
                Intrinsics.checkNotNullParameter(src, "src");
                Intrinsics.checkNotNullParameter(args2, "args");
                String string = args2.nextIfPresent();
                if (string == null) {
                    return SequencesKt.emptySequence();
                }
                String next = string;
                return SequencesKt.filter((Sequence)this.$completions.invoke(), (Function1)new Function1<String, Boolean>(next){
                    final /* synthetic */ String $next;

                    public final boolean invoke(@NotNull String it) {
                        Intrinsics.checkNotNullParameter(it, "it");
                        return StringsKt.startsWith(it, this.$next, true);
                    }
                    {
                        this.$next = string;
                        super(1);
                    }
                });
            }
            {
                this.$completions = $captured_local_variable$0;
                this.$description = $captured_local_variable$1;
                super($super_call_param$2);
            }
        };
    }

    public static /* synthetic */ Value suggestibleString$default(Function0 function0, Component component, int n, Object object) {
        if ((n & 2) != 0) {
            component = TextExtensionsKt.unaryPlus("a value");
        }
        return ValuesKt.suggestibleString(function0, component);
    }
}

