/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.impl.config;

import ca.stellardrift.permissionsex.datastore.DataStore;
import ca.stellardrift.permissionsex.datastore.DataStoreFactory;
import ca.stellardrift.permissionsex.exception.PermissionsLoadingException;
import ca.stellardrift.permissionsex.ext.org.spongepowered.configurate.ConfigurationNode;
import ca.stellardrift.permissionsex.ext.org.spongepowered.configurate.serialize.SerializationException;
import ca.stellardrift.permissionsex.ext.org.spongepowered.configurate.serialize.TypeSerializer;
import java.lang.reflect.Type;
import org.checkerframework.checker.nullness.qual.Nullable;

public class DataStoreSerializer
implements TypeSerializer<DataStore> {
    @Override
    public DataStore deserialize(Type type, ConfigurationNode value) throws SerializationException {
        String dataStoreType = value.node("type").getString(value.key().toString());
        @Nullable DataStoreFactory factory = DataStoreFactory.forType(dataStoreType);
        if (factory == null) {
            throw new SerializationException("Unknown DataStore type " + dataStoreType);
        }
        try {
            return factory.create(value.key().toString(), value);
        }
        catch (PermissionsLoadingException e) {
            throw new SerializationException(e);
        }
    }

    @Override
    public void serialize(Type type, DataStore store, ConfigurationNode value) throws SerializationException {
        try {
            value.node("type").set(store.serialize(value));
        }
        catch (PermissionsLoadingException e) {
            throw new SerializationException(e);
        }
    }
}

