/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.impl.config;

import ca.stellardrift.permissionsex.datastore.DataStore;
import ca.stellardrift.permissionsex.exception.PEBKACException;
import ca.stellardrift.permissionsex.exception.PermissionsException;
import ca.stellardrift.permissionsex.ext.io.leangen.geantyref.TypeFactory;
import ca.stellardrift.permissionsex.ext.io.leangen.geantyref.TypeToken;
import ca.stellardrift.permissionsex.ext.kotlin.Unit;
import ca.stellardrift.permissionsex.ext.org.spongepowered.configurate.ConfigurateException;
import ca.stellardrift.permissionsex.ext.org.spongepowered.configurate.ConfigurationNode;
import ca.stellardrift.permissionsex.ext.org.spongepowered.configurate.ConfigurationOptions;
import ca.stellardrift.permissionsex.ext.org.spongepowered.configurate.hocon.HoconConfigurationLoader;
import ca.stellardrift.permissionsex.ext.org.spongepowered.configurate.loader.ConfigurationLoader;
import ca.stellardrift.permissionsex.ext.org.spongepowered.configurate.objectmapping.ConfigSerializable;
import ca.stellardrift.permissionsex.ext.org.spongepowered.configurate.objectmapping.ObjectMapper;
import ca.stellardrift.permissionsex.ext.org.spongepowered.configurate.objectmapping.meta.NodeResolver;
import ca.stellardrift.permissionsex.ext.org.spongepowered.configurate.objectmapping.meta.Setting;
import ca.stellardrift.permissionsex.ext.org.spongepowered.configurate.serialize.SerializationException;
import ca.stellardrift.permissionsex.ext.org.spongepowered.configurate.serialize.TypeSerializerCollection;
import ca.stellardrift.permissionsex.ext.org.spongepowered.configurate.util.CheckedSupplier;
import ca.stellardrift.permissionsex.impl.config.ConfigTransformations;
import ca.stellardrift.permissionsex.impl.config.DataStoreSerializer;
import ca.stellardrift.permissionsex.impl.config.Messages;
import ca.stellardrift.permissionsex.impl.config.PermissionsExConfiguration;
import ca.stellardrift.permissionsex.impl.config.SupplierSerializer;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

@ConfigSerializable
public class FilePermissionsExConfiguration<T>
implements PermissionsExConfiguration<T> {
    private static final TypeSerializerCollection PEX_SERIALIZERS = FilePermissionsExConfiguration.populateSerializers(TypeSerializerCollection.defaults().childBuilder()).build();
    public static final ConfigurationOptions PEX_OPTIONS = ConfigurationOptions.defaults().implicitInitialization(true).shouldCopyDefaults(true).serializers(PEX_SERIALIZERS);
    private final ConfigurationLoader<?> loader;
    private final ConfigurationNode node;
    private final Class<T> platformConfigClass;
    private @MonotonicNonNull Instance<T> instance;

    public static ConfigurationOptions decorateOptions(ConfigurationOptions input) {
        return input.implicitInitialization(true).shouldCopyDefaults(true).serializers(PEX_SERIALIZERS);
    }

    protected FilePermissionsExConfiguration(ConfigurationLoader<?> loader, ConfigurationNode node, Class<T> platformConfigClass) {
        this.loader = loader;
        this.node = node;
        this.platformConfigClass = platformConfigClass;
    }

    public static FilePermissionsExConfiguration<Unit> fromLoader(ConfigurationLoader<?> loader) throws ConfigurateException {
        return FilePermissionsExConfiguration.fromLoader(loader, Unit.class);
    }

    public static TypeSerializerCollection.Builder populateSerializers(TypeSerializerCollection.Builder coll) {
        return coll.register(DataStore.class, new DataStoreSerializer()).register(new TypeToken<CheckedSupplier<?, SerializationException>>(){}, SupplierSerializer.INSTANCE).registerAnnotatedObjects(ObjectMapper.factoryBuilder().addNodeResolver(NodeResolver.onlyWithSetting()).build());
    }

    public static <T> FilePermissionsExConfiguration<T> fromLoader(ConfigurationLoader<?> loader, Class<T> platformConfigClass) throws ConfigurateException {
        ConfigurationNode fallbackConfig;
        Object node = loader.load(loader.defaultOptions().serializers(PEX_SERIALIZERS).implicitInitialization(true).shouldCopyDefaults(true));
        try {
            fallbackConfig = FilePermissionsExConfiguration.loadDefaultConfiguration();
        }
        catch (ConfigurateException e) {
            throw new Error("PEX's default configuration could not be loaded!", e);
        }
        ConfigTransformations.versions().apply((ConfigurationNode)node);
        node.mergeFrom(fallbackConfig);
        ConfigurationNode defBackendNode = node.node("default-backend");
        if (defBackendNode.empty()) {
            defBackendNode.set("default-file");
        }
        FilePermissionsExConfiguration<T> config = new FilePermissionsExConfiguration<T>(loader, (ConfigurationNode)node, platformConfigClass);
        super.load();
        return config;
    }

    private void load() throws ConfigurateException {
        this.instance = (Instance)this.node.get(TypeFactory.parameterizedClass(Instance.class, this.platformConfigClass));
        this.instance.platform = this.platformConfigClass == Unit.class ? Unit.INSTANCE : this.platformConfigNode().get(this.platformConfigClass);
        this.loader.save(this.node);
    }

    @Override
    public void save() throws IOException {
        this.node.set(TypeFactory.parameterizedClass(Instance.class, this.platformConfigClass), this.instance);
        if (this.platformConfigClass != Unit.class) {
            this.platformConfigNode().set(this.platformConfigClass, this.instance.platform);
        }
        this.loader.save(this.node);
    }

    private ConfigurationNode platformConfigNode() {
        return this.node.node("platform");
    }

    @Override
    public DataStore getDataStore(String name) {
        return (DataStore)((Instance)this.instance).backends.get(name);
    }

    @Override
    public DataStore getDefaultDataStore() {
        return (DataStore)((Instance)this.instance).backends.get(((Instance)this.instance).defaultBackend);
    }

    @Override
    public boolean isDebugEnabled() {
        return ((Instance)this.instance).debug;
    }

    @Override
    public List<String> getServerTags() {
        return Collections.unmodifiableList(((Instance)this.instance).serverTags);
    }

    @Override
    public void validate() throws PEBKACException {
        this.instance.validate();
    }

    @Override
    public T getPlatformConfig() {
        return this.instance.platform;
    }

    @Override
    public FilePermissionsExConfiguration<T> reload() throws IOException {
        try {
            Object node = this.loader.load();
            FilePermissionsExConfiguration<T> ret = new FilePermissionsExConfiguration<T>(this.loader, (ConfigurationNode)node, this.platformConfigClass);
            super.load();
            return ret;
        }
        catch (ConfigurateException ex) {
            throw new IOException(ex);
        }
    }

    public static ConfigurationNode loadDefaultConfiguration() throws ConfigurateException {
        URL defaultConfig = FilePermissionsExConfiguration.class.getResource("default.conf");
        if (defaultConfig == null) {
            throw new Error(new PermissionsException(Messages.CONFIG_ERROR_DEFAULT_CONFIG.tr(new Object[0])));
        }
        HoconConfigurationLoader fallbackLoader = ((HoconConfigurationLoader.Builder)((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().defaultOptions(FilePermissionsExConfiguration::decorateOptions)).url(defaultConfig)).build();
        return fallbackLoader.load();
    }

    @ConfigSerializable
    static class Instance<T> {
        @Setting
        private Map<String, DataStore> backends;
        @Setting
        private String defaultBackend;
        @Setting
        private boolean debug;
        @Setting
        private List<String> serverTags;
        T platform;

        Instance() {
        }

        void validate() throws PEBKACException {
            if (this.backends.isEmpty()) {
                throw new PEBKACException(Messages.CONFIG_ERROR_NO_BACKENDS.tr(new Object[0]));
            }
            if (this.defaultBackend == null) {
                throw new PEBKACException(Messages.CONFIG_ERROR_NO_DEFAULT.tr(new Object[0]));
            }
            if (!this.backends.containsKey(this.defaultBackend)) {
                throw new PEBKACException(Messages.CONFIG_ERROR_INVALID_DEFAULT.tr(this.defaultBackend, this.backends.keySet()));
            }
        }
    }
}

