/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.impl.context;

import ca.stellardrift.permissionsex.impl.config.PermissionsExConfiguration;
import ca.stellardrift.permissionsex.impl.context.PEXContextDefinition;
import ca.stellardrift.permissionsex.impl.context.TimeContextParser;
import ca.stellardrift.permissionsex.subject.CalculatedSubject;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class TimeContextDefinition
extends PEXContextDefinition<ZonedDateTime> {
    public static final TimeContextDefinition BEFORE_TIME = new TimeContextDefinition("before-time", ChronoZonedDateTime::isBefore);
    public static final TimeContextDefinition AFTER_TIME = new TimeContextDefinition("after-time", ChronoZonedDateTime::isAfter);
    private final ZoneId currentTimeZone = ZoneId.systemDefault();
    private final TimeContextParser[] timeParsers = TimeContextParser.parsersForZone(this.currentTimeZone);
    private final BiPredicate<ZonedDateTime, ZonedDateTime> comparisonFunc;

    private TimeContextDefinition(String name, BiPredicate<ZonedDateTime, ZonedDateTime> comparisonFunc) {
        super(name);
        this.comparisonFunc = comparisonFunc;
    }

    static boolean compare(ZonedDateTime a, ZonedDateTime b, BiPredicate<ZonedDateTime, ZonedDateTime> test) {
        return test.test(a.truncatedTo(ChronoUnit.SECONDS), b.truncatedTo(ChronoUnit.SECONDS));
    }

    @Override
    public String serialize(ZonedDateTime canonicalValue) {
        return canonicalValue.format(DateTimeFormatter.ISO_DATE_TIME);
    }

    @Override
    public @Nullable ZonedDateTime deserialize(String userValue) {
        for (TimeContextParser parser : this.timeParsers) {
            ZonedDateTime attempt = parser.parse(userValue);
            if (attempt == null) continue;
            return attempt;
        }
        throw new IllegalArgumentException("Could not deserialize time from input " + userValue + " using any known methods.");
    }

    @Override
    public boolean matches(ZonedDateTime ownVal, ZonedDateTime testVal) {
        return TimeContextDefinition.compare(testVal, ownVal, this.comparisonFunc);
    }

    @Override
    public void accumulateCurrentValues(CalculatedSubject subject2, Consumer<ZonedDateTime> consumer) {
        consumer.accept(ZonedDateTime.now(this.currentTimeZone).truncatedTo(ChronoUnit.SECONDS));
    }

    @Override
    public void update(PermissionsExConfiguration<?> config) {
    }
}

