/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.impl.data;

import ca.stellardrift.permissionsex.PermissionsEngine;
import ca.stellardrift.permissionsex.datastore.DataStore;
import ca.stellardrift.permissionsex.ext.com.github.benmanes.caffeine.cache.AsyncLoadingCache;
import ca.stellardrift.permissionsex.ext.com.github.benmanes.caffeine.cache.Caffeine;
import ca.stellardrift.permissionsex.ext.com.google.errorprone.annotations.concurrent.LazyInit;
import ca.stellardrift.permissionsex.impl.data.CacheListenerHolder;
import ca.stellardrift.permissionsex.impl.data.ToDataSubjectRefImpl;
import ca.stellardrift.permissionsex.subject.ImmutableSubjectData;
import ca.stellardrift.permissionsex.subject.InvalidIdentifierException;
import ca.stellardrift.permissionsex.subject.SubjectDataCache;
import ca.stellardrift.permissionsex.subject.SubjectRef;
import ca.stellardrift.permissionsex.subject.SubjectType;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class SubjectDataCacheImpl<I>
implements SubjectDataCache<I> {
    private final SubjectType<I> type;
    @LazyInit
    private DataStore dataStore;
    private final AtomicReference<AsyncLoadingCache<I, ImmutableSubjectData>> cache = new AtomicReference();
    private final Map<I, Consumer<ImmutableSubjectData>> cacheHolders = new ConcurrentHashMap<I, Consumer<ImmutableSubjectData>>();
    private final CacheListenerHolder<I, ImmutableSubjectData> listeners;
    private final SubjectRef<String> defaultIdentifier;

    public SubjectDataCacheImpl(SubjectType<I> type, DataStore dataStore) {
        this.type = type;
        this.update(dataStore);
        this.defaultIdentifier = SubjectRef.subject(PermissionsEngine.SUBJECTS_DEFAULTS, type.name());
        this.listeners = new CacheListenerHolder();
    }

    @EnsuresNonNull(value={"this.dataStore"})
    public void update(DataStore newDataStore) {
        this.dataStore = newDataStore;
        AsyncLoadingCache oldCache = this.cache.getAndSet(Caffeine.newBuilder().maximumSize(512L).buildAsync((key, executor2) -> this.dataStore.getData(this.type.name(), this.type.serializeIdentifier(key), this.clearListener(key))));
        if (oldCache != null) {
            oldCache.synchronous().asMap().forEach((k, v) -> this.data(k, null).thenAccept(data -> this.listeners.call((I)k, (ImmutableSubjectData)data)));
        }
    }

    @Override
    public CompletableFuture<ImmutableSubjectData> data(I identifier, @Nullable Consumer<ImmutableSubjectData> listener) {
        Objects.requireNonNull(identifier, "identifier");
        CompletableFuture<ImmutableSubjectData> ret = this.cache.get().get(identifier);
        ret.thenRun(() -> {
            if (listener != null) {
                this.listeners.addListener(identifier, listener);
            }
        });
        return ret;
    }

    @Override
    public CompletableFuture<ToDataSubjectRefImpl<I>> referenceTo(I identifier) {
        return this.referenceTo(identifier, true);
    }

    @Override
    public CompletableFuture<ToDataSubjectRefImpl<I>> referenceTo(I identifier, boolean strongListeners) {
        ToDataSubjectRefImpl ref = new ToDataSubjectRefImpl(identifier, this, strongListeners);
        return this.data(identifier, ref).thenApply(data -> {
            ref.data.set((ImmutableSubjectData)data);
            return ref;
        });
    }

    @Override
    public CompletableFuture<ImmutableSubjectData> update(I identifier, UnaryOperator<ImmutableSubjectData> action) {
        return this.data(identifier, null).thenCompose(data -> {
            ImmutableSubjectData newData = (ImmutableSubjectData)action.apply((ImmutableSubjectData)data);
            if (data != newData) {
                return this.set(identifier, newData);
            }
            return CompletableFuture.completedFuture(data);
        });
    }

    @Override
    public void load(I identifier) {
        Objects.requireNonNull(identifier, "identifier");
        this.cache.get().get(identifier);
    }

    @Override
    public void invalidate(I identifier) {
        Objects.requireNonNull(identifier, "identifier");
        this.cache.get().synchronous().invalidate(identifier);
        this.cacheHolders.remove(identifier);
        this.listeners.removeAll(identifier);
    }

    @Override
    public void cacheAll() {
        for (String ident : this.dataStore.getAllIdentifiers(this.type.name())) {
            try {
                this.cache.get().synchronous().refresh(this.type.parseIdentifier(ident));
            }
            catch (InvalidIdentifierException invalidIdentifierException) {}
        }
    }

    @Override
    public CompletableFuture<Boolean> isRegistered(I identifier) {
        Objects.requireNonNull(identifier, "identifier");
        return this.dataStore.isRegistered(this.type.name(), this.type.serializeIdentifier(identifier));
    }

    @Override
    public CompletableFuture<ImmutableSubjectData> remove(I identifier) {
        return this.set(identifier, null);
    }

    @Override
    public CompletableFuture<ImmutableSubjectData> set(I identifier, @Nullable ImmutableSubjectData newData) {
        Objects.requireNonNull(identifier, "identifier");
        return this.dataStore.setData(this.type.name(), this.type.serializeIdentifier(identifier), newData);
    }

    private Consumer<ImmutableSubjectData> clearListener(I name) {
        Consumer<ImmutableSubjectData> ret = newData -> {
            this.cache.get().put(name, CompletableFuture.completedFuture(newData));
            this.listeners.call(name, (ImmutableSubjectData)newData);
        };
        this.cacheHolders.put(name, ret);
        return ret;
    }

    @Override
    public void addListener(I identifier, Consumer<ImmutableSubjectData> listener) {
        Objects.requireNonNull(identifier, "identifier");
        Objects.requireNonNull(listener, "listener");
        this.listeners.addListener(identifier, listener);
    }

    @Override
    public SubjectType<I> type() {
        return this.type;
    }

    @Override
    public Stream<I> getAllIdentifiers() {
        return this.dataStore.getAllIdentifiers(this.type.name()).stream().map(this.type::parseIdentifier);
    }

    @Override
    public SubjectRef<String> getDefaultIdentifier() {
        return this.defaultIdentifier;
    }
}

