/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.impl.data;

import ca.stellardrift.permissionsex.impl.data.SubjectDataCacheImpl;
import ca.stellardrift.permissionsex.subject.ImmutableSubjectData;
import ca.stellardrift.permissionsex.subject.SubjectRef;
import ca.stellardrift.permissionsex.subject.SubjectType;
import ca.stellardrift.permissionsex.util.Change;
import com.google.common.collect.MapMaker;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;

public class ToDataSubjectRefImpl<I>
implements Consumer<ImmutableSubjectData>,
SubjectRef.ToData<I> {
    private final I identifier;
    private final SubjectDataCacheImpl<I> cache;
    private final Set<Consumer<ImmutableSubjectData>> updateListeners;
    final AtomicReference<ImmutableSubjectData> data = new AtomicReference();
    private final boolean strongListeners;

    ToDataSubjectRefImpl(I identifier, SubjectDataCacheImpl<I> cache, boolean strongListeners) {
        this.identifier = identifier;
        this.cache = cache;
        this.strongListeners = strongListeners;
        this.updateListeners = strongListeners ? Collections.newSetFromMap(new ConcurrentHashMap()) : Collections.newSetFromMap(new MapMaker().weakKeys().concurrencyLevel(10).makeMap());
    }

    @Override
    public SubjectType<I> type() {
        return this.cache.type();
    }

    @Override
    public I identifier() {
        return this.identifier;
    }

    @Override
    public ImmutableSubjectData get() {
        return this.data.get();
    }

    @Override
    public CompletableFuture<Change<ImmutableSubjectData>> update(UnaryOperator<ImmutableSubjectData> modifierFunc) {
        ImmutableSubjectData newData;
        ImmutableSubjectData data;
        do {
            if ((newData = (ImmutableSubjectData)modifierFunc.apply(data = this.get())) != data) continue;
            return CompletableFuture.completedFuture(Change.of(data, newData));
        } while (!this.data.compareAndSet(data, newData));
        ImmutableSubjectData finalData = data;
        return this.cache.set(this.identifier, newData).thenApply(finalNew -> Change.of(finalData, finalNew));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void accept(ImmutableSubjectData newData) {
        AtomicReference<ImmutableSubjectData> atomicReference = this.data;
        synchronized (atomicReference) {
            this.data.set(newData);
            this.updateListeners.forEach(cb -> cb.accept(newData));
        }
    }

    @Override
    public boolean holdsListenersStrongly() {
        return this.strongListeners;
    }

    @Override
    public void onUpdate(Consumer<ImmutableSubjectData> listener) {
        this.updateListeners.add(listener);
    }

    public SubjectDataCacheImpl<I> getCache() {
        return this.cache;
    }

    @Override
    public CompletableFuture<Boolean> isRegistered() {
        return this.getCache().isRegistered(this.identifier);
    }

    @Override
    public CompletableFuture<ImmutableSubjectData> remove() {
        return this.getCache().remove(this.identifier);
    }
}

