/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.impl.logging;

import ca.stellardrift.permissionsex.context.ContextValue;
import ca.stellardrift.permissionsex.ext.org.jetbrains.annotations.Nullable;
import ca.stellardrift.permissionsex.impl.logging.Messages;
import ca.stellardrift.permissionsex.logging.FormattedLogger;
import ca.stellardrift.permissionsex.logging.PermissionCheckNotifier;
import ca.stellardrift.permissionsex.subject.SubjectRef;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;

public class DebugPermissionCheckNotifier
implements PermissionCheckNotifier {
    private final FormattedLogger logger;
    private final PermissionCheckNotifier delegate;
    private final Predicate<String> filterPredicate;

    public DebugPermissionCheckNotifier(FormattedLogger logger, PermissionCheckNotifier delegate, @Nullable Predicate<String> filterPredicate) {
        this.logger = logger;
        this.delegate = delegate;
        this.filterPredicate = filterPredicate == null ? x -> true : filterPredicate;
    }

    private <I> String stringIdentifier(SubjectRef<I> identifier) {
        return identifier.type().name() + " " + identifier.type().serializeIdentifier(identifier.identifier());
    }

    public PermissionCheckNotifier getDelegate() {
        return this.delegate;
    }

    @Override
    public void onPermissionCheck(SubjectRef<?> subject2, Set<ContextValue<?>> contexts, String permission2, int value) {
        if (this.filterPredicate.test(permission2)) {
            this.logger.info(Messages.CHECK_PERMISSION.tr(permission2, contexts, this.stringIdentifier(subject2), value));
        }
        this.delegate.onPermissionCheck(subject2, contexts, permission2, value);
    }

    @Override
    public void onOptionCheck(SubjectRef<?> subject2, Set<ContextValue<?>> contexts, String option2, String value) {
        if (this.filterPredicate.test(option2)) {
            this.logger.info(Messages.CHECK_OPTION.tr(option2, contexts, this.stringIdentifier(subject2), value));
        }
        this.delegate.onOptionCheck(subject2, contexts, option2, value);
    }

    @Override
    public void onParentCheck(SubjectRef<?> subject2, Set<ContextValue<?>> contexts, List<Map.Entry<String, String>> parents) {
        this.logger.info(Messages.CHECK_PARENT.tr(contexts, this.stringIdentifier(subject2), parents));
        this.delegate.onParentCheck(subject2, contexts, parents);
    }
}

