/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.impl.rank;

import ca.stellardrift.permissionsex.context.ContextValue;
import ca.stellardrift.permissionsex.ext.net.kyori.adventure.text.Component;
import ca.stellardrift.permissionsex.ext.net.kyori.adventure.text.TextComponent;
import ca.stellardrift.permissionsex.ext.net.kyori.adventure.text.event.ClickEvent;
import ca.stellardrift.permissionsex.ext.net.kyori.adventure.text.event.HoverEvent;
import ca.stellardrift.permissionsex.ext.net.kyori.adventure.text.format.TextDecoration;
import ca.stellardrift.permissionsex.impl.rank.Messages;
import ca.stellardrift.permissionsex.rank.RankLadder;
import ca.stellardrift.permissionsex.subject.ImmutableSubjectData;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

public abstract class AbstractRankLadder
implements RankLadder {
    private final String name;

    protected AbstractRankLadder(String name) {
        this.name = name;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public final ImmutableSubjectData promote(Set<ContextValue<?>> contexts, ImmutableSubjectData input) {
        if (this.ranks().isEmpty()) {
            return input;
        }
        List<Map.Entry<String, String>> parents = input.getParents(contexts);
        if (parents.isEmpty()) {
            return input.addParent(contexts, this.ranks().get(0).getKey(), this.ranks().get(0).getValue());
        }
        parents = new ArrayList<Map.Entry<String, String>>(parents);
        boolean found = false;
        ListIterator<Map.Entry<String, String>> it = parents.listIterator();
        while (it.hasNext()) {
            Map.Entry<String, String> parent = it.next();
            int index = this.ranks().indexOf(parent);
            if (index <= -1) continue;
            if (index == this.ranks().size() - 1) {
                return input;
            }
            it.set(this.ranks().get(index + 1));
            found = true;
        }
        if (found) {
            return input.setParents(contexts, parents);
        }
        return input.addParent(contexts, this.ranks().get(0).getKey(), this.ranks().get(0).getValue());
    }

    @Override
    public final ImmutableSubjectData demote(Set<ContextValue<?>> contexts, ImmutableSubjectData input) {
        if (this.ranks().isEmpty()) {
            return input;
        }
        List<Map.Entry<String, String>> parents = input.getParents(contexts);
        if (parents.isEmpty()) {
            return input;
        }
        parents = new ArrayList<Map.Entry<String, String>>(parents);
        boolean found = false;
        ListIterator<Map.Entry<String, String>> it = parents.listIterator();
        while (it.hasNext()) {
            Map.Entry<String, String> parent = it.next();
            int index = this.ranks().indexOf(parent);
            if (index <= -1) continue;
            if (index == 0) {
                it.remove();
            } else {
                it.set(this.ranks().get(index - 1));
            }
            found = true;
        }
        if (found) {
            return input.setParents(contexts, parents);
        }
        return input;
    }

    @Override
    public final boolean isOnLadder(Set<ContextValue<?>> contexts, ImmutableSubjectData subject2) {
        if (this.ranks().isEmpty()) {
            return false;
        }
        for (Map.Entry<String, String> par : subject2.getParents(contexts)) {
            if (this.ranks().indexOf(par) == -1) continue;
            return true;
        }
        return false;
    }

    @Override
    public final int indexOf(Map.Entry<String, String> subject2) {
        return this.ranks().indexOf(subject2);
    }

    @Override
    public final RankLadder with(Map.Entry<String, String> subject2) {
        int indexOf = this.ranks().indexOf(subject2);
        if (indexOf != -1) {
            ArrayList<Map.Entry<String, String>> ents = new ArrayList<Map.Entry<String, String>>(this.ranks());
            ents.remove(indexOf);
            ents.add(subject2);
            return this.newWithRanks(ents);
        }
        return this.newWithRanks((List<Map.Entry<String, String>>)ImmutableList.builder().addAll(this.ranks()).add(subject2).build());
    }

    @Override
    public final RankLadder with(Map.Entry<String, String> subject2, int index) {
        if (index > this.ranks().size() || index < 0) {
            return this;
        }
        int indexOf = this.ranks().indexOf(subject2);
        ArrayList<Map.Entry<String, String>> newEnts = new ArrayList<Map.Entry<String, String>>(this.ranks());
        newEnts.add(index, subject2);
        if (indexOf != -1) {
            if (indexOf >= index) {
                ++indexOf;
            }
            newEnts.remove(indexOf);
        }
        return this.newWithRanks(newEnts);
    }

    @Override
    public final RankLadder without(Map.Entry<String, String> subject2) {
        int indexOf = this.ranks().indexOf(subject2);
        if (indexOf == -1) {
            return this;
        }
        ArrayList<Map.Entry<String, String>> newRanks = new ArrayList<Map.Entry<String, String>>(this.ranks());
        newRanks.remove(indexOf);
        return this.newWithRanks(newRanks);
    }

    @Override
    public abstract List<? extends Map.Entry<String, String>> ranks();

    protected abstract RankLadder newWithRanks(List<Map.Entry<String, String>> var1);

    @Override
    public final Component asComponent() {
        return Component.text(build -> ((TextComponent.Builder)((TextComponent.Builder)build.content(this.name()).decoration(TextDecoration.BOLD, true)).hoverEvent(HoverEvent.showText(Messages.FORMATTER_BUTTON_INFO_PROMPT.tr(new Object[0])))).clickEvent(ClickEvent.runCommand("/pex rank " + this.name())));
    }
}

