/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.impl.subject;

import ca.stellardrift.permissionsex.PermissionsEngine;
import ca.stellardrift.permissionsex.context.ContextValue;
import ca.stellardrift.permissionsex.impl.PermissionsEx;
import ca.stellardrift.permissionsex.impl.data.SubjectDataCacheImpl;
import ca.stellardrift.permissionsex.impl.data.ToDataSubjectRefImpl;
import ca.stellardrift.permissionsex.impl.subject.BakedSubjectData;
import ca.stellardrift.permissionsex.impl.subject.CalculatedSubjectImpl;
import ca.stellardrift.permissionsex.impl.subject.Messages;
import ca.stellardrift.permissionsex.impl.subject.SubjectDataBaker;
import ca.stellardrift.permissionsex.impl.subject.SubjectTypeCollectionImpl;
import ca.stellardrift.permissionsex.impl.util.Util;
import ca.stellardrift.permissionsex.subject.ImmutableSubjectData;
import ca.stellardrift.permissionsex.subject.SubjectRef;
import ca.stellardrift.permissionsex.subject.SubjectType;
import ca.stellardrift.permissionsex.subject.SubjectTypeCollection;
import ca.stellardrift.permissionsex.util.NodeTree;
import ca.stellardrift.permissionsex.util.glob.GlobParseException;
import ca.stellardrift.permissionsex.util.glob.Globs;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Multiset;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;

class InheritanceSubjectDataBaker
implements SubjectDataBaker {
    private static final int CIRCULAR_INHERITANCE_THRESHOLD = 3;
    static final SubjectDataBaker INSTANCE = new InheritanceSubjectDataBaker();

    private InheritanceSubjectDataBaker() {
    }

    private static CompletableFuture<Set<ContextValue<?>>> processContexts(PermissionsEx<?> pex, Set<ContextValue<?>> rawContexts) {
        return pex.getContextInheritance(null).thenApply(inheritance -> {
            ContextValue context;
            ArrayDeque inProgressContexts = new ArrayDeque(rawContexts);
            HashSet<ContextValue> contexts = new HashSet<ContextValue>();
            while ((context = (ContextValue)inProgressContexts.poll()) != null) {
                if (!contexts.add(context)) continue;
                inProgressContexts.addAll(inheritance.parents(context));
            }
            return ImmutableSet.copyOf(contexts);
        });
    }

    @Override
    public CompletableFuture<BakedSubjectData> bake(CalculatedSubjectImpl<?> data, Set<ContextValue<?>> activeContexts) {
        SubjectRef<?> subject2 = data.identifier();
        return ((CompletableFuture)InheritanceSubjectDataBaker.processContexts(data.getManager(), activeContexts).thenCompose(processedContexts -> {
            SubjectRef<String> defIdentifier;
            BakeState state = new BakeState(data, (Set)processedContexts);
            HashMultiset visitedSubjects = HashMultiset.create();
            CompletionStage<Void> ret = this.visitSubject(state, subject2, (Multiset<SubjectRef<?>>)visitedSubjects, 0);
            if (state.parents.isEmpty() && state.combinedPermissions.isEmpty() && state.options.isEmpty() && state.defaultValue == 0 && (!subject2.type().equals(PermissionsEngine.SUBJECTS_FALLBACK) || !subject2.identifier().equals(PermissionsEngine.SUBJECTS_FALLBACK.name()))) {
                ret = ret.thenCompose(arg_0 -> this.lambda$bake$1(state, subject2, (Multiset)visitedSubjects, arg_0));
            }
            if (!subject2.equals(defIdentifier = ((ToDataSubjectRefImpl)data.data()).getCache().getDefaultIdentifier())) {
                ret = ((CompletableFuture)ret.thenCompose(arg_0 -> this.lambda$bake$2(state, defIdentifier, (Multiset)visitedSubjects, arg_0))).thenCompose(arg_0 -> this.lambda$bake$3(state, (Multiset)visitedSubjects, arg_0));
            }
            return ret.thenApply(none2 -> state);
        })).thenApply(state -> new BakedSubjectData(NodeTree.of(((BakeState)state).combinedPermissions, ((BakeState)state).defaultValue), (List<Map.Entry<String, String>>)ImmutableList.copyOf((Collection)((BakeState)state).parents), (Map<String, String>)ImmutableMap.copyOf((Map)((BakeState)state).options)));
    }

    private <I> CompletableFuture<Void> visitSubject(BakeState state, SubjectRef<I> subject2, Multiset<SubjectRef<?>> visitedSubjects, int inheritanceLevel) {
        if (visitedSubjects.count(subject2) > 3) {
            state.pex.logger().warn(Messages.BAKER_ERROR_CIRCULAR_INHERITANCE.tr(state.base.identifier(), subject2));
            return Util.emptyFuture();
        }
        visitedSubjects.add(subject2);
        SubjectTypeCollection type = state.pex.subjects((SubjectType)subject2.type());
        return ((CompletableFuture)((SubjectDataCacheImpl)((SubjectTypeCollectionImpl)type).persistentData()).data(subject2.identifier(), state.base).thenCombine(((SubjectDataCacheImpl)((SubjectTypeCollectionImpl)type).transientData()).data(subject2.identifier(), state.base), (arg_0, arg_1) -> this.lambda$visitSubject$7(state, (SubjectTypeCollectionImpl)type, visitedSubjects, inheritanceLevel, arg_0, arg_1))).thenCompose(res -> res);
    }

    private List<Set<ContextValue<?>>> processContexts(Set<Set<ContextValue<?>>> possibilities, Set<Set<ContextValue<?>>> transientPossibilities, BakeState state) {
        ArrayList ret = new ArrayList();
        HashSet seen = new HashSet(possibilities.size());
        this.processSingleDataContexts(ret, seen, possibilities, state);
        this.processSingleDataContexts(ret, seen, transientPossibilities, state);
        ret.sort(Comparator.comparingInt(Set::size).reversed());
        return ret;
    }

    private void processSingleDataContexts(List<Set<ContextValue<?>>> accum, Set<Set<ContextValue<?>>> seen, Set<Set<ContextValue<?>>> possibilities, BakeState state) {
        block0: for (Set<ContextValue<?>> segmentContexts : possibilities) {
            if (seen.contains(segmentContexts)) continue;
            seen.add(segmentContexts);
            for (ContextValue<?> value : segmentContexts) {
                boolean matched = false;
                for (ContextValue possibility : state.activeContexts) {
                    if (!this.checkSingleContextMatch(value, possibility, state.pex)) continue;
                    matched = true;
                    break;
                }
                if (matched) continue;
                continue block0;
            }
            accum.add(segmentContexts);
        }
    }

    private <T> boolean checkSingleContextMatch(ContextValue<T> value, ContextValue<?> other, PermissionsEx<?> pex) {
        return value.key().equals(other.key()) && value.tryResolve(pex) && value.definition().matches((T)value, (T)other.getParsedValue(value.definition()));
    }

    private CompletableFuture<Void> visitSubjectSingle(BakeState state, ImmutableSubjectData data, CompletableFuture<Void> initial, Set<ContextValue<?>> activeCombo, Multiset<SubjectRef<?>> visitedSubjects, int inheritanceLevel) {
        initial = ((CompletableFuture)initial).thenRun(() -> this.visitSingle(state, data, activeCombo, inheritanceLevel));
        for (Map.Entry<String, String> parent : data.getParents(activeCombo)) {
            SubjectRef<?> ref = state.pex.deserializeSubjectRef(parent);
            initial = ((CompletableFuture)initial).thenCompose(none2 -> this.visitSubject(state, ref, visitedSubjects, inheritanceLevel + 1));
        }
        return initial;
    }

    private void putPermIfNecessary(BakeState state, String perm, int val) {
        Integer existing = (Integer)state.combinedPermissions.get(perm);
        if (existing == null || Math.abs(val) > Math.abs(existing)) {
            state.combinedPermissions.put(perm, val);
        }
    }

    private void visitSingle(BakeState state, ImmutableSubjectData data, Set<ContextValue<?>> specificCombination, int inheritanceLevel) {
        for (Map.Entry<String, Integer> entry : data.getPermissions(specificCombination).entrySet()) {
            String perm = entry.getKey();
            if (entry.getKey().startsWith("#")) {
                if (inheritanceLevel > 1) continue;
                perm = perm.substring(1);
            }
            try {
                for (String matched : Globs.parse(perm)) {
                    this.putPermIfNecessary(state, matched, entry.getValue());
                }
            }
            catch (GlobParseException e) {
                this.putPermIfNecessary(state, perm, entry.getValue());
            }
        }
        state.parents.addAll(data.getParents(specificCombination).stream().map(ent -> Maps.immutableEntry((Object)((String)ent.getKey()), (Object)((String)ent.getValue()))).collect(Collectors.toList()));
        for (Map.Entry<String, Object> entry : data.getOptions(specificCombination).entrySet()) {
            if (state.options.containsKey(entry.getKey())) continue;
            state.options.put(entry.getKey(), (String)entry.getValue());
        }
        if (Math.abs(data.getDefaultValue(specificCombination)) > Math.abs(state.defaultValue)) {
            state.defaultValue = data.getDefaultValue(specificCombination);
        }
    }

    private /* synthetic */ CompletableFuture lambda$visitSubject$7(BakeState state, SubjectTypeCollectionImpl type, Multiset visitedSubjects, int inheritanceLevel, ImmutableSubjectData persistent, ImmutableSubjectData transientData) {
        CompletableFuture<Void> ret = Util.emptyFuture();
        for (Set<ContextValue<?>> combo : this.processContexts(persistent.getActiveContexts(), transientData.getActiveContexts(), state)) {
            if (type.type().transientHasPriority()) {
                ret = this.visitSubjectSingle(state, transientData, ret, combo, visitedSubjects, inheritanceLevel);
                ret = this.visitSubjectSingle(state, persistent, ret, combo, visitedSubjects, inheritanceLevel);
                continue;
            }
            ret = this.visitSubjectSingle(state, persistent, ret, combo, visitedSubjects, inheritanceLevel);
            ret = this.visitSubjectSingle(state, transientData, ret, combo, visitedSubjects, inheritanceLevel);
        }
        return ret;
    }

    private /* synthetic */ CompletionStage lambda$bake$3(BakeState state, Multiset visitedSubjects, Void none2) {
        return this.visitSubject(state, SubjectRef.subject(PermissionsEngine.SUBJECTS_DEFAULTS, PermissionsEngine.SUBJECTS_DEFAULTS.name()), visitedSubjects, 2);
    }

    private /* synthetic */ CompletionStage lambda$bake$2(BakeState state, SubjectRef defIdentifier, Multiset visitedSubjects, Void none2) {
        return this.visitSubject(state, defIdentifier, visitedSubjects, 1);
    }

    private /* synthetic */ CompletionStage lambda$bake$1(BakeState state, SubjectRef subject2, Multiset visitedSubjects, Void none2) {
        return this.visitSubject(state, SubjectRef.subject(PermissionsEngine.SUBJECTS_FALLBACK, subject2.type().name()), visitedSubjects, 0);
    }

    private static class BakeState {
        private final Map<String, Integer> combinedPermissions = new HashMap<String, Integer>();
        private final List<Map.Entry<String, String>> parents = new ArrayList<Map.Entry<String, String>>();
        private final Map<String, String> options = new HashMap<String, String>();
        private int defaultValue;
        private final CalculatedSubjectImpl<?> base;
        private final PermissionsEx<?> pex;
        private final Set<ContextValue<?>> activeContexts;

        private BakeState(CalculatedSubjectImpl<?> base, Set<ContextValue<?>> activeContexts) {
            this.base = base;
            this.activeContexts = activeContexts;
            this.pex = base.getManager();
        }
    }
}

