/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.impl.subject;

import ca.stellardrift.permissionsex.datastore.DataStore;
import ca.stellardrift.permissionsex.ext.com.github.benmanes.caffeine.cache.AsyncLoadingCache;
import ca.stellardrift.permissionsex.ext.com.github.benmanes.caffeine.cache.Caffeine;
import ca.stellardrift.permissionsex.impl.PermissionsEx;
import ca.stellardrift.permissionsex.impl.data.SubjectDataCacheImpl;
import ca.stellardrift.permissionsex.impl.data.ToDataSubjectRefImpl;
import ca.stellardrift.permissionsex.impl.subject.CalculatedSubjectImpl;
import ca.stellardrift.permissionsex.impl.subject.SubjectDataBaker;
import ca.stellardrift.permissionsex.subject.CalculatedSubject;
import ca.stellardrift.permissionsex.subject.SubjectRef;
import ca.stellardrift.permissionsex.subject.SubjectType;
import ca.stellardrift.permissionsex.subject.SubjectTypeCollection;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;

public class SubjectTypeCollectionImpl<I>
implements SubjectTypeCollection<I> {
    private final PermissionsEx<?> pex;
    private final SubjectType<I> type;
    private final SubjectDataCacheImpl<I> persistentData;
    private final SubjectDataCacheImpl<I> transientData;
    private final AsyncLoadingCache<I, CalculatedSubject> cache;

    public SubjectTypeCollectionImpl(PermissionsEx<?> pex, SubjectType<I> type, SubjectDataCacheImpl<I> persistentData, SubjectDataCacheImpl<I> transientData) {
        this.pex = pex;
        this.type = type;
        this.persistentData = persistentData;
        this.transientData = transientData;
        this.cache = Caffeine.newBuilder().executor(pex.asyncExecutor()).buildAsync((key, executor2) -> {
            CalculatedSubjectImpl<Object> subj = new CalculatedSubjectImpl<Object>(SubjectDataBaker.inheritance(), SubjectRef.subject(this.type, key), this);
            return persistentData.referenceTo(key, false).thenCombine(transientData.referenceTo(key, false), (persistentRef, transientRef) -> {
                subj.initialize((ToDataSubjectRefImpl<Object>)persistentRef, (ToDataSubjectRefImpl<Object>)transientRef);
                return subj;
            });
        });
    }

    @Override
    public SubjectType<I> type() {
        return this.type;
    }

    @Override
    public void cacheAll() {
        this.persistentData.cacheAll();
        this.transientData.cacheAll();
    }

    @Override
    public Collection<CalculatedSubject> activeSubjects() {
        return Collections.unmodifiableCollection(this.cache.synchronous().asMap().values());
    }

    @Override
    public void uncache(I identifier) {
        this.persistentData.invalidate(identifier);
        this.transientData.invalidate(identifier);
        this.cache.synchronous().invalidate(identifier);
    }

    @Override
    public CompletableFuture<CalculatedSubject> get(I identifier) {
        return this.cache.get(identifier);
    }

    @Override
    public SubjectDataCacheImpl<I> transientData() {
        return this.transientData;
    }

    @Override
    public SubjectDataCacheImpl<I> persistentData() {
        return this.persistentData;
    }

    PermissionsEx<?> getManager() {
        return this.pex;
    }

    public void update(DataStore newDataStore) {
        this.persistentData.update(newDataStore);
    }

    @Override
    public void load(I identifier) {
        this.persistentData.load(identifier);
        this.transientData.load(identifier);
    }

    @Override
    public CompletableFuture<Boolean> isRegistered(I identifier) {
        return this.persistentData.isRegistered(identifier).thenCombine(this.transientData.isRegistered(identifier), Boolean::logicalAnd);
    }

    @Override
    public Stream<I> allIdentifiers() {
        return Stream.concat(this.persistentData.getAllIdentifiers(), this.transientData.getAllIdentifiers()).distinct();
    }
}

