/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.impl.util;

import java.util.Objects;
import java.util.function.LongSupplier;
import java.util.function.Supplier;

public final class CachingValue<V> {
    private final LongSupplier currentTime;
    private final long maxDelta;
    private final Supplier<V> updater;
    private volatile long lastTime;
    private volatile V lastValue;

    public static <V> CachingValue<V> timeBased(long maxDelta, Supplier<V> updateFunc) {
        return new CachingValue<V>(System::currentTimeMillis, maxDelta, updateFunc);
    }

    public CachingValue(LongSupplier currentTime, long maxDelta, Supplier<V> updater) {
        Objects.requireNonNull(currentTime, "currentTime");
        Objects.requireNonNull(updater, "updater");
        this.currentTime = currentTime;
        this.maxDelta = maxDelta;
        this.updater = updater;
        this.refresh();
    }

    public V get() {
        long now = this.currentTime.getAsLong();
        if (now - this.lastTime > this.maxDelta) {
            this.lastValue = this.updater.get();
            this.lastTime = now;
        }
        return this.lastValue;
    }

    public void refresh() {
        this.lastValue = this.updater.get();
        this.lastTime = this.currentTime.getAsLong();
    }
}

