/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.impl.util;

import ca.stellardrift.permissionsex.ext.org.spongepowered.configurate.ConfigurationNode;
import ca.stellardrift.permissionsex.ext.org.spongepowered.configurate.serialize.SerializationException;
import ca.stellardrift.permissionsex.ext.org.spongepowered.configurate.serialize.TypeSerializer;
import java.lang.reflect.Type;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Objects;
import java.util.function.Predicate;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class IpSet
implements Predicate<InetAddress> {
    public static final TypeSerializer<IpSet> SERIALIZER = new IpSetSerializer();
    private final InetAddress address;
    private final int prefixLength;

    public static IpSet only(InetAddress address) {
        Objects.requireNonNull(address, "address");
        return new IpSet(address, IpSet.maxPrefixLength(address));
    }

    public static IpSet fromAddrPrefix(InetAddress address, int prefixLen) {
        Objects.requireNonNull(address, "address");
        IpSet.validatePrefixLength(address, prefixLen);
        return new IpSet(address, prefixLen);
    }

    public static IpSet fromCidr(String spec) {
        InetAddress addr;
        int prefixLen;
        String addrString;
        Objects.requireNonNull(spec, "spec");
        int slashIndex = spec.lastIndexOf("/");
        if (slashIndex == -1) {
            addrString = spec;
            prefixLen = addrString.startsWith("[") ? 128 : 32;
        } else {
            addrString = spec.substring(0, slashIndex);
            prefixLen = Integer.parseInt(spec.substring(slashIndex + 1));
        }
        try {
            addr = InetAddress.getByName(addrString);
        }
        catch (UnknownHostException ex) {
            throw new IllegalArgumentException(addrString + "does not contain a valid IP address");
        }
        return IpSet.fromAddrPrefix(addr, prefixLen);
    }

    IpSet(InetAddress address, int prefixLength) {
        this.address = address;
        this.prefixLength = prefixLength;
    }

    static int maxPrefixLength(InetAddress address) {
        if (address instanceof Inet4Address) {
            return 32;
        }
        if (address instanceof Inet6Address) {
            return 128;
        }
        throw new IllegalArgumentException("Unknown IP address type " + address.getClass());
    }

    static void validatePrefixLength(InetAddress address, int prefixLength) {
        if (prefixLength < 0) {
            throw new IllegalArgumentException("Minimum prefix length for an IP address is 0, but " + prefixLength + " was provided.");
        }
        int maxLength = IpSet.maxPrefixLength(address);
        if (prefixLength > maxLength) {
            throw new IllegalArgumentException("Maximum prefix length for a " + address.getClass().getSimpleName() + " is " + maxLength + ", but " + prefixLength + " was provided");
        }
    }

    @Override
    public boolean test(InetAddress address) {
        return this.contains(address);
    }

    public boolean contains(InetAddress input) {
        int i;
        byte[] checkAddr;
        byte[] address = input.getAddress();
        if (address.length != (checkAddr = this.address.getAddress()).length) {
            return false;
        }
        int completeSegments = this.prefixLength >> 3;
        int overlap = this.prefixLength & 7;
        for (i = 0; i < completeSegments; ++i) {
            if (address[i] == checkAddr[i]) continue;
            return false;
        }
        for (i = 0; i < overlap; ++i) {
            if ((checkAddr[completeSegments + 1] >> 7 - i & 1) == (address[completeSegments + 1] >> 7 - i & 1)) continue;
            return false;
        }
        return true;
    }

    public boolean contains(IpSet other) {
        if (other.prefixLength < this.prefixLength) {
            return false;
        }
        return other.address.equals(this.address) || this.contains(other.address);
    }

    public String toString() {
        return this.address.getHostAddress() + "/" + this.prefixLength;
    }

    static class IpSetSerializer
    implements TypeSerializer<IpSet> {
        IpSetSerializer() {
        }

        @Override
        public IpSet deserialize(Type type, ConfigurationNode node) throws SerializationException {
            try {
                return IpSet.fromCidr(node.getString());
            }
            catch (IllegalArgumentException ex) {
                throw new SerializationException(ex);
            }
        }

        @Override
        public void serialize(Type type, @Nullable IpSet obj, ConfigurationNode node) throws SerializationException {
            if (obj == null) {
                node.raw(null);
                return;
            }
            node.set(obj.toString());
        }
    }
}

