/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.impl.util;

import ca.stellardrift.permissionsex.ext.org.spongepowered.configurate.util.CheckedFunction;
import ca.stellardrift.permissionsex.ext.org.spongepowered.configurate.util.CheckedSupplier;
import ca.stellardrift.permissionsex.ext.org.spongepowered.configurate.util.UnmodifiableCollections;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;

public class Util {
    private static final CompletableFuture<Object> EMPTY_FUTURE = new CompletableFuture();

    public static Map.Entry<String, String> subjectFromString(String input) {
        String[] entries = input.split(":", 2);
        if (entries.length == 1) {
            return UnmodifiableCollections.immutableMapEntry("group", entries[0]);
        }
        return UnmodifiableCollections.immutableMapEntry(entries[0], entries[1]);
    }

    public static String subjectToString(Map.Entry<String, String> input) {
        return input.getKey() + ":" + input.getValue();
    }

    public static <T> Optional<T> castOptional(Optional<?> input, Class<T> clazz) {
        return input.filter(clazz::isInstance).map(clazz::cast);
    }

    public static <T> CompletableFuture<T> failedFuture(Throwable error2) {
        CompletableFuture ret = new CompletableFuture();
        ret.completeExceptionally(error2);
        return ret;
    }

    public static <T> CompletableFuture<T> emptyFuture() {
        return EMPTY_FUTURE;
    }

    public static <I, T> CompletableFuture<T> failableFuture(I value, CheckedFunction<I, T, ?> func) {
        return Util.failableFuture(() -> func.apply(value));
    }

    public static <T> CompletableFuture<T> failableFuture(CheckedSupplier<T, ?> func) {
        CompletableFuture<T> ret = new CompletableFuture<T>();
        try {
            ret.complete(func.get());
        }
        catch (Throwable e) {
            ret.completeExceptionally(e);
        }
        return ret;
    }

    public static <T> CompletableFuture<T> asyncFailableFuture(CheckedSupplier<T, ?> supplier, Executor exec) {
        CompletableFuture ret = new CompletableFuture();
        exec.execute(() -> {
            try {
                ret.complete(supplier.get());
            }
            catch (Throwable e) {
                ret.completeExceptionally(e);
            }
        });
        return ret;
    }

    public static <K, V> Map<K, V> updateImmutable(Map<K, V> input, K newKey, V newVal) {
        if (input == null) {
            return Collections.singletonMap(newKey, newVal);
        }
        HashMap<K, V> ret = new HashMap<K, V>(input);
        if (newVal == null) {
            ret.remove(newKey);
        } else {
            ret.put(newKey, newVal);
        }
        return Collections.unmodifiableMap(ret);
    }

    public static <T> List<T> appendImmutable(List<T> input, T entry) {
        if (input == null) {
            return Collections.singletonList(entry);
        }
        ArrayList<T> ret = new ArrayList<T>(input.size() + 1);
        ret.addAll(input);
        ret.add(entry);
        return Collections.unmodifiableList(ret);
    }

    static {
        EMPTY_FUTURE.complete(null);
    }
}

