/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.minecraft;

import ca.stellardrift.permissionsex.exception.PermissionsLoadingException;
import ca.stellardrift.permissionsex.impl.ImplementationInterface;
import ca.stellardrift.permissionsex.impl.PermissionsEx;
import ca.stellardrift.permissionsex.impl.config.PermissionsExConfiguration;
import ca.stellardrift.permissionsex.minecraft.Messages;
import ca.stellardrift.permissionsex.minecraft.profile.ProfileApiResolver;
import ca.stellardrift.permissionsex.subject.InvalidIdentifierException;
import ca.stellardrift.permissionsex.subject.SubjectType;
import ca.stellardrift.permissionsex.subject.SubjectTypeCollection;
import java.io.Closeable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import reactor.core.publisher.Mono;

public final class MinecraftPermissionsEx<T>
implements Closeable {
    private static final String SUBJECTS_USER = "user";
    private static final String SUBJECTS_GROUP = "group";
    private final PermissionsEx<T> engine;
    private final SubjectType<UUID> users;
    private final SubjectType<String> groups;
    private final ProfileApiResolver resolver;

    public static <V> Builder<V> builder(PermissionsExConfiguration<V> config) {
        return new Builder<V>(config);
    }

    MinecraftPermissionsEx(Builder<T> builder) throws PermissionsLoadingException {
        this.engine = new PermissionsEx(((Builder)builder).config, ((Builder)builder).implementation);
        this.resolver = ProfileApiResolver.resolver(this.engine.asyncExecutor());
        Predicate opProvider = ((Builder)builder).opProvider;
        this.users = SubjectType.builder(SUBJECTS_USER, UUID.class).serializedBy(UUID::toString).deserializedBy(id -> {
            try {
                return UUID.fromString(id);
            }
            catch (IllegalArgumentException ex) {
                throw new InvalidIdentifierException((String)id);
            }
        }).friendlyNameResolvedBy(((Builder)builder).cachedUuidResolver).undefinedValues(opProvider::test).associatedObjects(((Builder)builder).playerProvider).build();
        this.groups = SubjectType.stringIdentBuilder(SUBJECTS_GROUP).build();
        this.convertUuids();
        this.users();
        this.groups().cacheAll();
    }

    public PermissionsEx<T> engine() {
        return this.engine;
    }

    public SubjectTypeCollection<UUID> users() {
        return this.engine.subjects((SubjectType)this.users);
    }

    public SubjectTypeCollection<String> groups() {
        return this.engine.subjects((SubjectType)this.groups);
    }

    private void convertUuids() {
        try {
            InetAddress.getByName("api.mojang.com");
            ((CompletableFuture)this.engine.doBulkOperation(store -> {
                Set<String> toConvert = store.getAllIdentifiers(SUBJECTS_USER).stream().filter(ident -> {
                    if (ident.length() != 36) {
                        return true;
                    }
                    try {
                        UUID.fromString(ident);
                        return false;
                    }
                    catch (IllegalArgumentException ex) {
                        return true;
                    }
                }).collect(Collectors.toSet());
                if (toConvert.isEmpty()) {
                    return CompletableFuture.completedFuture(0L);
                }
                this.engine.logger().info(Messages.UUIDCONVERSION_BEGIN.tr(new Object[0]));
                return this.resolver.resolveByName(toConvert).filterWhen(profile -> {
                    String newIdentifier = profile.uuid().toString();
                    String lookupName = profile.name();
                    Mono<Boolean> newRegistered = Mono.fromCompletionStage(store.isRegistered(SUBJECTS_USER, newIdentifier));
                    Mono<Boolean> oldRegistered = Mono.zip(Mono.fromCompletionStage(store.isRegistered(SUBJECTS_USER, lookupName)), Mono.fromCompletionStage(store.isRegistered(SUBJECTS_USER, lookupName.toLowerCase(Locale.ROOT))), (a, b) -> a != false || b != false);
                    return Mono.zip(newRegistered, oldRegistered, (n, o) -> {
                        if (n.booleanValue()) {
                            this.engine.logger().warn(Messages.UUIDCONVERSION_ERROR_DUPLICATE.tr(newIdentifier));
                            return false;
                        }
                        return o;
                    });
                }).flatMap(profile -> {
                    String newIdentifier = profile.uuid().toString();
                    return Mono.fromCompletionStage(store.getData(SUBJECTS_USER, profile.name(), null).thenCompose(oldData -> store.setData(SUBJECTS_USER, newIdentifier, oldData.setOption(PermissionsEx.GLOBAL_CONTEXT, "name", profile.name())).thenAccept(result -> store.setData(SUBJECTS_USER, profile.name(), null).exceptionally(t -> {
                        t.printStackTrace();
                        return null;
                    }))));
                }).count().toFuture();
            }).thenAccept(result -> {
                if (result != null && result > 0L) {
                    this.engine.logger().info(Messages.UUIDCONVERSION_END.tr(result));
                }
            })).exceptionally(t -> {
                this.engine.logger().error(Messages.UUIDCONVERSION_ERROR_GENERAL.tr(new Object[0]), (Throwable)t);
                return null;
            });
        }
        catch (UnknownHostException ex) {
            this.engine.logger().warn(Messages.UUIDCONVERSION_ERROR_DNS.tr(new Object[0]));
        }
    }

    @Override
    public void close() {
        this.engine.close();
    }

    public static final class Builder<C> {
        private final PermissionsExConfiguration<C> config;
        private @MonotonicNonNull ImplementationInterface implementation;
        private Function<String, @Nullable UUID> cachedUuidResolver = $ -> null;
        private Predicate<UUID> opProvider = $ -> false;
        private Function<UUID, @Nullable ?> playerProvider = $ -> null;

        Builder(PermissionsExConfiguration<C> configInstance) {
            this.config = Objects.requireNonNull(configInstance, "config");
        }

        public Builder<C> implementationInterface(ImplementationInterface impl) {
            this.implementation = Objects.requireNonNull(impl, "impl");
            return this;
        }

        public Builder<C> cachedUuidResolver(Function<String, @Nullable UUID> resolver) {
            this.cachedUuidResolver = Objects.requireNonNull(resolver, "uuid");
            return this;
        }

        public Builder<C> opProvider(Predicate<UUID> provider) {
            this.opProvider = Objects.requireNonNull(provider, "provider");
            return this;
        }

        public Builder<C> playerProvider(Function<UUID, @Nullable ?> playerProvider) {
            this.playerProvider = Objects.requireNonNull(playerProvider, "playerProvider");
            return this;
        }

        public MinecraftPermissionsEx<C> build() throws PermissionsLoadingException {
            Objects.requireNonNull(this.implementation, "An ImplementationInterface must be provided");
            return new MinecraftPermissionsEx(this);
        }
    }
}

