/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.minecraft.profile;

import ca.stellardrift.permissionsex.minecraft.profile.GsonAdaptersMinecraftProfile;
import ca.stellardrift.permissionsex.minecraft.profile.MinecraftProfile;
import ca.stellardrift.permissionsex.minecraft.profile.ProfileApiResolver;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Executor;
import reactor.core.publisher.Flux;
import reactor.core.scheduler.Schedulers;

class ProfileApiResolverImpl
implements ProfileApiResolver {
    private static final String USER_AGENT = "PermissionsEx Resolver/" + ProfileApiResolver.class.getPackage().getImplementationVersion();
    private static final URL PROFILE_QUERY_URL;
    private static final int MAX_REQUEST_SIZE = 100;
    private static final Gson GSON;
    private final Executor executor;

    ProfileApiResolverImpl(Executor executor2) {
        this.executor = executor2;
    }

    private HttpURLConnection openConnection(URL endpoint) throws IOException {
        URLConnection conn = endpoint.openConnection();
        if (!(conn instanceof HttpURLConnection)) {
            throw new IllegalStateException("Profile connection should be a HttpURLConnection but isn't");
        }
        conn.setDoInput(true);
        conn.setDoOutput(true);
        conn.addRequestProperty("Content-Type", "application/json");
        conn.addRequestProperty("User-Agent", USER_AGENT);
        conn.connect();
        return (HttpURLConnection)conn;
    }

    @Override
    public Flux<MinecraftProfile> resolveByName(Iterable<String> names) {
        return Flux.fromIterable(names).filter(it -> it.length() <= 16).buffer(100).concatMap(batch -> Flux.create(sink -> {
            try {
                InputStreamReader is;
                JsonWriter json;
                HttpURLConnection conn = this.openConnection(PROFILE_QUERY_URL);
                try (OutputStreamWriter os = new OutputStreamWriter(conn.getOutputStream(), StandardCharsets.UTF_8);){
                    json = GSON.newJsonWriter((Writer)os);
                    try {
                        json.beginArray();
                        for (String name : batch) {
                            json.value(name);
                        }
                        json.endArray();
                    }
                    finally {
                        if (json != null) {
                            json.close();
                        }
                    }
                }
                if (conn.getResponseCode() != 200) {
                    is = new InputStreamReader(conn.getErrorStream(), StandardCharsets.UTF_8);
                    try {
                        json = (JsonObject)GSON.fromJson((Reader)is, JsonObject.class);
                        sink.error(new IOException(json.toString()));
                    }
                    finally {
                        is.close();
                    }
                }
                is = new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8);
                try {
                    ((List)GSON.fromJson((Reader)is, TypeToken.getParameterized(List.class, (Type[])new Type[]{MinecraftProfile.class}).getType())).forEach(sink::next);
                }
                finally {
                    is.close();
                }
            }
            catch (IOException ex) {
                sink.error(ex);
            }
            sink.complete();
        }).publishOn(Schedulers.fromExecutor(this.executor)));
    }

    static {
        try {
            PROFILE_QUERY_URL = new URL("https://api.mojang.com/profiles/minecraft");
        }
        catch (MalformedURLException ex) {
            throw new ExceptionInInitializerError(ex);
        }
        GSON = new GsonBuilder().registerTypeAdapter(UUID.class, (Object)new TypeAdapter<UUID>(){

            public void write(JsonWriter out, UUID value) throws IOException {
                out.jsonValue(value.toString().replace("-", ""));
            }

            public UUID read(JsonReader in) throws IOException {
                String mojangId = in.nextString();
                StringBuilder result = new StringBuilder(36).append(mojangId, 0, 8).append("-").append(mojangId, 8, 12).append("-").append(mojangId, 12, 16).append("-").append(mojangId, 16, 20).append("-").append(mojangId, 20, 32);
                return UUID.fromString(result.toString());
            }
        }.nullSafe()).registerTypeAdapterFactory((TypeAdapterFactory)new GsonAdaptersMinecraftProfile()).create();
    }
}

