/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.subject;

import ca.stellardrift.permissionsex.context.ContextValue;
import ca.stellardrift.permissionsex.subject.SubjectRef;
import java.util.List;
import java.util.Map;
import java.util.Set;

public interface ImmutableSubjectData {
    public Map<Set<ContextValue<?>>, Map<String, String>> getAllOptions();

    public Map<String, String> getOptions(Set<ContextValue<?>> var1);

    public ImmutableSubjectData setOption(Set<ContextValue<?>> var1, String var2, String var3);

    public ImmutableSubjectData setOptions(Set<ContextValue<?>> var1, Map<String, String> var2);

    public ImmutableSubjectData clearOptions(Set<ContextValue<?>> var1);

    public ImmutableSubjectData clearOptions();

    public Map<Set<ContextValue<?>>, Map<String, Integer>> getAllPermissions();

    public Map<String, Integer> getPermissions(Set<ContextValue<?>> var1);

    public ImmutableSubjectData setPermission(Set<ContextValue<?>> var1, String var2, int var3);

    public ImmutableSubjectData setPermissions(Set<ContextValue<?>> var1, Map<String, Integer> var2);

    public ImmutableSubjectData clearPermissions();

    public ImmutableSubjectData clearPermissions(Set<ContextValue<?>> var1);

    public Map<Set<ContextValue<?>>, List<Map.Entry<String, String>>> getAllParents();

    public List<Map.Entry<String, String>> getParents(Set<ContextValue<?>> var1);

    public ImmutableSubjectData addParent(Set<ContextValue<?>> var1, String var2, String var3);

    default public <I> ImmutableSubjectData addParent(Set<ContextValue<?>> contexts, SubjectRef<I> subject2) {
        return this.addParent(contexts, subject2.type().name(), subject2.type().serializeIdentifier(subject2.identifier()));
    }

    public ImmutableSubjectData removeParent(Set<ContextValue<?>> var1, String var2, String var3);

    default public <I> ImmutableSubjectData removeParent(Set<ContextValue<?>> contexts, SubjectRef<I> subject2) {
        return this.removeParent(contexts, subject2.type().name(), subject2.type().serializeIdentifier(subject2.identifier()));
    }

    public ImmutableSubjectData setParents(Set<ContextValue<?>> var1, List<Map.Entry<String, String>> var2);

    public ImmutableSubjectData clearParents();

    public ImmutableSubjectData clearParents(Set<ContextValue<?>> var1);

    public int getDefaultValue(Set<ContextValue<?>> var1);

    public ImmutableSubjectData setDefaultValue(Set<ContextValue<?>> var1, int var2);

    public Map<Set<ContextValue<?>>, Integer> getAllDefaultValues();

    public Set<Set<ContextValue<?>>> getActiveContexts();

    default public ImmutableSubjectData mergeFrom(ImmutableSubjectData other) {
        ImmutableSubjectData output = this;
        for (Map.Entry<Set<ContextValue<?>>, Map<String, Integer>> entry : other.getAllPermissions().entrySet()) {
            output = output.setPermissions(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<Set<ContextValue<?>>, Map<String, Object>> entry : other.getAllOptions().entrySet()) {
            output = output.setOptions(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<Set<ContextValue<?>>, Object> entry : other.getAllParents().entrySet()) {
            output = output.setParents(entry.getKey(), (List)entry.getValue());
        }
        for (Map.Entry<Set<ContextValue<?>>, Object> entry : other.getAllDefaultValues().entrySet()) {
            output = output.setDefaultValue(entry.getKey(), (Integer)entry.getValue());
        }
        return output;
    }
}

