/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.subject;

import ca.stellardrift.permissionsex.subject.InvalidIdentifierException;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.pcollections.HashTreePMap;
import org.pcollections.PMap;

public final class SubjectType<I> {
    private final String name;
    private final Class<I> identifierType;
    private final boolean transientHasPriority;
    private final Function<I, Boolean> undefinedValueProvider;
    private final Function<String, I> identifierDeserializer;
    private final Function<I, String> identifierSerializer;
    private final Function<I, @Nullable ?> associatedObjectProvider;
    private final Function<String, I> friendlyDeserializer;

    public static <V> Builder<V> builder(String name, Class<V> identifierType) {
        return new Builder<V>(name, identifierType);
    }

    public static Builder<String> stringIdentBuilder(String name) {
        return SubjectType.builder(name, String.class).serializedBy(Function.identity()).deserializedBy(Function.identity());
    }

    SubjectType(Builder<I> builder) {
        this.name = ((Builder)builder).name;
        this.identifierType = ((Builder)builder).identifierType;
        this.transientHasPriority = ((Builder)builder).transientHasPriority;
        this.undefinedValueProvider = ((Builder)builder).undefinedValueProvider;
        this.associatedObjectProvider = ((Builder)builder).associatedObjectProvider;
        this.friendlyDeserializer = ((Builder)builder).friendlyDeserializer;
        this.identifierDeserializer = Objects.requireNonNull(((Builder)builder).identifierDeserializer, "Identifier deserializer has not been provided for subject type " + this.name);
        this.identifierSerializer = Objects.requireNonNull(((Builder)builder).identifierSerializer, "Identifier serializer has not been set for subject type " + this.name);
    }

    public final String name() {
        return this.name;
    }

    public final boolean transientHasPriority() {
        return this.transientHasPriority;
    }

    public boolean isIdentifierValid(String serialized) {
        try {
            this.parseIdentifier(serialized);
            return true;
        }
        catch (InvalidIdentifierException ex) {
            return false;
        }
    }

    public I parseIdentifier(String input) {
        return this.identifierDeserializer.apply(Objects.requireNonNull(input, "input"));
    }

    public String serializeIdentifier(I input) {
        return this.identifierSerializer.apply(Objects.requireNonNull(input, "input"));
    }

    public @Nullable I parseOrCoerceIdentifier(String name) {
        try {
            return this.parseIdentifier(name);
        }
        catch (InvalidIdentifierException ex) {
            return this.friendlyDeserializer.apply(name);
        }
    }

    public @Nullable Object getAssociatedObject(I identifier) {
        return this.associatedObjectProvider.apply(identifier);
    }

    public boolean undefinedPermissionValue(I identifier) {
        return this.undefinedValueProvider.apply(Objects.requireNonNull(identifier));
    }

    public int hashCode() {
        return 7 * this.name.hashCode() + 31 * this.identifierType.hashCode();
    }

    public boolean equals(Object other) {
        if (!(other instanceof SubjectType)) {
            return false;
        }
        SubjectType that = (SubjectType)other;
        return this.name.equals(that.name) && this.identifierType.equals(that.identifierType);
    }

    public String toString() {
        return "SubjectType<" + this.identifierType.getSimpleName() + ">(name=" + this.name + ")";
    }

    public static final class Builder<I> {
        private final String name;
        private final Class<I> identifierType;
        private boolean transientHasPriority = true;
        private Function<I, Boolean> undefinedValueProvider = $ -> false;
        private Function<I, @Nullable ?> associatedObjectProvider = $ -> null;
        private Function<String, @Nullable I> friendlyDeserializer = $ -> null;
        private @Nullable Function<String, I> identifierDeserializer;
        private @Nullable Function<I, String> identifierSerializer;

        Builder(String name, Class<I> identifierType) {
            Objects.requireNonNull(name, "name");
            Objects.requireNonNull(identifierType, "identifierType");
            this.name = name;
            this.identifierType = identifierType;
        }

        Builder(SubjectType<I> existing) {
            this.name = ((SubjectType)existing).name;
            this.identifierType = ((SubjectType)existing).identifierType;
            this.transientHasPriority = ((SubjectType)existing).transientHasPriority;
            this.undefinedValueProvider = ((SubjectType)existing).undefinedValueProvider;
            this.associatedObjectProvider = ((SubjectType)existing).associatedObjectProvider;
            this.friendlyDeserializer = ((SubjectType)existing).friendlyDeserializer;
            this.identifierDeserializer = ((SubjectType)existing).identifierDeserializer;
            this.identifierSerializer = ((SubjectType)existing).identifierSerializer;
        }

        public Builder<I> transientHasPriority(boolean priority) {
            this.transientHasPriority = priority;
            return this;
        }

        public Builder<I> undefinedValues(Function<I, Boolean> provider) {
            Objects.requireNonNull(provider, "provider");
            this.undefinedValueProvider = provider;
            return this;
        }

        public Builder<I> serializedBy(Function<I, String> serializer) {
            this.identifierSerializer = Objects.requireNonNull(serializer, "serializer");
            return this;
        }

        public Builder<I> deserializedBy(Function<String, I> deserializer) {
            this.identifierDeserializer = Objects.requireNonNull(deserializer, "deserializer");
            return this;
        }

        public Builder<I> friendlyNameResolvedBy(Function<String, @Nullable I> coercer) {
            this.friendlyDeserializer = Objects.requireNonNull(coercer, "coercer");
            return this;
        }

        public Builder<I> associatedObjects(Function<I, @Nullable ?> provider) {
            this.associatedObjectProvider = provider;
            return this;
        }

        public Builder<I> fixedEntries(Map<I, ? extends Supplier<@Nullable ?>> entries) {
            Objects.requireNonNull(entries, "entries");
            this.associatedObjectProvider = ident -> {
                Supplier value = (Supplier)entries.get(ident);
                return value == null ? null : value.get();
            };
            @Nullable Function<String, I> oldDeserializer = this.identifierDeserializer;
            if (oldDeserializer == null) {
                throw new IllegalStateException("An identifier deserializer must have already been set to be able to restrict the valid identifiers.");
            }
            this.identifierDeserializer = serialized -> {
                Object candidate = oldDeserializer.apply((String)serialized);
                if (!entries.containsKey(candidate)) {
                    throw new InvalidIdentifierException((String)serialized);
                }
                return candidate;
            };
            return this;
        }

        @SafeVarargs
        public final Builder<I> fixedEntries(Map.Entry<I, ? extends Supplier<?>> ... entries) {
            PMap<I, Supplier<@Nullable ?>> result = HashTreePMap.empty();
            for (Map.Entry<I, Supplier<?>> entry : entries) {
                result = result.plus(entry.getKey(), entry.getValue());
            }
            return this.fixedEntries(result);
        }

        public SubjectType<I> build() {
            return new SubjectType(this);
        }
    }
}

