/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.util;

import ca.stellardrift.permissionsex.ext.net.kyori.adventure.text.Component;
import ca.stellardrift.permissionsex.ext.net.kyori.adventure.text.ComponentLike;
import ca.stellardrift.permissionsex.ext.net.kyori.adventure.text.TranslatableComponent;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class TranslatableProvider
implements ComponentLike {
    private final String key;

    public TranslatableProvider(String bundle, String key) {
        Objects.requireNonNull(bundle, "bundle");
        Objects.requireNonNull(key, "key");
        this.key = bundle + '/' + key;
    }

    public String key() {
        return this.key;
    }

    public TranslatableComponent tr(Object ... args2) {
        return Component.translatable(this.key, this.transformArray(args2));
    }

    public TranslatableComponent.Builder bTr(Object ... args2) {
        return Component.translatable().key(this.key).args(this.transformArray(args2));
    }

    private Component[] transformArray(Object[] input) {
        Component[] output = new Component[input.length];
        int length = input.length;
        for (int i = 0; i < length; ++i) {
            output[i] = this.asComponent(input[i]);
        }
        return output;
    }

    private Component asComponent(Object input) {
        if (input instanceof Component) {
            return (Component)input;
        }
        if (input instanceof ComponentLike) {
            return ((ComponentLike)input).asComponent();
        }
        return Component.text(String.valueOf(input));
    }

    @Override
    public @NonNull Component asComponent() {
        return this.tr(new Object[0]);
    }
}

