/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.util.glob;

import ca.stellardrift.permissionsex.ext.org.antlr.v4.runtime.tree.ParseTree;
import ca.stellardrift.permissionsex.ext.org.antlr.v4.runtime.tree.TerminalNode;
import ca.stellardrift.permissionsex.util.glob.CharsNode;
import ca.stellardrift.permissionsex.util.glob.GlobNode;
import ca.stellardrift.permissionsex.util.glob.OrNode;
import ca.stellardrift.permissionsex.util.glob.SequenceNode;
import ca.stellardrift.permissionsex.util.glob.UnitNode;
import ca.stellardrift.permissionsex.util.glob.parser.GlobBaseVisitor;
import ca.stellardrift.permissionsex.util.glob.parser.GlobParser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;

final class GlobVisitor
extends GlobBaseVisitor<GlobNode> {
    public static final GlobVisitor INSTANCE = new GlobVisitor();
    private static final char ESCAPE_MARKER = '\\';

    private GlobVisitor() {
    }

    @Override
    public GlobNode visitRootGlob(GlobParser.RootGlobContext ctx) {
        return (GlobNode)this.visit(ctx.glob());
    }

    @Override
    public GlobNode visitGlob(GlobParser.GlobContext ctx) {
        if (ctx.element().size() == 1) {
            return (GlobNode)this.visit(ctx.element(0));
        }
        return this.childrenToNode(ctx.element(), SequenceNode::new);
    }

    @Override
    public GlobNode visitTerminal(TerminalNode node) {
        return (GlobNode)super.visitTerminal(node);
    }

    @Override
    public GlobNode visitElement(GlobParser.ElementContext ctx) {
        if (ctx.LITERAL() != null) {
            return new UnitNode(GlobVisitor.unescape(ctx.LITERAL().getText()));
        }
        return (GlobNode)this.visitChildren(ctx);
    }

    @Override
    public GlobNode visitChars(GlobParser.CharsContext ctx) {
        return new CharsNode(ctx.content.getText());
    }

    private static String unescape(String withEscapes) {
        int escapeIdx = withEscapes.indexOf(92);
        if (escapeIdx == -1) {
            return withEscapes;
        }
        int lastEscape = 0;
        StringBuilder output = new StringBuilder(withEscapes.length());
        do {
            output.append(withEscapes, lastEscape, escapeIdx);
        } while ((escapeIdx = withEscapes.indexOf(92, (lastEscape = escapeIdx + 1) + 1)) != -1);
        output.append(withEscapes.substring(lastEscape));
        return output.toString();
    }

    @Override
    public GlobNode visitOr(GlobParser.OrContext ctx) {
        return this.childrenToNode(ctx.glob(), OrNode::new);
    }

    private <T extends GlobNode> T childrenToNode(List<? extends ParseTree> contexts, Function<List<GlobNode>, T> factory) {
        ArrayList<GlobNode> builder = new ArrayList<GlobNode>(contexts.size());
        for (ParseTree parseTree : contexts) {
            GlobNode node = (GlobNode)this.visit(parseTree);
            builder.add(node);
        }
        return (T)((GlobNode)((Object)factory.apply(Collections.unmodifiableList(builder))));
    }
}

