/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.util.glob;

import ca.stellardrift.permissionsex.util.glob.GlobNode;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;

class SequenceNode
extends GlobNode {
    private final List<GlobNode> children;

    SequenceNode(List<GlobNode> children) {
        this.children = children;
    }

    @Override
    public Iterator<String> iterator() {
        return new SeqIterator();
    }

    public String toString() {
        return "seq(" + this.children + ")";
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SequenceNode)) {
            return false;
        }
        SequenceNode that = (SequenceNode)other;
        return Objects.equals(this.children, that.children);
    }

    public int hashCode() {
        return Objects.hashCode(this.children);
    }

    private final class SeqIterator
    implements Iterator<String> {
        private final Iterator<String>[] iterators;
        private final String[] components;
        private @Nullable String current;

        SeqIterator() {
            this.iterators = new Iterator[SequenceNode.this.children.size()];
            this.components = new String[this.iterators.length];
            for (int i = 0; i < SequenceNode.this.children.size(); ++i) {
                this.iterators[i] = ((GlobNode)SequenceNode.this.children.get(i)).iterator();
                if (i == SequenceNode.this.children.size() - 1) continue;
                this.components[i] = this.iterators[i].next();
            }
            this.current = this.computeNext();
        }

        private @Nullable String computeNext() {
            int i;
            int lastNum = this.iterators.length;
            for (i = this.iterators.length - 1; i >= 0; --i) {
                lastNum = i;
                if (this.iterators[i].hasNext()) break;
                if (i == 0) {
                    return null;
                }
                this.iterators[i] = null;
            }
            for (i = lastNum; i < this.iterators.length; ++i) {
                if (this.iterators[i] == null) {
                    this.iterators[i] = ((GlobNode)SequenceNode.this.children.get(i)).iterator();
                }
                this.components[i] = this.iterators[i].next();
            }
            return String.join((CharSequence)"", this.components);
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        @Override
        public String next() {
            @Nullable String current = this.current;
            if (current == null) {
                throw new NoSuchElementException();
            }
            this.current = this.computeNext();
            return current;
        }
    }
}

