/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.util.glob;

import ca.stellardrift.permissionsex.util.glob.GlobNode;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;

class UnitNode
extends GlobNode {
    private final String value;

    public UnitNode(String value) {
        Objects.requireNonNull(value, "value");
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public boolean matches(String input) {
        return this.value.equals(input);
    }

    @Override
    public boolean matchesIgnoreCase(String input) {
        return this.value.equalsIgnoreCase(input);
    }

    @Override
    public Iterator<String> iterator() {
        return new Iterator<String>(){
            private boolean seen = false;

            @Override
            public boolean hasNext() {
                return !this.seen;
            }

            @Override
            public String next() {
                if (this.seen) {
                    throw new NoSuchElementException("Already seen element");
                }
                this.seen = true;
                return UnitNode.this.value;
            }
        };
    }

    @Override
    public void forEach(Consumer<? super String> consumer) {
        consumer.accept(this.value);
    }

    @Override
    public Spliterator<String> spliterator() {
        return Spliterators.spliterator(new Object[]{this.value}, 0);
    }

    public String toString() {
        return "literal(" + this.value + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UnitNode)) {
            return false;
        }
        UnitNode strings = (UnitNode)o;
        return Objects.equals(this.value, strings.value);
    }

    public int hashCode() {
        return Objects.hashCode(this.value);
    }
}

