/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.bukkit;

import ca.stellardrift.permissionsex.bukkit.PermissionsExPlugin;
import ca.stellardrift.permissionsex.ext.checkerframework.checker.nullness.qual.NonNull;
import ca.stellardrift.permissionsex.ext.checkerframework.checker.nullness.qual.Nullable;
import ca.stellardrift.permissionsex.ext.kyori.adventure.audience.Audience;
import ca.stellardrift.permissionsex.ext.kyori.adventure.text.Component;
import ca.stellardrift.permissionsex.minecraft.command.Commander;
import ca.stellardrift.permissionsex.minecraft.command.MessageFormatter;
import ca.stellardrift.permissionsex.subject.SubjectRef;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

final class BukkitCommander
implements Commander {
    private final PermissionsExPlugin plugin;
    private final CommandSender source;
    private final Audience audience;

    BukkitCommander(PermissionsExPlugin plugin, CommandSender source) {
        this.plugin = plugin;
        this.source = source;
        this.audience = plugin.adventure().sender(source);
    }

    @Override
    public Component name() {
        return Component.text(this.source.getName());
    }

    @Override
    public @Nullable SubjectRef<?> subjectIdentifier() {
        if (this.source instanceof Player) {
            return SubjectRef.subject(this.plugin.users().type(), ((Player)this.source).getUniqueId());
        }
        return null;
    }

    @Override
    public MessageFormatter formatter() {
        return this.plugin.manager().messageFormatter();
    }

    @Override
    public boolean hasPermission(String permission) {
        return this.source.hasPermission(permission);
    }

    @Override
    public @NonNull Audience audience() {
        return this.audience;
    }

    CommandSender source() {
        return this.source;
    }
}

