/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.bukkit;

import ca.stellardrift.permissionsex.ext.checkerframework.checker.nullness.qual.Nullable;
import org.bukkit.Bukkit;

final class CraftBukkitInterface {
    private static final String CRAFTBUKKIT_PREFIX = "org.bukkit.craftbukkit";
    private static final @Nullable String VERSION;

    CraftBukkitInterface() {
    }

    static @Nullable String craftClassName(String simpleName) {
        if (VERSION == null) {
            return null;
        }
        return CRAFTBUKKIT_PREFIX + VERSION + simpleName;
    }

    static @Nullable Class<?> craftClass(String name) {
        if (VERSION == null) {
            return null;
        }
        try {
            return Class.forName(CraftBukkitInterface.craftClassName(name));
        }
        catch (ClassNotFoundException ex) {
            return null;
        }
    }

    static {
        Class<?> serverClass = Bukkit.getServer().getClass();
        if (!serverClass.getSimpleName().equals("CraftServer")) {
            VERSION = null;
        } else if (serverClass.getName().equals("org.bukkit.craftbukkit.CraftServer")) {
            VERSION = ".";
        } else {
            String name = serverClass.getName();
            name = name.substring(CRAFTBUKKIT_PREFIX.length());
            VERSION = name = name.substring(0, name.length() - "CraftServer".length());
        }
    }
}

