/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.bukkit;

import ca.stellardrift.permissionsex.bukkit.PEXPermissible;
import ca.stellardrift.permissionsex.context.ContextDefinitionProvider;
import ca.stellardrift.permissionsex.impl.util.PCollections;
import ca.stellardrift.permissionsex.subject.SubjectRef;
import ca.stellardrift.permissionsex.subject.SubjectType;
import java.util.Map;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionAttachment;
import org.bukkit.plugin.Plugin;

final class PEXPermissionAttachment
extends PermissionAttachment
implements SubjectRef<UUID> {
    static final SubjectType<UUID> ATTACHMENT_TYPE = SubjectType.builder("attachment", UUID.class).serializedBy(UUID::toString).deserializedBy(UUID::fromString).build();
    private final PEXPermissible perm;
    private final UUID identifier = UUID.randomUUID();
    private final SubjectRef.ToData<UUID> subject;

    PEXPermissionAttachment(Plugin owner, Player parent, PEXPermissible perm) {
        super(owner, (Permissible)parent);
        this.perm = perm;
        this.subject = perm.manager().subjects(ATTACHMENT_TYPE).transientData().referenceTo(this.identifier).join();
    }

    @Override
    public SubjectType<UUID> type() {
        return ATTACHMENT_TYPE;
    }

    @Override
    public UUID identifier() {
        return this.identifier;
    }

    public Map<String, Boolean> getPermissions() {
        return PCollections.asMap(this.subject.get().segment(ContextDefinitionProvider.GLOBAL_CONTEXT).permissions(), (k, $) -> k, ($, v) -> v > 0);
    }

    public void setPermission(String name, boolean value) {
        this.subject.update(ContextDefinitionProvider.GLOBAL_CONTEXT, s -> s.withPermission(name, value ? 1 : -1));
    }

    public void setPermission(Permission perm, boolean value) {
        this.setPermission(perm.getName(), value);
    }

    public void unsetPermission(String name) {
        this.subject.update(ContextDefinitionProvider.GLOBAL_CONTEXT, s -> s.withPermission(name, 0));
    }

    public void unsetPermission(Permission perm) {
        this.unsetPermission(perm.getName());
    }

    public boolean remove() {
        this.subject.update(s -> null);
        return this.perm.removeAttachmentInternal(this);
    }
}

