/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.bukkit;

import ca.stellardrift.permissionsex.bukkit.FieldReplacer;
import ca.stellardrift.permissionsex.bukkit.PermissionsExPlugin;
import ca.stellardrift.permissionsex.ext.checkerframework.checker.nullness.qual.MonotonicNonNull;
import ca.stellardrift.permissionsex.ext.checkerframework.checker.nullness.qual.Nullable;
import ca.stellardrift.permissionsex.impl.PermissionsEx;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.plugin.PluginManager;

final class PermissionList
extends HashMap<String, Permission> {
    private static final long serialVersionUID = 5211930944081173317L;
    private static @MonotonicNonNull FieldReplacer<PluginManager, Map> INJECTOR;
    private static final Map<Class<?>, FieldReplacer<Permission, Map>> CHILDREN_MAPS;
    private final Multimap<String, Map.Entry<String, Boolean>> childParentMapping = Multimaps.synchronizedMultimap((Multimap)HashMultimap.create());
    private final PermissionsExPlugin plugin;

    PermissionList(Map<? extends String, ? extends Permission> existing, PermissionsExPlugin plugin) {
        super(existing);
        this.plugin = plugin;
    }

    private FieldReplacer<Permission, Map> getFieldReplacer(Permission perm) {
        FieldReplacer<Object, Map> ret = CHILDREN_MAPS.get(perm.getClass());
        if (ret == null) {
            ret = new FieldReplacer(perm.getClass(), "children", Map.class);
            CHILDREN_MAPS.put(perm.getClass(), ret);
        }
        return ret;
    }

    private void removeAllChildren(String perm) {
        this.childParentMapping.entries().removeIf(stringEntryEntry -> ((String)((Map.Entry)stringEntryEntry.getValue()).getKey()).equals(perm));
    }

    public void uninject() {
        INJECTOR.set(this.plugin.getServer().getPluginManager(), new HashMap<String, Permission>(this));
    }

    public static PermissionList inject(PermissionsExPlugin manager) {
        if (INJECTOR == null) {
            INJECTOR = new FieldReplacer(manager.getServer().getPluginManager().getClass(), "permissions", Map.class);
        }
        Map existing = INJECTOR.get(manager.getServer().getPluginManager());
        PermissionList list = new PermissionList(existing, manager);
        INJECTOR.set(manager.getServer().getPluginManager(), list);
        return list;
    }

    @Override
    public Permission put(String k, Permission v) {
        for (Map.Entry ent : v.getChildren().entrySet()) {
            this.childParentMapping.put((Object)((String)ent.getKey()), new AbstractMap.SimpleEntry<String, Boolean>(v.getName(), (Boolean)ent.getValue()));
        }
        FieldReplacer<Permission, Map> repl = this.getFieldReplacer(v);
        repl.set(v, new NotifyingChildrenMap(v));
        if (v.getDefault() == PermissionDefault.TRUE || v.getDefault() == PermissionDefault.FALSE) {
            this.plugin.engine().defaults().transientData().update(this.plugin.users().type(), input -> input.withSegment(PermissionsEx.GLOBAL_CONTEXT, s -> s.withPermission(v.getName(), v.getDefault() == PermissionDefault.TRUE ? 1 : -1)));
        }
        return super.put(k, v);
    }

    @Override
    public @Nullable Permission remove(Object k) {
        Permission ret = (Permission)super.remove(k);
        if (ret != null) {
            this.removeAllChildren(k.toString());
            this.getFieldReplacer(ret).set(ret, new LinkedHashMap(ret.getChildren()));
            if (ret.getDefault() == PermissionDefault.TRUE || ret.getDefault() == PermissionDefault.FALSE) {
                this.plugin.engine().defaults().transientData().update(this.plugin.users().type(), input -> input.withSegment(PermissionsEx.GLOBAL_CONTEXT, s -> s.withPermission(ret.getName(), 0)));
            }
        }
        return ret;
    }

    @Override
    public void clear() {
        this.childParentMapping.clear();
        super.clear();
    }

    public Collection<Map.Entry<String, Boolean>> getParents(String permission) {
        return ImmutableSet.copyOf((Collection)this.childParentMapping.get((Object)permission.toLowerCase()));
    }

    static {
        CHILDREN_MAPS = new HashMap();
    }

    private class NotifyingChildrenMap
    extends LinkedHashMap<String, Boolean> {
        private static final long serialVersionUID = -8012029306538729479L;
        private final Permission perm;

        public NotifyingChildrenMap(Permission perm) {
            super(perm.getChildren());
            this.perm = perm;
        }

        @Override
        public Boolean remove(Object perm) {
            this.removeFromMapping(String.valueOf(perm));
            return (Boolean)super.remove(perm);
        }

        private void removeFromMapping(String child) {
            PermissionList.this.childParentMapping.get((Object)child).removeIf(stringBooleanEntry -> ((String)stringBooleanEntry.getKey()).equals(this.perm.getName()));
        }

        @Override
        public Boolean put(String perm, Boolean val) {
            PermissionList.this.childParentMapping.put((Object)perm, new AbstractMap.SimpleEntry<String, Boolean>(this.perm.getName(), val));
            return super.put(perm, val);
        }

        @Override
        public void clear() {
            PermissionList.this.removeAllChildren(this.perm.getName());
            super.clear();
        }
    }
}

