/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.bukkit;

import ca.stellardrift.permissionsex.PermissionsEngine;
import ca.stellardrift.permissionsex.bukkit.BukkitCommander;
import ca.stellardrift.permissionsex.bukkit.BukkitConfiguration;
import ca.stellardrift.permissionsex.bukkit.BukkitContexts;
import ca.stellardrift.permissionsex.bukkit.BukkitMessageFormatter;
import ca.stellardrift.permissionsex.bukkit.Messages;
import ca.stellardrift.permissionsex.bukkit.PEXPermissible;
import ca.stellardrift.permissionsex.bukkit.PEXPermissionSubscriptionMap;
import ca.stellardrift.permissionsex.bukkit.PermissibleInjector;
import ca.stellardrift.permissionsex.bukkit.PermissionList;
import ca.stellardrift.permissionsex.bukkit.PluginIntegrations;
import ca.stellardrift.permissionsex.ext.checkerframework.checker.nullness.qual.MonotonicNonNull;
import ca.stellardrift.permissionsex.ext.checkerframework.checker.nullness.qual.Nullable;
import ca.stellardrift.permissionsex.ext.commandframework.CommandManager;
import ca.stellardrift.permissionsex.ext.commandframework.CommandTree;
import ca.stellardrift.permissionsex.ext.commandframework.bukkit.CloudBukkitCapabilities;
import ca.stellardrift.permissionsex.ext.commandframework.execution.CommandExecutionCoordinator;
import ca.stellardrift.permissionsex.ext.commandframework.paper.PaperCommandManager;
import ca.stellardrift.permissionsex.ext.commandframework.permission.CommandPermission;
import ca.stellardrift.permissionsex.ext.configurate.yaml.NodeStyle;
import ca.stellardrift.permissionsex.ext.configurate.yaml.YamlConfigurationLoader;
import ca.stellardrift.permissionsex.ext.kyori.adventure.platform.bukkit.BukkitAudiences;
import ca.stellardrift.permissionsex.ext.slf4j.Logger;
import ca.stellardrift.permissionsex.ext.slf4j.impl.JDK14LoggerAdapter;
import ca.stellardrift.permissionsex.impl.BaseDirectoryScope;
import ca.stellardrift.permissionsex.impl.ImplementationInterface;
import ca.stellardrift.permissionsex.impl.config.FilePermissionsExConfiguration;
import ca.stellardrift.permissionsex.impl.logging.WrappingFormattedLogger;
import ca.stellardrift.permissionsex.logging.FormattedLogger;
import ca.stellardrift.permissionsex.minecraft.MinecraftPermissionsEx;
import ca.stellardrift.permissionsex.minecraft.command.Commander;
import ca.stellardrift.permissionsex.minecraft.command.Permission;
import ca.stellardrift.permissionsex.sql.hikari.Hikari;
import ca.stellardrift.permissionsex.subject.SubjectTypeCollection;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.sql.SQLException;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.sql.DataSource;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.Server;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerPreLoginEvent;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class PermissionsExPlugin
extends JavaPlugin
implements Listener {
    private @MonotonicNonNull FormattedLogger logger;
    private @MonotonicNonNull Path dataPath;
    private @MonotonicNonNull BukkitAudiences adventure;
    private @Nullable MinecraftPermissionsEx<BukkitConfiguration> manager;
    private final ExecutorService executorService = Executors.newCachedThreadPool();
    private @Nullable PermissionList permissionList;
    private @Nullable PEXPermissionSubscriptionMap subscriptionHandler;

    public PermissionsEngine engine() {
        return this.manager().engine();
    }

    MinecraftPermissionsEx<BukkitConfiguration> manager() {
        @Nullable MinecraftPermissionsEx<BukkitConfiguration> manager = this.manager;
        if (manager == null) {
            throw new IllegalStateException("PermissionsEx is not currently initialized! Check for an earlier error, or whether permissions may be checked too early.");
        }
        return manager;
    }

    public SubjectTypeCollection<UUID> users() {
        return this.manager().users();
    }

    public SubjectTypeCollection<String> groups() {
        return this.manager().groups();
    }

    private FormattedLogger makeLogger() {
        try {
            Constructor adapter = JDK14LoggerAdapter.class.getDeclaredConstructor(java.util.logging.Logger.class);
            adapter.setAccessible(true);
            return WrappingFormattedLogger.of((Logger)adapter.newInstance(this.getLogger()), true);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            throw new ExceptionInInitializerError(ex);
        }
    }

    private CommandManager<Commander> createCommandManager(Function<CommandTree<Commander>, CommandExecutionCoordinator<Commander>> execCoord) throws RuntimeException {
        PaperCommandManager<Commander> mgr;
        try {
            mgr = new PaperCommandManager<Commander>((Plugin)this, execCoord, sender -> new BukkitCommander(this, (CommandSender)sender), commander -> ((BukkitCommander)commander).source()){

                @Override
                public boolean hasPermission(Commander sender, CommandPermission permission) {
                    if (permission instanceof Permission) {
                        return sender.hasPermission((Permission)permission);
                    }
                    return super.hasPermission(sender, permission);
                }
            };
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        if (mgr.queryCapability(CloudBukkitCapabilities.BRIGADIER)) {
            mgr.registerBrigadier();
        }
        if (mgr.queryCapability(CloudBukkitCapabilities.ASYNCHRONOUS_COMPLETION)) {
            mgr.registerAsynchronousCompletions();
        }
        return mgr;
    }

    public void onEnable() {
        this.dataPath = this.getDataFolder().toPath();
        this.logger = this.makeLogger();
        this.adventure = BukkitAudiences.create((Plugin)this);
        YamlConfigurationLoader configLoader = ((YamlConfigurationLoader.Builder)((YamlConfigurationLoader.Builder)YamlConfigurationLoader.builder().path(this.dataPath.resolve("config.yml"))).nodeStyle(NodeStyle.BLOCK).defaultOptions(FilePermissionsExConfiguration::decorateOptions)).build();
        try {
            BukkitImplementationInterface impl = new BukkitImplementationInterface();
            Files.createDirectories(this.dataPath, new FileAttribute[0]);
            this.manager = MinecraftPermissionsEx.builder(FilePermissionsExConfiguration.fromLoader(configLoader, BukkitConfiguration.class)).implementationInterface(impl).opProvider(it -> this.getServer().getOperators().contains(this.getServer().getOfflinePlayer(it))).cachedUuidResolver(it -> this.getServer().getOfflinePlayer(it).getUniqueId()).playerProvider(arg_0 -> ((Server)this.getServer()).getPlayer(arg_0)).commands(this::createCommandManager).messageFormatter(BukkitMessageFormatter::new).build();
        }
        catch (Exception ex) {
            this.logger.error(Messages.ERROR_ON_ENABLE.tr(this.getDescription().getName()), (Throwable)ex);
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.engine().registerContextDefinitions(BukkitContexts.world(), BukkitContexts.dimension(), BukkitContexts.remoteIp(), BukkitContexts.remoteIp(), BukkitContexts.localHost(), BukkitContexts.localPort());
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.subscriptionHandler = PEXPermissionSubscriptionMap.inject(this, this.getServer().getPluginManager());
        this.permissionList = PermissionList.inject(this);
        this.injectAllPermissibles();
        PluginIntegrations.detectWorldGuard(this);
        PluginIntegrations.detectVault(this);
    }

    public void onDisable() {
        boolean successful;
        if (this.manager != null) {
            this.manager.close();
            this.manager = null;
        }
        if (this.subscriptionHandler != null) {
            this.subscriptionHandler.uninject();
            this.subscriptionHandler = null;
        }
        if (this.permissionList != null) {
            this.permissionList.uninject();
            this.permissionList = null;
        }
        this.uninjectAllPermissibles();
        this.executorService.shutdown();
        try {
            successful = this.executorService.awaitTermination(20L, TimeUnit.SECONDS);
        }
        catch (InterruptedException ex) {
            successful = false;
        }
        if (!successful) {
            this.logger.error(Messages.ERROR_DISABLE_TASK_TIMEOUT.tr(new Object[0]));
            this.executorService.shutdownNow();
        }
        this.adventure.close();
        this.adventure = null;
    }

    @EventHandler
    void onPlayerPreLogin(AsyncPlayerPreLoginEvent event) {
        this.users().get(event.getUniqueId()).exceptionally(e -> {
            this.logger.warn(Messages.ERROR_LOAD_PRELOGIN.tr(event.getName(), event.getUniqueId().toString(), e.getMessage()), (Throwable)e);
            return null;
        });
    }

    @EventHandler(priority=EventPriority.LOWEST)
    void onPlayerLogin(PlayerLoginEvent event) {
        UUID identifier = event.getPlayer().getUniqueId();
        this.users().transientData().update(identifier, it -> it.withSegment(PermissionsEngine.GLOBAL_CONTEXT, segment -> segment.withOption("hostname", StringUtils.substringBeforeLast((String)event.getHostname(), (String)":"))));
        this.users().isRegistered(identifier).thenAccept(registered -> {
            if (registered.booleanValue()) {
                this.users().persistentData().update(identifier, input -> input.withSegment(PermissionsEngine.GLOBAL_CONTEXT, it -> {
                    if (!event.getPlayer().getName().equals(it.options().get("name"))) {
                        return it.withOption("name", event.getPlayer().getName());
                    }
                    return it;
                }));
            }
        });
        this.injectPermissible(event.getPlayer());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    void onPlayerLoginDeny(PlayerLoginEvent event) {
        if (event.getResult() != PlayerLoginEvent.Result.ALLOWED) {
            this.uninjectPermissible(event.getPlayer());
            this.users().uncache(event.getPlayer().getUniqueId());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    void onPlayerQuit(PlayerQuitEvent event) {
        this.uninjectPermissible(event.getPlayer());
        @Nullable MinecraftPermissionsEx<BukkitConfiguration> manager = this.manager;
        if (manager != null) {
            manager.callbackController().clearOwnedBy(event.getPlayer().getUniqueId());
            manager.users().uncache(event.getPlayer().getUniqueId());
        }
    }

    private void injectPermissible(Player player) {
        try {
            PEXPermissible permissible = new PEXPermissible(player, this);
            boolean success = false;
            boolean found = false;
            for (PermissibleInjector injector : PermissibleInjector.INJECTORS) {
                if (!injector.isApplicable(player)) continue;
                found = true;
                @Nullable Permissible oldPerm = injector.inject(player, (Permissible)permissible);
                if (oldPerm == null) continue;
                permissible.previousPermissible = oldPerm;
                success = true;
                break;
            }
            if (!found) {
                this.logger.warn(Messages.SUPERPERMS_INJECT_NO_INJECTOR.tr(new Object[0]));
            } else if (!success) {
                this.logger.warn(Messages.SUPERPERMS_INJECT_ERROR_GENERIC.tr(player.getName()));
            }
            permissible.recalculatePermissions();
            if (success && this.engine().debugMode()) {
                this.logger.info(Messages.SUPERPERMS_INJECT_SUCCESS.tr(new Object[0]));
            }
        }
        catch (Throwable ex) {
            this.logger.error(Messages.SUPERPERMS_INJECT_ERROR_GENERIC.tr(player.getName()), ex);
        }
    }

    private void injectAllPermissibles() {
        this.getServer().getOnlinePlayers().forEach(this::injectPermissible);
    }

    private void uninjectPermissible(Player player) {
        try {
            boolean success = false;
            for (PermissibleInjector injector : PermissibleInjector.INJECTORS) {
                if (!injector.isApplicable(player)) continue;
                Permissible pexPerm = injector.getPermissible(player);
                if (pexPerm instanceof PEXPermissible) {
                    if (injector.inject(player, ((PEXPermissible)pexPerm).previousPermissible) == null) continue;
                    success = true;
                    break;
                }
                success = true;
                break;
            }
            if (!success) {
                this.logger.warn(Messages.SUPERPERMS_UNINJECT_NO_INJECTOR.tr(player.getName()));
            } else if (this.manager != null && this.engine().debugMode()) {
                this.logger.info(Messages.SUPERPERMS_UNINJECT_SUCCESS.tr(player.getName()));
            }
        }
        catch (Throwable ex) {
            this.logger.error(Messages.SUPERPERMS_UNINJECT_ERROR.tr(player.getName()), ex);
        }
    }

    private void uninjectAllPermissibles() {
        this.getServer().getOnlinePlayers().forEach(this::uninjectPermissible);
    }

    @Nullable PermissionList permissionList() {
        return this.permissionList;
    }

    BukkitAudiences adventure() {
        return this.adventure;
    }

    FormattedLogger logger() {
        return this.manager().engine().logger();
    }

    final class BukkitImplementationInterface
    implements ImplementationInterface {
        BukkitImplementationInterface() {
        }

        @Override
        public Path baseDirectory(BaseDirectoryScope scope) {
            switch (scope) {
                case CONFIG: {
                    return PermissionsExPlugin.this.dataPath;
                }
                case JAR: {
                    return Bukkit.getUpdateFolderFile().toPath();
                }
                case SERVER: {
                    return PermissionsExPlugin.this.dataPath.toAbsolutePath().getParent().getParent();
                }
                case WORLDS: {
                    return Bukkit.getWorldContainer().toPath();
                }
            }
            throw new IllegalArgumentException("Unknown directory scope " + (Object)((Object)scope));
        }

        @Override
        public DataSource dataSourceForUrl(String url) throws SQLException {
            return Hikari.createDataSource(url, this.baseDirectory());
        }

        @Override
        public Executor asyncExecutor() {
            return PermissionsExPlugin.this.executorService;
        }

        @Override
        public String version() {
            return PermissionsExPlugin.this.getDescription().getVersion();
        }

        @Override
        public Logger logger() {
            return PermissionsExPlugin.this.logger;
        }
    }
}

