/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.context;

import ca.stellardrift.permissionsex.context.ContextValue;
import ca.stellardrift.permissionsex.ext.checkerframework.checker.nullness.qual.Nullable;
import ca.stellardrift.permissionsex.ext.pcollections.HashTreePSet;
import ca.stellardrift.permissionsex.subject.CalculatedSubject;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;

public abstract class ContextDefinition<V> {
    private final String name;

    protected ContextDefinition(String name) {
        this.name = Objects.requireNonNull(name, "name");
    }

    public final ContextValue<V> createValue(V value) {
        return new ContextValue<V>(this, value);
    }

    public final String name() {
        return this.name;
    }

    public abstract String serialize(V var1);

    public abstract @Nullable V deserialize(String var1);

    public final boolean matches(ContextValue<V> ctx, V activeValue) {
        return this.matches(ctx.getParsedValue(this), activeValue);
    }

    public abstract boolean matches(V var1, V var2);

    public abstract void accumulateCurrentValues(CalculatedSubject var1, Consumer<V> var2);

    public Set<V> suggestValues(CalculatedSubject subject) {
        return HashTreePSet.empty();
    }

    public String toString() {
        return "ContextDefinition{name='" + this.name + "'}";
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ContextDefinition)) {
            return false;
        }
        return this.name.equals(((ContextDefinition)other).name);
    }

    public int hashCode() {
        return 31 * this.name.hashCode();
    }
}

