/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.context;

import ca.stellardrift.permissionsex.context.ContextDefinition;
import ca.stellardrift.permissionsex.context.ContextDefinitionProvider;
import ca.stellardrift.permissionsex.context.SimpleContextDefinition;
import ca.stellardrift.permissionsex.ext.checkerframework.checker.nullness.qual.Nullable;

public final class ContextValue<V> {
    private final String key;
    private final String rawValue;
    private @Nullable ContextDefinition<V> definition;
    private @Nullable V parsedValue;

    public ContextValue(String key, String rawValue) {
        this.key = key;
        this.rawValue = rawValue;
    }

    ContextValue(ContextDefinition<V> def, V value) {
        this(def.name(), def.serialize(value));
        this.definition = def;
        this.parsedValue = value;
    }

    public String key() {
        return this.key;
    }

    public String rawValue() {
        return this.rawValue;
    }

    public @Nullable ContextDefinition<V> definition() {
        return this.definition;
    }

    public @Nullable V parsedValue() {
        return this.parsedValue;
    }

    public boolean tryResolve(ContextDefinitionProvider provider) {
        if (this.definition != null && !(this.definition instanceof SimpleContextDefinition.Fallback)) {
            return this.parsedValue != null;
        }
        @Nullable ContextDefinition<?> definition = provider.contextDefinition(this.key);
        if (definition != null) {
            this.definition = definition;
            this.parsedValue = definition.deserialize(this.rawValue);
            return this.parsedValue != null;
        }
        return false;
    }

    public V getParsedValue(ContextDefinition<V> definition) {
        if (this.definition != null && !this.definition.equals(definition)) {
            throw new IllegalStateException("The provided context definition does not match the one this context object currently knows about");
        }
        this.definition = definition;
        @Nullable V parsedValue = this.parsedValue;
        if (parsedValue == null) {
            this.parsedValue = parsedValue = definition.deserialize(this.rawValue);
        }
        if (parsedValue == null) {
            throw new IllegalArgumentException("Invalid value provided for context " + definition.name());
        }
        return parsedValue;
    }

    public V getParsedValue(ContextDefinitionProvider provider) {
        @Nullable V tempParsed = this.parsedValue;
        if (tempParsed != null) {
            return tempParsed;
        }
        @Nullable ContextDefinition<?> def = provider.contextDefinition(this.key);
        tempParsed = def == null ? null : def.deserialize(this.rawValue);
        Object v0 = tempParsed;
        if (tempParsed == null) {
            throw new RuntimeException("No definition for context " + this.key);
        }
        this.parsedValue = tempParsed;
        return tempParsed;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ContextValue)) {
            return false;
        }
        ContextValue that = (ContextValue)other;
        if (!this.key.equals(that.key)) {
            return false;
        }
        return this.rawValue.equals(that.rawValue);
    }

    public int hashCode() {
        int result = this.key.hashCode();
        result = 31 * result + this.rawValue.hashCode();
        return result;
    }

    public String toString() {
        return this.key + ":" + this.parsedValue + " (raw: " + this.rawValue + ")";
    }
}

