/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.datastore;

import ca.stellardrift.permissionsex.datastore.DataStoreFactory;
import ca.stellardrift.permissionsex.ext.pcollections.HashTreePMap;
import ca.stellardrift.permissionsex.ext.pcollections.PMap;
import java.util.Locale;
import java.util.Objects;
import java.util.ServiceLoader;

class DataStoreFactories {
    private static final ServiceLoader<DataStoreFactory> LOADER = ServiceLoader.load(DataStoreFactory.class, DataStoreFactory.class.getClassLoader());
    static final PMap<String, DataStoreFactory<?>> REGISTRY;

    private DataStoreFactories() {
    }

    static {
        PMap<String, DataStoreFactory<Object>> factories = HashTreePMap.empty();
        for (DataStoreFactory factory : LOADER) {
            factories = factories.plus(Objects.requireNonNull(factory.name(), () -> "Factory in class " + factory.getClass() + " had a null name()").toLowerCase(Locale.ROOT), factory);
        }
        REGISTRY = factories;
    }
}

