/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.datastore;

import ca.stellardrift.permissionsex.datastore.DataStore;
import ca.stellardrift.permissionsex.datastore.DataStoreContext;
import ca.stellardrift.permissionsex.datastore.DataStoreFactory;
import ca.stellardrift.permissionsex.datastore.ProtoDataStoreImpl;
import ca.stellardrift.permissionsex.exception.PermissionsLoadingException;
import ca.stellardrift.permissionsex.ext.configurate.ConfigurationNode;
import ca.stellardrift.permissionsex.ext.configurate.serialize.SerializationException;
import org.immutables.value.Value;

@Value.Immutable(builder=false)
public interface ProtoDataStore<C> {
    public static <C> ProtoDataStore<C> of(String identifier, C config, DataStoreFactory<C> factory) {
        return new ProtoDataStoreImpl<C>(identifier, config, factory);
    }

    @Value.Parameter
    public String identifier();

    @Value.Parameter
    public C config();

    @Value.Parameter
    public DataStoreFactory<C> factory();

    default public DataStore defrost(DataStoreContext context) throws PermissionsLoadingException {
        return this.factory().defrost(context, this);
    }

    default public void serialize(ConfigurationNode node) throws SerializationException {
        this.factory().serialize(node, this);
    }
}

