/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.datastore.sql;

import ca.stellardrift.permissionsex.context.ContextInheritance;
import ca.stellardrift.permissionsex.context.ContextValue;
import ca.stellardrift.permissionsex.datastore.sql.CheckedBiConsumer;
import ca.stellardrift.permissionsex.datastore.sql.SqlDao;
import ca.stellardrift.permissionsex.ext.checkerframework.checker.nullness.qual.Nullable;
import ca.stellardrift.permissionsex.ext.pcollections.PMap;
import ca.stellardrift.permissionsex.ext.pcollections.PVector;
import ca.stellardrift.permissionsex.ext.pcollections.TreePVector;
import ca.stellardrift.permissionsex.impl.util.PCollections;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;

public class SqlContextInheritance
implements ContextInheritance {
    private final PMap<ContextValue<?>, PVector<ContextValue<?>>> inheritance;
    private final AtomicReference<PVector<CheckedBiConsumer<SqlDao, SqlContextInheritance, SQLException>>> updatesToPerform = new AtomicReference();

    SqlContextInheritance(PMap<ContextValue<?>, PVector<ContextValue<?>>> inheritance) {
        this(inheritance, TreePVector.empty());
    }

    SqlContextInheritance(PMap<ContextValue<?>, PVector<ContextValue<?>>> inheritance, PVector<CheckedBiConsumer<SqlDao, SqlContextInheritance, SQLException>> updates) {
        this.inheritance = inheritance;
        this.updatesToPerform.set(updates);
    }

    public PVector<ContextValue<?>> parents(ContextValue<?> context) {
        PVector ret = (PVector)this.inheritance.get(context);
        return ret == null ? PCollections.vector() : ret;
    }

    @Override
    public SqlContextInheritance parents(ContextValue<?> context, @Nullable List<ContextValue<?>> parents) {
        if (parents == null) {
            return new SqlContextInheritance(this.inheritance.minus(context), this.updatesToPerform.get().plus((dao, inherit) -> dao.setContextInheritance(context, null)));
        }
        PVector<ContextValue<?>> pParent = PCollections.asVector(parents);
        return new SqlContextInheritance(this.inheritance.plus(context, pParent), this.updatesToPerform.get().plus((dao, inherit) -> {
            List newParents = inherit.parents((ContextValue)context);
            if (!newParents.isEmpty()) {
                dao.setContextInheritance(context, (PVector<ContextValue<?>>)newParents);
            }
        }));
    }

    @Override
    public Map<ContextValue<?>, List<ContextValue<?>>> allParents() {
        return PCollections.narrow(this.inheritance);
    }

    void doUpdate(SqlDao dao) throws SQLException {
        List updates = this.updatesToPerform.getAndSet(TreePVector.empty());
        for (CheckedBiConsumer action : updates) {
            action.accept(dao, this);
        }
    }
}

