/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.datastore.sql;

import ca.stellardrift.permissionsex.context.ContextValue;
import ca.stellardrift.permissionsex.datastore.sql.SqlContextInheritance;
import ca.stellardrift.permissionsex.datastore.sql.SqlDataStore;
import ca.stellardrift.permissionsex.datastore.sql.SqlRankLadder;
import ca.stellardrift.permissionsex.datastore.sql.SqlSegment;
import ca.stellardrift.permissionsex.datastore.sql.SqlSubjectRef;
import ca.stellardrift.permissionsex.datastore.sql.dao.LegacyDao;
import ca.stellardrift.permissionsex.datastore.sql.dao.LegacyMigration;
import ca.stellardrift.permissionsex.ext.checkerframework.checker.nullness.qual.Nullable;
import ca.stellardrift.permissionsex.ext.configurate.util.CheckedSupplier;
import ca.stellardrift.permissionsex.ext.pcollections.PMap;
import ca.stellardrift.permissionsex.ext.pcollections.PSet;
import ca.stellardrift.permissionsex.ext.pcollections.PVector;
import ca.stellardrift.permissionsex.impl.util.PCollections;
import ca.stellardrift.permissionsex.rank.RankLadder;
import ca.stellardrift.permissionsex.subject.SubjectRef;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public abstract class SqlDao
implements AutoCloseable {
    private final Connection conn;
    private final SqlDataStore ds;
    int holdOpen;
    int transactionLevel;

    protected SqlDao(SqlDataStore ds) throws SQLException {
        this.ds = ds;
        this.conn = ds.getDataSource().getConnection();
    }

    protected String getSelectGlobalParameterQuery() {
        return "SELECT (`value`) FROM {}global WHERE `key`=?";
    }

    protected abstract String getInsertGlobalParameterQueryUpdating();

    protected String getDeleteGlobalParameterQuery() {
        return "DELETE FROM {}global WHERE `key`=?";
    }

    protected String getGetSubjectRefIdQuery() {
        return "SELECT type, identifier FROM {}subjects WHERE id=?";
    }

    protected String getGetSubjectRefTypeNameQuery() {
        return "SELECT id FROM {}subjects WHERE type=? AND identifier=?";
    }

    protected String getDeleteSubjectIdQuery() {
        return "DELETE FROM {}subjects WHERE id=?";
    }

    protected String getDeleteSubjectTypeNameQuery() {
        return "DELETE FROM {}subjects WHERE type=? AND identifier=?";
    }

    protected String getInsertSubjectTypeNameQuery() {
        return "INSERT INTO {}subjects (type, identifier) VALUES (?, ?)";
    }

    protected String getSelectContextsSegmentQuery() {
        return "SELECT `key`, `value` FROM {}contexts WHERE segment=?";
    }

    protected String getSelectSegmentsSubjectQuery() {
        return "SELECT id, perm_default FROM {}segments WHERE subject=?";
    }

    protected String getSelectPermissionsSegmentQuery() {
        return "SELECT `key`, `value` FROM {}permissions WHERE segment=?";
    }

    protected String getSelectOptionsSegmentQuery() {
        return "SELECT `key`, `value` FROM {}options WHERE segment=?";
    }

    protected String getSelectInheritanceSegmentQuery() {
        return "SELECT * FROM {}inheritance LEFT JOIN ({}subjects) on ({}inheritance.parent={}subjects.id) WHERE segment=?";
    }

    protected String getInsertSegmentQuery() {
        return "INSERT INTO {}segments (subject, perm_default) VALUES (?, ?)";
    }

    protected String getDeleteSegmentIdQuery() {
        return "DELETE FROM {}segments WHERE id=?";
    }

    protected String getSelectSubjectIdentifiersQuery() {
        return "SELECT identifier FROM {}subjects WHERE type=?";
    }

    protected String getSelectSubjectTypesQuery() {
        return "SELECT DISTINCT type FROM {}subjects";
    }

    protected String getDeleteOptionKeyQuery() {
        return "DELETE FROM {}options WHERE segment=? AND `key`=?";
    }

    protected String getDeleteOptionsQuery() {
        return "DELETE FROM {}options WHERE segment=?";
    }

    protected abstract String getInsertOptionUpdatingQuery();

    protected abstract String getInsertPermissionUpdatingQuery();

    protected String getDeletePermissionKeyQuery() {
        return "DELETE FROM {}permissions WHERE segment=? AND `key`=?";
    }

    protected String getDeletePermissionsQuery() {
        return "DELETE FROM {}permissions WHERE segment=?";
    }

    protected String getUpdatePermissionDefaultQuery() {
        return "UPDATE {}segments SET perm_default=? WHERE id=?";
    }

    protected String getInsertInheritanceQuery() {
        return "INSERT INTO {}inheritance (`segment`, `parent`) VALUES (?, ?)";
    }

    protected String getDeleteInheritanceParentQuery() {
        return "DELETE FROM {}inheritance WHERE segment=? AND parent=?";
    }

    protected String getDeleteInheritanceQuery() {
        return "DELETE FROM {}inheritance WHERE segment=?";
    }

    protected String getInsertContextQuery() {
        return "INSERT INTO {}contexts (segment, `key`, `value`) VALUES (?, ?, ?)";
    }

    protected String getDeleteContextQuery() {
        return "DELETE FROM {}contexts WHERE segment=?";
    }

    protected String getSelectContextInheritanceQuery() {
        return "SELECT `child_key`, `child_value`, `parent_key`, `parent_value` FROM {}context_inheritance ORDER BY `child_key`, `child_value`, `id` ASC";
    }

    protected String getInsertContextInheritanceQuery() {
        return "INSERT INTO {}context_inheritance (child_key, child_value, parent_key, parent_value) VALUES (?, ?, ?, ?)";
    }

    protected String getDeleteContextInheritanceQuery() {
        return "DELETE FROM {}context_inheritance WHERE child_key=? AND child_value=?";
    }

    protected String getSelectRankLadderQuery() {
        return "SELECT `{}rank_ladders`.`id`, `subject`, `type`, `identifier` FROM {}rank_ladders LEFT JOIN (`{}subjects`) ON (`{}rank_ladders`.`subject`=`{}subjects`.`id`) WHERE `name`=? ORDER BY `{}rank_ladders`.`id` ASC";
    }

    protected String getTestRankLadderExistsQuery() {
        return "SELECT `id` FROM {}rank_ladders WHERE `name`=? LIMIT 1";
    }

    protected String getInsertRankLadderQuery() {
        return "INSERT INTO {}rank_ladders (`name`, `subject`) VALUES (?, ?)";
    }

    protected String getDeleteRankLadderQuery() {
        return "DELETE FROM {}rank_ladders WHERE `name`=?";
    }

    protected String getSelectAllRankLadderNamesQuery() {
        return "SELECT DISTINCT `name` FROM {}rank_ladders";
    }

    protected String getSelectAllSubjectsQuery() {
        return "SELECT `id`, `type`, `identifier` FROM {}subjects";
    }

    protected String getRenameTableQuery() {
        return "ALTER TABLE ? RENAME ?";
    }

    protected String getSelectAllContextKeysUniqueQuery() {
        return "SELECT DISTINCT `key` FROM {}contexts";
    }

    public PreparedStatement prepareStatement(String query) throws SQLException {
        return this.conn.prepareStatement(this.ds.insertPrefix(query));
    }

    protected PreparedStatement prepareStatement(String query, int params) throws SQLException {
        return this.conn.prepareStatement(this.ds.insertPrefix(query), params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> T executeInTransaction(CheckedSupplier<T, SQLException> func) throws SQLException {
        ++this.transactionLevel;
        this.conn.setAutoCommit(false);
        try {
            T ret = func.get();
            if (--this.transactionLevel <= 0) {
                this.conn.commit();
            }
            T t = ret;
            return t;
        }
        finally {
            if (this.transactionLevel <= 0) {
                this.conn.setAutoCommit(true);
            }
        }
    }

    public LegacyDao legacy() {
        return LegacyDao.INSTANCE;
    }

    public Optional<String> getGlobalParameter(String key) throws SQLException {
        try (PreparedStatement stmt = this.prepareStatement(this.getSelectGlobalParameterQuery());){
            stmt.setString(1, key);
            ResultSet rs = stmt.executeQuery();
            if (rs.next()) {
                Optional<String> optional = Optional.of(rs.getString(1));
                return optional;
            }
            Optional<String> optional = Optional.empty();
            return optional;
        }
    }

    public void setGlobalParameter(String key, @Nullable String value) throws SQLException {
        if (value == null) {
            try (PreparedStatement stmt = this.prepareStatement(this.getDeleteGlobalParameterQuery());){
                stmt.setString(1, key);
                stmt.executeUpdate();
            }
        }
        try (PreparedStatement stmt = this.prepareStatement(this.getInsertGlobalParameterQueryUpdating());){
            stmt.setString(1, key);
            stmt.setString(2, value);
            stmt.executeUpdate();
        }
    }

    public Optional<SqlSubjectRef<?>> getSubjectRef(int id) throws SQLException {
        try (PreparedStatement stmt = this.prepareStatement(this.getGetSubjectRefIdQuery());){
            stmt.setInt(1, id);
            ResultSet res = stmt.executeQuery();
            if (!res.next()) {
                Optional<SqlSubjectRef<?>> optional = Optional.empty();
                return optional;
            }
            Optional<SqlSubjectRef<?>> optional = Optional.of(new SqlSubjectRef(this.ds.ctx(), id, res.getString(1), res.getString(2)));
            return optional;
        }
    }

    public Optional<SqlSubjectRef<?>> getSubjectRef(String type, String name) throws SQLException {
        try (PreparedStatement stmt = this.prepareStatement(this.getGetSubjectRefTypeNameQuery());){
            stmt.setString(1, type);
            stmt.setString(2, name);
            ResultSet res = stmt.executeQuery();
            if (!res.next()) {
                Optional<SqlSubjectRef<?>> optional = Optional.empty();
                return optional;
            }
            Optional<SqlSubjectRef<?>> optional = Optional.of(new SqlSubjectRef(this.ds.ctx(), res.getInt(1), type, name));
            return optional;
        }
    }

    public boolean removeSubject(SqlSubjectRef<?> ref) throws SQLException {
        try (PreparedStatement stmt = this.prepareStatement(this.getDeleteSubjectIdQuery());){
            stmt.setInt(1, ref.id());
            boolean bl = stmt.executeUpdate() > 0;
            return bl;
        }
    }

    public boolean removeSubject(String type, String name) throws SQLException {
        try (PreparedStatement stmt = this.prepareStatement(this.getDeleteSubjectTypeNameQuery());){
            stmt.setString(1, type);
            stmt.setString(2, name);
            boolean bl = stmt.executeUpdate() > 0;
            return bl;
        }
    }

    public SqlSubjectRef<?> getOrCreateSubjectRef(String type, String name) throws SQLException {
        SqlSubjectRef ret = SqlSubjectRef.unresolved(this.ds.ctx(), type, name);
        this.allocateSubjectRef(ret);
        return ret;
    }

    public void allocateSubjectRef(SqlSubjectRef<?> ref) throws SQLException {
        this.executeInTransaction(() -> {
            block13: {
                try (PreparedStatement stmt = this.prepareStatement(this.getGetSubjectRefTypeNameQuery());){
                    stmt.setString(1, ref.rawType());
                    stmt.setString(2, ref.rawIdentifier());
                    ResultSet res = stmt.executeQuery();
                    if (res.next()) {
                        ref.id(res.getInt(1));
                        break block13;
                    }
                    try (PreparedStatement addStatement = this.prepareStatement(this.getInsertSubjectTypeNameQuery(), 1);){
                        addStatement.setString(1, ref.rawType());
                        addStatement.setString(2, ref.rawIdentifier());
                        addStatement.executeUpdate();
                        res = addStatement.getGeneratedKeys();
                        res.next();
                        ref.id(res.getInt(1));
                    }
                }
            }
            return ref;
        });
    }

    public int getIdAllocating(SqlSubjectRef<?> ref) throws SQLException {
        if (ref.isUnallocated()) {
            this.allocateSubjectRef(ref);
        }
        return ref.id();
    }

    private PSet<ContextValue<?>> getSegmentContexts(int segmentId) throws SQLException {
        try (PreparedStatement stmt = this.prepareStatement(this.getSelectContextsSegmentQuery());){
            stmt.setInt(1, segmentId);
            PSet<ContextValue<Object>> result = PCollections.set();
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                result = result.plus(new ContextValue(rs.getString(1), rs.getString(2)));
            }
            PSet<ContextValue<?>> pSet = result;
            return pSet;
        }
    }

    public List<SqlSegment> getSegments(SqlSubjectRef<?> ref) throws SQLException {
        PVector<SqlSegment> result = PCollections.vector();
        try (PreparedStatement stmt = this.prepareStatement(this.getSelectSegmentsSubjectQuery());){
            stmt.setInt(1, this.getIdAllocating(ref));
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                ResultSet segmentRs;
                int id = rs.getInt(1);
                Number permDef = (Number)rs.getObject(2);
                PSet<ContextValue<?>> contexts = this.getSegmentContexts(id);
                PMap<String, Integer> permValues = PCollections.map();
                PMap<String, String> optionValues = PCollections.map();
                PVector<SqlSubjectRef<Object>> inheritanceValues = PCollections.vector();
                try (PreparedStatement permStmt = this.prepareStatement(this.getSelectPermissionsSegmentQuery());){
                    permStmt.setInt(1, id);
                    segmentRs = permStmt.executeQuery();
                    while (segmentRs.next()) {
                        permValues = permValues.plus(segmentRs.getString(1), segmentRs.getInt(2));
                    }
                }
                try (PreparedStatement optStmt = this.prepareStatement(this.getSelectOptionsSegmentQuery());){
                    optStmt.setInt(1, id);
                    segmentRs = optStmt.executeQuery();
                    while (segmentRs.next()) {
                        optionValues = optionValues.plus(segmentRs.getString(1), segmentRs.getString(2));
                    }
                }
                try (PreparedStatement inheritStmt = this.prepareStatement(this.getSelectInheritanceSegmentQuery());){
                    inheritStmt.setInt(1, id);
                    segmentRs = inheritStmt.executeQuery();
                    while (segmentRs.next()) {
                        inheritanceValues = inheritanceValues.plus(new SqlSubjectRef(this.ds.ctx(), segmentRs.getInt(3), segmentRs.getString(4), segmentRs.getString(5)));
                    }
                }
                result = result.plus(new SqlSegment(id, contexts, permValues, optionValues, inheritanceValues, permDef == null ? null : Integer.valueOf(permDef.intValue()), PCollections.vector()));
            }
        }
        return result;
    }

    public SqlSegment addSegment(SqlSubjectRef<?> ref) throws SQLException {
        SqlSegment segment = SqlSegment.unallocated();
        this.allocateSegment(ref, segment);
        return segment;
    }

    public void updateFullSegment(SqlSubjectRef<?> ref, SqlSegment segment) throws SQLException {
        this.executeInTransaction(() -> {
            this.allocateSegment(ref, segment);
            this.setContexts(segment, segment.contexts());
            this.setOptions(segment, segment.options());
            this.setParents(segment, segment.parents());
            this.setPermissions(segment, segment.permissions());
            this.setDefaultValue(segment, segment.fallbackPermission());
            return null;
        });
    }

    public void setContexts(SqlSegment seg, PSet<ContextValue<?>> contexts) throws SQLException {
        this.executeInTransaction(() -> {
            try (PreparedStatement delete = this.prepareStatement(this.getDeleteContextQuery());
                 PreparedStatement insert = this.prepareStatement(this.getInsertContextQuery());){
                delete.setInt(1, seg.id());
                delete.executeUpdate();
                insert.setInt(1, seg.id());
                for (ContextValue context : contexts) {
                    insert.setString(2, context.key());
                    insert.setString(3, context.rawValue());
                    insert.addBatch();
                }
                insert.executeBatch();
            }
            return null;
        });
    }

    public void allocateSegment(SqlSubjectRef<?> subject, SqlSegment val) throws SQLException {
        if (!val.isUnallocated()) {
            return;
        }
        try (PreparedStatement stmt = this.prepareStatement(this.getInsertSegmentQuery(), 1);){
            stmt.setInt(1, this.getIdAllocating(subject));
            if (val.fallbackPermission() == 0) {
                stmt.setNull(2, 4);
            } else {
                stmt.setInt(2, val.fallbackPermission());
            }
            stmt.executeUpdate();
            ResultSet res = stmt.getGeneratedKeys();
            res.next();
            val.id(res.getInt(1));
        }
        this.setContexts(val, val.contexts());
    }

    public boolean removeSegment(SqlSegment segment) throws SQLException {
        try (PreparedStatement stmt = this.prepareStatement(this.getDeleteSegmentIdQuery());){
            stmt.setInt(1, segment.id());
            boolean bl = stmt.executeUpdate() > 0;
            return bl;
        }
    }

    public Set<String> getAllIdentifiers(String type) throws SQLException {
        try (PreparedStatement stmt = this.prepareStatement(this.getSelectSubjectIdentifiersQuery());){
            stmt.setString(1, type);
            ResultSet rs = stmt.executeQuery();
            PSet<String> ret = PCollections.set();
            while (rs.next()) {
                ret = ret.plus(rs.getString(1));
            }
            PSet<String> pSet = ret;
            return pSet;
        }
    }

    public Set<String> getRegisteredTypes() throws SQLException {
        try (ResultSet rs = this.prepareStatement(this.getSelectSubjectTypesQuery()).executeQuery();){
            PSet<String> ret = PCollections.set();
            while (rs.next()) {
                ret = ret.plus(rs.getString(1));
            }
            PSet<String> pSet = ret;
            return pSet;
        }
    }

    public void initializeTables() throws SQLException {
        if (this.hasTable("permissions")) {
            return;
        }
        String database = this.conn.getMetaData().getDatabaseProductName().toLowerCase();
        try (InputStream res = SqlDao.class.getResourceAsStream("deploy/" + database + ".sql");){
            if (res == null) {
                throw new SQLException("No initial schema available for " + database + " databases!");
            }
            try (BufferedReader read = new BufferedReader(new InputStreamReader(res, StandardCharsets.UTF_8));){
                this.executeStream(read);
            }
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
    }

    void executeStream(BufferedReader reader) throws SQLException, IOException {
        try (Statement stmt = this.conn.createStatement();){
            String line;
            StringBuilder currentQuery = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("--")) continue;
                currentQuery.append(line);
                if (!line.endsWith(";")) continue;
                currentQuery.deleteCharAt(currentQuery.length() - 1);
                String queryLine = currentQuery.toString().trim();
                currentQuery = new StringBuilder();
                if (queryLine.isEmpty()) continue;
                stmt.addBatch(this.ds.insertPrefix(queryLine));
            }
            stmt.executeBatch();
        }
    }

    private boolean hasTable(String table) throws SQLException {
        return this.conn.getMetaData().getTables(null, null, this.ds.getTableName(table).toUpperCase(), null).next();
    }

    public void clearOption(SqlSegment segment, String option) throws SQLException {
        try (PreparedStatement stmt = this.prepareStatement(this.getDeleteOptionKeyQuery());){
            stmt.setInt(1, segment.id());
            stmt.setString(2, option);
            stmt.executeUpdate();
        }
    }

    public void setOptions(SqlSegment seg, @Nullable Map<String, String> options) throws SQLException {
        this.executeInTransaction(() -> {
            try (PreparedStatement del = this.prepareStatement(this.getDeleteOptionsQuery());
                 PreparedStatement ins = this.prepareStatement(this.getInsertOptionUpdatingQuery());){
                del.setInt(1, seg.id());
                del.executeUpdate();
                if (options != null) {
                    ins.setInt(1, seg.id());
                    for (Map.Entry ent : options.entrySet()) {
                        ins.setString(2, (String)ent.getKey());
                        ins.setString(3, (String)ent.getValue());
                        ins.addBatch();
                    }
                    ins.executeBatch();
                }
            }
            return null;
        });
    }

    public void setOption(SqlSegment segment, String key, String value) throws SQLException {
        try (PreparedStatement stmt = this.prepareStatement(this.getInsertOptionUpdatingQuery());){
            stmt.setInt(1, segment.id());
            stmt.setString(2, key);
            stmt.setString(3, value);
            stmt.executeUpdate();
        }
    }

    public void setPermission(SqlSegment segment, String permission, int value) throws SQLException {
        try (PreparedStatement stmt = this.prepareStatement(this.getInsertPermissionUpdatingQuery());){
            stmt.setInt(1, segment.id());
            stmt.setString(2, permission);
            stmt.setInt(3, value);
            stmt.executeUpdate();
        }
    }

    public void clearPermission(SqlSegment segment, String permission) throws SQLException {
        try (PreparedStatement stmt = this.prepareStatement(this.getDeletePermissionKeyQuery());){
            stmt.setInt(1, segment.id());
            stmt.setString(2, permission);
            stmt.executeUpdate();
        }
    }

    public void setPermissions(SqlSegment segment, @Nullable Map<String, Integer> permissions) throws SQLException {
        this.executeInTransaction(() -> {
            try (PreparedStatement del = this.prepareStatement(this.getDeletePermissionsQuery());
                 PreparedStatement ins = this.prepareStatement(this.getInsertPermissionUpdatingQuery());){
                del.setInt(1, segment.id());
                del.executeUpdate();
                if (permissions != null) {
                    ins.setInt(1, segment.id());
                    for (Map.Entry ent : permissions.entrySet()) {
                        ins.setString(2, (String)ent.getKey());
                        ins.setInt(3, (Integer)ent.getValue());
                        ins.addBatch();
                    }
                    ins.executeBatch();
                }
            }
            return null;
        });
    }

    public void setDefaultValue(SqlSegment segment, @Nullable Integer permissionDefault) throws SQLException {
        try (PreparedStatement stmt = this.prepareStatement(this.getUpdatePermissionDefaultQuery());){
            if (permissionDefault == null || permissionDefault == 0) {
                stmt.setNull(1, 4);
            } else {
                stmt.setInt(1, permissionDefault);
            }
            stmt.setInt(2, segment.id());
            stmt.executeUpdate();
        }
    }

    public void addParent(SqlSegment seg, SqlSubjectRef<?> parent) throws SQLException {
        try (PreparedStatement stmt = this.prepareStatement(this.getInsertInheritanceQuery());){
            stmt.setInt(1, seg.id());
            stmt.setInt(2, this.getIdAllocating(parent));
            stmt.executeUpdate();
        }
    }

    public void removeParent(SqlSegment segment, SqlSubjectRef<?> parent) throws SQLException {
        try (PreparedStatement stmt = this.prepareStatement(this.getDeleteInheritanceParentQuery());){
            stmt.setInt(1, segment.id());
            stmt.setInt(2, this.getIdAllocating(parent));
            stmt.executeUpdate();
        }
    }

    public void setParents(SqlSegment segment, @Nullable Iterable<SqlSubjectRef<?>> parents) throws SQLException {
        this.executeInTransaction(() -> {
            try (PreparedStatement del = this.prepareStatement(this.getDeleteInheritanceQuery());
                 PreparedStatement ins = this.prepareStatement(this.getInsertInheritanceQuery());){
                del.setInt(1, segment.id());
                del.executeUpdate();
                if (parents != null) {
                    ins.setInt(1, segment.id());
                    for (SqlSubjectRef ent : parents) {
                        ins.setInt(2, this.getIdAllocating(ent));
                        ins.addBatch();
                    }
                    ins.executeBatch();
                }
            }
            return null;
        });
    }

    public SqlContextInheritance getContextInheritance() throws SQLException {
        try (PreparedStatement stmt = this.prepareStatement(this.getSelectContextInheritanceQuery());){
            PMap<ContextValue<Object>, PVector<ContextValue<Object>>> ret = PCollections.map();
            @Nullable ContextValue<V> current = null;
            PVector builder = PCollections.vector();
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                String childKey = rs.getString(1);
                String childValue = rs.getString(2);
                String parentKey = rs.getString(3);
                String parentValue = rs.getString(4);
                if (current == null || !childKey.equals(current.key()) || !childValue.equals(current.rawValue())) {
                    if (current != null && !builder.isEmpty()) {
                        ret = ret.plus(current, builder);
                    }
                    current = new ContextValue(childKey, childValue);
                    builder = PCollections.vector();
                }
                builder = builder.plus(new ContextValue(parentKey, parentValue));
            }
            if (current != null) {
                ret = ret.plus(current, builder);
            }
            SqlContextInheritance sqlContextInheritance = new SqlContextInheritance(ret);
            return sqlContextInheritance;
        }
    }

    public void setContextInheritance(ContextValue<?> child, @Nullable PVector<ContextValue<?>> parents) throws SQLException {
        this.executeInTransaction(() -> {
            try (PreparedStatement delete = this.prepareStatement(this.getDeleteContextInheritanceQuery());
                 PreparedStatement insert = this.prepareStatement(this.getInsertContextInheritanceQuery());){
                delete.setString(1, child.key());
                delete.setString(2, child.rawValue());
                delete.executeUpdate();
                if (parents != null && parents.size() > 0) {
                    insert.setString(1, child.key());
                    insert.setString(2, child.rawValue());
                    for (ContextValue parent : parents) {
                        insert.setString(3, parent.key());
                        insert.setString(4, parent.rawValue());
                        insert.addBatch();
                    }
                    insert.executeBatch();
                }
            }
            return null;
        });
    }

    public RankLadder getRankLadder(String name) throws SQLException {
        PVector<SubjectRef<?>> elements = PCollections.vector();
        try (PreparedStatement stmt = this.prepareStatement(this.getSelectRankLadderQuery());){
            stmt.setString(1, name);
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                elements = elements.plus(new SqlSubjectRef(this.ds.ctx(), rs.getInt(2), rs.getString(3), rs.getString(4)));
            }
        }
        return new SqlRankLadder(name, elements);
    }

    public boolean hasEntriesForRankLadder(String name) throws SQLException {
        try (PreparedStatement stmt = this.prepareStatement(this.getTestRankLadderExistsQuery());){
            stmt.setString(1, name);
            boolean bl = stmt.executeQuery().next();
            return bl;
        }
    }

    public void setRankLadder(String name, @Nullable RankLadder ladder) throws SQLException {
        this.executeInTransaction(() -> {
            List<Object> ranks = ladder == null ? PCollections.vector() : ladder.ranks();
            try (PreparedStatement delete = this.prepareStatement(this.getDeleteRankLadderQuery());
                 PreparedStatement insert = this.prepareStatement(this.getInsertRankLadderQuery());){
                delete.setString(1, name);
                delete.executeUpdate();
                if (ladder != null) {
                    insert.setString(1, name);
                    for (SubjectRef subjectRef : ranks) {
                        SqlSubjectRef ref = SqlSubjectRef.from(subjectRef);
                        insert.setInt(2, this.getIdAllocating(ref));
                        insert.addBatch();
                    }
                    insert.executeBatch();
                }
            }
            return null;
        });
    }

    public Set<String> getAllRankLadderNames() throws SQLException {
        try (PreparedStatement stmt = this.prepareStatement(this.getSelectAllRankLadderNamesQuery());){
            PSet<String> ret = PCollections.set();
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                ret = ret.plus(rs.getString(1));
            }
            PSet<String> pSet = ret;
            return pSet;
        }
    }

    public Iterable<SqlSubjectRef<?>> getAllSubjectRefs() throws SQLException {
        try (PreparedStatement stmt = this.prepareStatement(this.getSelectAllSubjectsQuery());){
            PSet<SqlSubjectRef<Object>> ret = PCollections.set();
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                ret = ret.plus(new SqlSubjectRef(this.ds.ctx(), rs.getInt(1), rs.getString(2), rs.getString(3)));
            }
            PSet<SqlSubjectRef<?>> pSet = ret;
            return pSet;
        }
    }

    public Set<String> getUsedContextKeys() throws SQLException {
        try (PreparedStatement stmt = this.prepareStatement(this.getSelectAllContextKeysUniqueQuery());){
            PSet<String> builder = PCollections.set();
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                builder = builder.plus(rs.getString(1));
            }
            PSet<String> pSet = builder;
            return pSet;
        }
    }

    @Override
    public void close() throws SQLException {
        if (this.holdOpen <= 0) {
            this.conn.close();
        }
    }

    public void renameTable(String oldName, String newName) throws SQLException {
        String expandedOld = this.ds.getTableName(oldName);
        String expandedNew = this.ds.getTableName(newName);
        try (PreparedStatement stmt = this.prepareStatement(this.getRenameTableQuery());){
            stmt.setString(1, expandedOld);
            stmt.setString(2, expandedNew);
            stmt.executeUpdate();
        }
    }

    public void deleteTable(String table) throws SQLException {
        try (PreparedStatement stmt = this.prepareStatement("DROP TABLE " + this.ds.getTableName(table));){
            stmt.executeUpdate();
        }
    }

    public int getSchemaVersion() throws SQLException {
        if (this.hasTable("global")) {
            return this.getGlobalParameter("schema_version").map(Integer::valueOf).orElse(-1);
        }
        if (this.legacy().hasTable(this, "permissions")) {
            @Nullable String ret = this.legacy().getOption(this, "system", LegacyMigration.Type.WORLD, null, "schema-version");
            return ret == null ? -1 : Integer.parseInt(ret);
        }
        return -2;
    }

    public void setSchemaVersion(int version) throws SQLException {
        this.setGlobalParameter("schema_version", Integer.toString(version));
    }

    public SqlDataStore getDataStore() {
        return this.ds;
    }

    public Connection getConnection() {
        return this.conn;
    }
}

