/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.datastore.sql;

import ca.stellardrift.permissionsex.context.ContextInheritance;
import ca.stellardrift.permissionsex.context.ContextValue;
import ca.stellardrift.permissionsex.datastore.DataStore;
import ca.stellardrift.permissionsex.datastore.DataStoreContext;
import ca.stellardrift.permissionsex.datastore.DataStoreFactory;
import ca.stellardrift.permissionsex.datastore.ProtoDataStore;
import ca.stellardrift.permissionsex.datastore.sql.Messages;
import ca.stellardrift.permissionsex.datastore.sql.SchemaMigrations;
import ca.stellardrift.permissionsex.datastore.sql.SqlContextInheritance;
import ca.stellardrift.permissionsex.datastore.sql.SqlDao;
import ca.stellardrift.permissionsex.datastore.sql.SqlSegment;
import ca.stellardrift.permissionsex.datastore.sql.SqlSubjectData;
import ca.stellardrift.permissionsex.datastore.sql.SqlSubjectRef;
import ca.stellardrift.permissionsex.datastore.sql.dao.H2SqlDao;
import ca.stellardrift.permissionsex.datastore.sql.dao.MySqlDao;
import ca.stellardrift.permissionsex.datastore.sql.dao.SchemaMigration;
import ca.stellardrift.permissionsex.exception.PermissionsLoadingException;
import ca.stellardrift.permissionsex.ext.checkerframework.checker.nullness.qual.Nullable;
import ca.stellardrift.permissionsex.ext.configurate.BasicConfigurationNode;
import ca.stellardrift.permissionsex.ext.configurate.objectmapping.ConfigSerializable;
import ca.stellardrift.permissionsex.ext.configurate.objectmapping.meta.Setting;
import ca.stellardrift.permissionsex.ext.configurate.util.CheckedFunction;
import ca.stellardrift.permissionsex.ext.configurate.util.UnmodifiableCollections;
import ca.stellardrift.permissionsex.ext.pcollections.PMap;
import ca.stellardrift.permissionsex.ext.pcollections.PSet;
import ca.stellardrift.permissionsex.impl.backend.AbstractDataStore;
import ca.stellardrift.permissionsex.impl.config.FilePermissionsExConfiguration;
import ca.stellardrift.permissionsex.impl.util.PCollections;
import ca.stellardrift.permissionsex.rank.RankLadder;
import ca.stellardrift.permissionsex.subject.ImmutableSubjectData;
import ca.stellardrift.permissionsex.subject.SubjectRef;
import com.google.auto.service.AutoService;
import com.google.common.annotations.VisibleForTesting;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.sql.DataSource;

public final class SqlDataStore
extends AbstractDataStore<SqlDataStore, Config> {
    private static final Pattern BRACES_PATTERN = Pattern.compile("\\{\\}");
    private boolean autoInitialize = true;
    private final ConcurrentMap<String, String> queryPrefixCache = new ConcurrentHashMap<String, String>();
    private final ThreadLocal<@Nullable SqlDao> heldDao = new ThreadLocal();
    private final PMap<String, CheckedFunction<SqlDataStore, SqlDao, SQLException>> daoImplementations = PCollections.map("mysql", MySqlDao::new).plus("h2", H2SqlDao::new);
    private CheckedFunction<SqlDataStore, SqlDao, SQLException> daoFactory;
    private DataSource sql;

    SqlDataStore(DataStoreContext context, ProtoDataStore<Config> properties) {
        super(context, properties);
    }

    @VisibleForTesting
    static ProtoDataStore<?> create(String ident, String jdbcUrl, String tablePrefix, boolean autoInitialize) {
        try {
            return DataStoreFactory.forType(Factory.ID).create(ident, BasicConfigurationNode.root(FilePermissionsExConfiguration.PEX_OPTIONS, n -> {
                ((BasicConfigurationNode)n.node(new Object[]{"url"})).raw(jdbcUrl);
                ((BasicConfigurationNode)n.node(new Object[]{"prefix"})).raw(tablePrefix);
                ((BasicConfigurationNode)n.node(new Object[]{"auto-initialize"})).raw(autoInitialize);
            }));
        }
        catch (PermissionsLoadingException e) {
            throw new RuntimeException(e);
        }
    }

    SqlDao getDao() throws SQLException {
        @Nullable SqlDao dao = this.heldDao.get();
        if (dao != null) {
            return dao;
        }
        return this.daoFactory.apply(this);
    }

    DataStoreContext ctx() {
        return super.context();
    }

    @Override
    protected void load() throws PermissionsLoadingException {
        try {
            this.sql = this.context().dataSourceForUrl(((Config)this.config()).connectionUrl);
            try (Connection conn = this.sql.getConnection();){
                String database = conn.getMetaData().getDatabaseProductName().toLowerCase();
                this.daoFactory = (CheckedFunction)this.daoImplementations.get(database);
                if (this.daoFactory == null) {
                    throw new PermissionsLoadingException(Messages.DB_IMPL_NOT_SUPPORTED.tr(database));
                }
            }
        }
        catch (SQLException e) {
            throw new PermissionsLoadingException(Messages.DB_CONNECTION_ERROR.tr(new Object[0]), (Throwable)e);
        }
        if ((((Config)this.config()).autoInitialize == null || ((Config)this.config()).autoInitialize.booleanValue()) && this.autoInitialize) {
            try {
                this.initializeTables();
            }
            catch (SQLException e) {
                throw new PermissionsLoadingException(Messages.ERROR_INITIALIZE_TABLES.tr(new Object[0]), (Throwable)e);
            }
        }
    }

    public void initializeTables() throws SQLException {
        List<SchemaMigration> migrations = SchemaMigrations.getMigrations();
        try (SqlDao dao = this.getDao();){
            int initialVersion = dao.getSchemaVersion();
            if (initialVersion == -2) {
                dao.initializeTables();
                dao.setSchemaVersion(3);
                this.markFirstRun();
            } else {
                int finalVersion = dao.executeInTransaction(() -> {
                    int highestVersion = initialVersion;
                    int i = initialVersion + 1;
                    while (i < migrations.size()) {
                        ((SchemaMigration)migrations.get(i)).migrate(dao);
                        highestVersion = i++;
                    }
                    return highestVersion;
                });
                if (initialVersion != finalVersion) {
                    dao.setSchemaVersion(finalVersion);
                    this.context().logger().info(Messages.SCHEMA_UPDATE_SUCCESS.tr(initialVersion, finalVersion));
                }
            }
        }
    }

    public void setConnectionUrl(String connectionUrl) {
        ((Config)this.config()).connectionUrl = connectionUrl;
    }

    DataSource getDataSource() {
        return this.sql;
    }

    String prefix() {
        return ((Config)this.config()).prefix();
    }

    public String getTableName(String raw) {
        return this.getTableName(raw, false);
    }

    public String getTableName(String raw, boolean legacyOnly) {
        if (((Config)this.config()).legacyAliases != null && ((Config)this.config()).legacyAliases.containsKey(raw)) {
            return (String)((Config)this.config()).legacyAliases.get(raw);
        }
        if (legacyOnly) {
            return raw;
        }
        return ((Config)this.config()).prefix() + raw;
    }

    String insertPrefix(String query) {
        return this.queryPrefixCache.computeIfAbsent(query, qu -> BRACES_PATTERN.matcher((CharSequence)qu).replaceAll(((Config)this.config()).prefix()));
    }

    @Override
    protected CompletableFuture<ImmutableSubjectData> getDataInternal(String type, String identifier) {
        return this.runAsync(() -> {
            try (SqlDao dao = this.getDao();){
                Optional<SqlSubjectRef<?>> ref = dao.getSubjectRef(type, identifier);
                if (ref.isPresent()) {
                    SqlSubjectData sqlSubjectData2 = this.getDataForRef(dao, ref.get());
                    return sqlSubjectData2;
                }
                SqlSubjectData sqlSubjectData = new SqlSubjectData(SqlSubjectRef.unresolved(this.context(), type, identifier));
                return sqlSubjectData;
            }
            catch (SQLException e) {
                throw new PermissionsLoadingException(Messages.ERROR_LOADING.tr(type, identifier));
            }
        });
    }

    private SqlSubjectData getDataForRef(SqlDao dao, SqlSubjectRef<?> ref) throws SQLException {
        List<SqlSegment> segments = dao.getSegments(ref);
        PMap<PSet<ContextValue<?>>, SqlSegment> contexts = PCollections.map();
        for (SqlSegment segment : segments) {
            contexts = contexts.plus(segment.contexts(), segment);
        }
        return new SqlSubjectData(ref, contexts, PCollections.vector());
    }

    @Override
    protected CompletableFuture<ImmutableSubjectData> setDataInternal(String type, String identifier, ImmutableSubjectData data) {
        if (!(data instanceof SqlSubjectData)) {
            return this.runAsync(() -> {
                try (SqlDao dao = this.getDao();){
                    SqlSubjectRef<?> ref = dao.getOrCreateSubjectRef(type, identifier);
                    SqlSubjectData newData = this.getDataForRef(dao, ref);
                    newData = (SqlSubjectData)newData.mergeFrom(data);
                    newData.doUpdates(dao);
                    SqlSubjectData sqlSubjectData = newData;
                    return sqlSubjectData;
                }
            });
        }
        SqlSubjectData sqlData = (SqlSubjectData)data;
        return this.runAsync(() -> {
            try (SqlDao dao = this.getDao();){
                sqlData.doUpdates(dao);
                SqlSubjectData sqlSubjectData = sqlData;
                return sqlSubjectData;
            }
        });
    }

    @Override
    public CompletableFuture<Boolean> isRegistered(String type, String identifier) {
        return this.runAsync(() -> {
            try (SqlDao dao = this.getDao();){
                Boolean bl = dao.getSubjectRef(type, identifier).isPresent();
                return bl;
            }
        });
    }

    @Override
    public Stream<String> getAllIdentifiers(String type) {
        Stream<String> stream;
        block8: {
            SqlDao dao = this.getDao();
            try {
                stream = dao.getAllIdentifiers(type).stream();
                if (dao == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (dao != null) {
                        try {
                            dao.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    return Stream.of(new String[0]);
                }
            }
            dao.close();
        }
        return stream;
    }

    @Override
    public Set<String> getRegisteredTypes() {
        Set<String> set;
        block8: {
            SqlDao dao = this.getDao();
            try {
                set = dao.getRegisteredTypes();
                if (dao == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (dao != null) {
                        try {
                            dao.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    return Collections.emptySet();
                }
            }
            dao.close();
        }
        return set;
    }

    @Override
    public CompletableFuture<Set<String>> getDefinedContextKeys() {
        return this.runAsync(() -> {
            try (SqlDao dao = this.getDao();){
                Set<String> set = dao.getUsedContextKeys();
                return set;
            }
        });
    }

    @Override
    public Stream<Map.Entry<SubjectRef<?>, ImmutableSubjectData>> getAll() {
        Stream stream;
        block9: {
            SqlDao dao = this.getDao();
            try {
                HashSet builder = new HashSet();
                for (SqlSubjectRef<?> ref : dao.getAllSubjectRefs()) {
                    builder.add(UnmodifiableCollections.immutableMapEntry(ref, this.getDataForRef(dao, ref)));
                }
                stream = builder.stream();
                if (dao == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (dao != null) {
                        try {
                            dao.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    return Stream.of(new Map.Entry[0]);
                }
            }
            dao.close();
        }
        return stream;
    }

    @Override
    protected CompletableFuture<RankLadder> getRankLadderInternal(String ladder) {
        return this.runAsync(() -> {
            try (SqlDao dao = this.getDao();){
                RankLadder rankLadder = dao.getRankLadder(ladder);
                return rankLadder;
            }
        });
    }

    @Override
    protected CompletableFuture<RankLadder> setRankLadderInternal(String ladder, @Nullable RankLadder newLadder) {
        return this.runAsync(() -> {
            try (SqlDao dao = this.getDao();){
                dao.setRankLadder(ladder, newLadder);
                RankLadder rankLadder = dao.getRankLadder(ladder);
                return rankLadder;
            }
        });
    }

    @Override
    public Stream<String> getAllRankLadders() {
        Stream<String> stream;
        block8: {
            SqlDao dao = this.getDao();
            try {
                stream = dao.getAllRankLadderNames().stream();
                if (dao == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (dao != null) {
                        try {
                            dao.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    return Stream.of(new String[0]);
                }
            }
            dao.close();
        }
        return stream;
    }

    @Override
    public CompletableFuture<Boolean> hasRankLadder(String ladder) {
        return this.runAsync(() -> {
            try (SqlDao dao = this.getDao();){
                Boolean bl = dao.hasEntriesForRankLadder(ladder);
                return bl;
            }
        });
    }

    @Override
    public CompletableFuture<ContextInheritance> getContextInheritanceInternal() {
        return this.runAsync(() -> {
            try (SqlDao dao = this.getDao();){
                SqlContextInheritance sqlContextInheritance = dao.getContextInheritance();
                return sqlContextInheritance;
            }
        });
    }

    @Override
    public CompletableFuture<ContextInheritance> setContextInheritanceInternal(ContextInheritance inheritance) {
        return this.runAsync(() -> {
            try (SqlDao dao = this.getDao();){
                SqlContextInheritance sqlInheritance = inheritance instanceof SqlContextInheritance ? (SqlContextInheritance)inheritance : new SqlContextInheritance(PCollections.asMap(inheritance.allParents(), (k, v) -> k, (k, v) -> PCollections.asVector(v)), PCollections.vector((dao_, inheritance_) -> {
                    for (Map.Entry<ContextValue<?>, List<ContextValue<?>>> ent : inheritance_.allParents().entrySet()) {
                        dao_.setContextInheritance(ent.getKey(), PCollections.asVector(ent.getValue()));
                    }
                }));
                sqlInheritance.doUpdate(dao);
            }
            return inheritance;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected <T> T performBulkOperationSync(Function<DataStore, T> function) throws Exception {
        SqlDao dao = null;
        dao = this.getDao();
        this.heldDao.set(dao);
        ++dao.holdOpen;
        T t = function.apply(this);
        return t;
        finally {
            if (dao != null) {
                if (--dao.holdOpen == 0) {
                    this.heldDao.remove();
                }
                try {
                    dao.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    @Override
    public void close() {
        this.queryPrefixCache.clear();
        this.heldDao.remove();
    }

    public void setPrefix(String prefix) {
        ((Config)this.config()).prefix = prefix;
        ((Config)this.config()).realPrefix = null;
    }

    public void setAutoInitialize(boolean autoInitialize) {
        this.autoInitialize = autoInitialize;
    }

    @ConfigSerializable
    static class Config {
        @Setting(value="url")
        private String connectionUrl;
        @Setting(value="prefix")
        private String prefix = "pex";
        private transient String realPrefix;
        @Setting(value="aliases")
        private Map<String, String> legacyAliases;
        @Setting
        private @Nullable Boolean autoInitialize = null;

        Config() {
        }

        String prefix() {
            if (this.realPrefix == null) {
                this.realPrefix = this.prefix != null && !this.prefix.isEmpty() && !this.prefix.endsWith("_") ? this.prefix + "_" : (this.prefix == null ? "" : this.prefix);
            }
            return this.realPrefix;
        }
    }

    @AutoService(value={DataStoreFactory.class})
    public static final class Factory
    extends AbstractDataStore.Factory<SqlDataStore, Config> {
        static String ID = "sql";

        public Factory() {
            super(ID, Config.class, SqlDataStore::new);
        }
    }
}

