/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.datastore.sql;

import ca.stellardrift.permissionsex.context.ContextValue;
import ca.stellardrift.permissionsex.datastore.sql.CheckedBiConsumer;
import ca.stellardrift.permissionsex.datastore.sql.SqlDao;
import ca.stellardrift.permissionsex.datastore.sql.SqlSubjectRef;
import ca.stellardrift.permissionsex.ext.checkerframework.checker.nullness.qual.Nullable;
import ca.stellardrift.permissionsex.ext.pcollections.PMap;
import ca.stellardrift.permissionsex.ext.pcollections.PSet;
import ca.stellardrift.permissionsex.ext.pcollections.PVector;
import ca.stellardrift.permissionsex.impl.util.PCollections;
import ca.stellardrift.permissionsex.subject.Segment;
import ca.stellardrift.permissionsex.subject.SubjectRef;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

class SqlSegment
implements Segment {
    private static final AtomicReferenceFieldUpdater<SqlSegment, PVector<CheckedBiConsumer<SqlDao, SqlSegment, SQLException>>> UPDATES_MUTATOR = AtomicReferenceFieldUpdater.newUpdater(SqlSegment.class, PVector.class, "updatesToPerform");
    private volatile int id;
    private final PSet<ContextValue<?>> contexts;
    private final PMap<String, Integer> permissions;
    private final PMap<String, String> options;
    private final PVector<SqlSubjectRef<?>> parents;
    private final @Nullable Integer permissionDefault;
    private volatile PVector<CheckedBiConsumer<SqlDao, SqlSegment, SQLException>> updatesToPerform;

    SqlSegment(int id, PSet<ContextValue<?>> contexts, PMap<String, Integer> permissions, PMap<String, String> options, PVector<SqlSubjectRef<?>> parents, @Nullable Integer permissionDefault, PVector<CheckedBiConsumer<SqlDao, SqlSegment, SQLException>> updates) {
        this.id = id;
        this.contexts = contexts;
        this.permissions = permissions;
        this.options = options;
        this.parents = parents;
        this.permissionDefault = permissionDefault;
        this.updatesToPerform = updates;
    }

    static SqlSegment empty(int id) {
        return new SqlSegment(id, PCollections.set(), PCollections.map(), PCollections.map(), PCollections.vector(), null, PCollections.vector());
    }

    static SqlSegment empty(int id, PSet<ContextValue<?>> contexts) {
        return new SqlSegment(id, contexts, PCollections.map(), PCollections.map(), PCollections.vector(), null, PCollections.vector());
    }

    private SqlSegment newWithUpdate(PMap<String, Integer> permissions, PMap<String, String> options, PVector<SqlSubjectRef<?>> parents, @Nullable Integer permissionDefault, CheckedBiConsumer<SqlDao, SqlSegment, SQLException> updateFunc) {
        return new SqlSegment(this.id, this.contexts, permissions, options, parents, permissionDefault, this.updatesToPerform.plus(updateFunc));
    }

    static SqlSegment unallocated() {
        return SqlSegment.empty(-1);
    }

    static SqlSegment unallocated(PSet<ContextValue<?>> contexts) {
        return SqlSegment.empty(-1, contexts);
    }

    static SqlSegment from(PSet<ContextValue<?>> contexts, Segment other) {
        if (other instanceof SqlSegment) {
            return ((SqlSegment)other).contexts(contexts);
        }
        return new SqlSegment(-1, contexts, PCollections.asMap(other.permissions()), PCollections.asMap(other.options()), PCollections.asVector(other.parents(), SqlSubjectRef::from), other.fallbackPermission() == 0 ? null : Integer.valueOf(other.fallbackPermission()), PCollections.vector());
    }

    public int id() {
        if (this.id == -1) {
            throw new IllegalStateException("Unable to find issues");
        }
        return this.id;
    }

    boolean isUnallocated() {
        return this.id == -1;
    }

    public void id(int id) {
        this.id = id;
    }

    public PSet<ContextValue<?>> contexts() {
        return this.contexts;
    }

    SqlSegment contexts(PSet<ContextValue<?>> contexts) {
        if (contexts.equals(this.contexts)) {
            return this;
        }
        return new SqlSegment(-1, contexts, this.permissions, this.options, this.parents, this.permissionDefault, PCollections.vector());
    }

    @Override
    public Map<String, Integer> permissions() {
        return this.permissions;
    }

    @Override
    public Map<String, String> options() {
        return this.options;
    }

    public List<SqlSubjectRef<?>> parents() {
        return this.parents;
    }

    @Override
    public int fallbackPermission() {
        return this.permissionDefault == null ? 0 : this.permissionDefault;
    }

    @Override
    public SqlSegment withOption(String key, String value) {
        return this.newWithUpdate(this.permissions, this.options.plus(key, value), this.parents, this.permissionDefault, (dao, seg) -> dao.setOption((SqlSegment)seg, key, value));
    }

    @Override
    public SqlSegment withoutOption(String key) {
        if (!this.options.containsKey(key)) {
            return this;
        }
        return this.newWithUpdate(this.permissions, this.options.minus(key), this.parents, this.permissionDefault, (dao, seg) -> dao.clearOption((SqlSegment)seg, key));
    }

    @Override
    public SqlSegment withOptions(Map<String, String> values) {
        PMap<String, String> immValues = PCollections.asMap(values);
        return this.newWithUpdate(this.permissions, immValues, this.parents, this.permissionDefault, (dao, seg) -> dao.setOptions((SqlSegment)seg, (Map<String, String>)immValues));
    }

    @Override
    public SqlSegment withoutOptions() {
        return this.newWithUpdate(this.permissions, PCollections.map(), this.parents, this.permissionDefault, (dao, seg) -> dao.setOptions((SqlSegment)seg, null));
    }

    @Override
    public SqlSegment withPermission(String permission, int value) {
        if (value == 0 && !this.permissions.containsKey(permission)) {
            return this;
        }
        return this.newWithUpdate(value == 0 ? this.permissions.minus(permission) : this.permissions.plus(permission, value), this.options, this.parents, this.permissionDefault, (dao, seg) -> dao.setPermission((SqlSegment)seg, permission, value));
    }

    @Override
    public SqlSegment withPermissions(Map<String, Integer> values) {
        PMap<String, Integer> immValues = PCollections.asMap(values);
        return this.newWithUpdate(immValues, this.options, this.parents, this.permissionDefault, (dao, seg) -> dao.setPermissions((SqlSegment)seg, (Map<String, Integer>)immValues));
    }

    @Override
    public SqlSegment withoutPermissions() {
        return this.newWithUpdate(PCollections.map(), this.options, this.parents, this.permissionDefault, (dao, seg) -> dao.setPermissions((SqlSegment)seg, null));
    }

    @Override
    public SqlSegment withFallbackPermission(int permissionDefault) {
        return this.newWithUpdate(this.permissions, this.options, this.parents, permissionDefault == 0 ? null : Integer.valueOf(permissionDefault), (dao, seg) -> dao.setDefaultValue((SqlSegment)seg, permissionDefault));
    }

    @Override
    public <I> SqlSegment plusParent(SubjectRef<I> parent) {
        SqlSubjectRef sqlParent = SqlSubjectRef.from(parent);
        return this.newWithUpdate(this.permissions, this.options, this.parents.plus(0, sqlParent), this.permissionDefault, (dao, seg) -> dao.addParent((SqlSegment)seg, sqlParent));
    }

    @Override
    public <I> SqlSegment minusParent(SubjectRef<I> parent) {
        if (this.parents.isEmpty()) {
            return this;
        }
        SqlSubjectRef sqlParent = SqlSubjectRef.from(parent);
        return this.newWithUpdate(this.permissions, this.options, this.parents.minus(sqlParent), this.permissionDefault, (dao, seg) -> dao.removeParent((SqlSegment)seg, sqlParent));
    }

    @Override
    public SqlSegment withParents(List<SubjectRef<?>> parents) {
        PVector<SqlSubjectRef<?>> immValues = PCollections.asVector(parents, SqlSubjectRef::from);
        return this.newWithUpdate(this.permissions, this.options, immValues, this.permissionDefault, (dao, seg) -> dao.setParents((SqlSegment)seg, (Iterable<SqlSubjectRef<?>>)immValues));
    }

    @Override
    public SqlSegment withoutParents() {
        return this.newWithUpdate(this.permissions, this.options, PCollections.vector(), this.permissionDefault, (dao, seg) -> dao.setParents((SqlSegment)seg, null));
    }

    @Override
    public Segment cleared() {
        return this.newWithUpdate(PCollections.map(), PCollections.map(), PCollections.vector(), null, SqlDao::removeSegment);
    }

    @Override
    public SqlSegment mergeFrom(Segment other) {
        if (this.empty() && other instanceof SqlSegment) {
            return ((SqlSegment)other).contexts(PCollections.set());
        }
        return (SqlSegment)Segment.super.mergeFrom(other);
    }

    PVector<CheckedBiConsumer<SqlDao, SqlSegment, SQLException>> popUpdates() {
        return UPDATES_MUTATOR.getAndSet(this, PCollections.vector());
    }

    void doUpdates(SqlDao dao) throws SQLException {
        PVector<CheckedBiConsumer<SqlDao, SqlSegment, SQLException>> updateFuncs = this.popUpdates();
        for (CheckedBiConsumer checkedBiConsumer : updateFuncs) {
            checkedBiConsumer.accept(dao, this);
        }
    }

    public String toString() {
        return "Segment{id=" + this.id + ", contexts=" + this.contexts + ", permissions=" + this.permissions + ", options=" + this.options + ", parents=" + this.parents + ", permissionDefault=" + this.permissionDefault + '}';
    }

    @Override
    public boolean empty() {
        return this.permissions.isEmpty() && this.options.isEmpty() && this.parents.isEmpty() && this.permissionDefault == null;
    }
}

