/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.datastore.sql;

import ca.stellardrift.permissionsex.context.ContextValue;
import ca.stellardrift.permissionsex.datastore.sql.CheckedBiConsumer;
import ca.stellardrift.permissionsex.datastore.sql.SqlDao;
import ca.stellardrift.permissionsex.datastore.sql.SqlSegment;
import ca.stellardrift.permissionsex.datastore.sql.SqlSubjectRef;
import ca.stellardrift.permissionsex.ext.checkerframework.checker.nullness.qual.Nullable;
import ca.stellardrift.permissionsex.ext.pcollections.PMap;
import ca.stellardrift.permissionsex.ext.pcollections.PSet;
import ca.stellardrift.permissionsex.ext.pcollections.PStack;
import ca.stellardrift.permissionsex.ext.pcollections.PVector;
import ca.stellardrift.permissionsex.impl.util.PCollections;
import ca.stellardrift.permissionsex.subject.ImmutableSubjectData;
import ca.stellardrift.permissionsex.subject.Segment;
import java.sql.SQLException;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.UnaryOperator;

class SqlSubjectData
implements ImmutableSubjectData {
    private static final AtomicReferenceFieldUpdater<SqlSubjectData, PVector<CheckedBiConsumer<SqlDao, SqlSubjectData, SQLException>>> UPDATES_MUTATOR = AtomicReferenceFieldUpdater.newUpdater(SqlSubjectData.class, PVector.class, "updatesToPerform");
    private final SqlSubjectRef<?> subject;
    private final PMap<PSet<ContextValue<?>>, SqlSegment> segments;
    private volatile PVector<CheckedBiConsumer<SqlDao, SqlSubjectData, SQLException>> updatesToPerform;

    SqlSubjectData(SqlSubjectRef<?> subject) {
        this(subject, PCollections.map(), PCollections.vector());
    }

    SqlSubjectData(SqlSubjectRef<?> subject, PMap<PSet<ContextValue<?>>, SqlSegment> segments, PVector<CheckedBiConsumer<SqlDao, SqlSubjectData, SQLException>> updates) {
        this.subject = subject;
        this.segments = segments;
        this.updatesToPerform = updates;
    }

    protected final SqlSubjectData newWithUpdate(PMap<PSet<ContextValue<?>>, SqlSegment> segments, CheckedBiConsumer<SqlDao, SqlSubjectData, SQLException> updateFunc) {
        return new SqlSubjectData(this.subject, segments, this.updatesToPerform.plus(updateFunc));
    }

    public Map<Set<ContextValue<?>>, Segment> segments() {
        return PCollections.narrow(this.segments);
    }

    @Override
    public ImmutableSubjectData withSegments(BiFunction<Set<ContextValue<?>>, Segment, Segment> transformer) {
        PMap<PSet<ContextValue<?>>, SqlSegment> segments = this.segments;
        PStack<CheckedBiConsumer<SqlDao, SqlSubjectData, SQLException>> updates = PCollections.stack();
        for (Map.Entry entry : this.segments.entrySet()) {
            SqlSegment modified = SqlSegment.from((PSet)entry.getKey(), transformer.apply((Set)entry.getKey(), (Segment)entry.getValue()));
            if (modified == entry.getValue()) continue;
            segments = segments.plus((PSet)entry.getKey(), modified);
            updates = updates.plus(this.makeUpdater((PSet)entry.getKey(), modified));
        }
        if (segments != this.segments) {
            return new SqlSubjectData(this.subject, segments, this.updatesToPerform.plusAll(updates));
        }
        return this;
    }

    @Override
    public ImmutableSubjectData withSegment(Set<ContextValue<?>> rawContexts, UnaryOperator<Segment> operation) {
        SqlSegment output;
        PSet<ContextValue<?>> contexts = PCollections.asSet(rawContexts);
        Segment input = this.segment(contexts);
        if (input != (output = SqlSegment.from(contexts, (Segment)operation.apply(input)))) {
            return this.withSegment(contexts, output);
        }
        return this;
    }

    @Override
    public <V> Map<Set<ContextValue<?>>, V> mapSegmentValues(Function<Segment, V> mapper) {
        return PCollections.asMap(this.segments, (k, v) -> k, (k, v) -> mapper.apply((Segment)v));
    }

    @Override
    public <V> @Nullable V mapSegment(Set<ContextValue<?>> contexts, Function<Segment, V> mapper) {
        SqlSegment segment = (SqlSegment)this.segments.get(PCollections.asSet(contexts));
        if (segment != null) {
            return mapper.apply(segment);
        }
        return null;
    }

    @Override
    public SqlSegment segment(Set<ContextValue<?>> contexts) {
        PSet<ContextValue<?>> pContexts = PCollections.asSet(contexts);
        SqlSegment res = (SqlSegment)this.segments.get(pContexts);
        if (res == null) {
            res = SqlSegment.unallocated(pContexts);
        }
        return res;
    }

    @Override
    public ImmutableSubjectData withSegment(Set<ContextValue<?>> rawContexts, Segment rawSegment) {
        PSet<ContextValue<?>> contexts = PCollections.asSet(rawContexts);
        SqlSegment segment = SqlSegment.from(contexts, rawSegment);
        return this.newWithUpdate(this.segments.plus(contexts, segment), this.makeUpdater(contexts, segment));
    }

    private CheckedBiConsumer<SqlDao, SqlSubjectData, SQLException> makeUpdater(PSet<ContextValue<?>> contexts, SqlSegment segment) {
        if (segment.empty()) {
            if (segment.isUnallocated()) {
                return (dao, data) -> {};
            }
            return (dao, data) -> dao.removeSegment(segment);
        }
        if (segment.isUnallocated()) {
            return (dao, data) -> {
                SqlSegment seg = (SqlSegment)data.segments.get(contexts);
                if (seg != null) {
                    if (seg.isUnallocated()) {
                        seg.popUpdates();
                        dao.updateFullSegment(data.subject, seg);
                    } else {
                        seg.doUpdates((SqlDao)dao);
                    }
                }
            };
        }
        return (dao, data) -> segment.doUpdates((SqlDao)dao);
    }

    public Set<Set<ContextValue<?>>> activeContexts() {
        return this.segments().keySet();
    }

    public void doUpdates(SqlDao dao) throws SQLException {
        dao.executeInTransaction(() -> {
            PVector updates = UPDATES_MUTATOR.getAndSet(this, PCollections.vector());
            for (CheckedBiConsumer func : updates) {
                func.accept(dao, this);
            }
            return null;
        });
    }
}

