/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.datastore.sql;

import ca.stellardrift.permissionsex.datastore.DataStoreContext;
import ca.stellardrift.permissionsex.ext.checkerframework.checker.nullness.qual.Nullable;
import ca.stellardrift.permissionsex.subject.SubjectRef;
import ca.stellardrift.permissionsex.subject.SubjectType;
import java.util.Objects;

public class SqlSubjectRef<I>
implements SubjectRef<I> {
    private volatile int id;
    private volatile @Nullable SubjectRef<I> resolved = null;
    private final DataStoreContext context;
    private final String type;
    private final String identifier;

    SqlSubjectRef(DataStoreContext context, int id, String type, String identifier) {
        this.context = context;
        this.id = id;
        this.type = type;
        this.identifier = identifier;
    }

    SqlSubjectRef(SubjectRef<I> existing) {
        this.id = -1;
        this.context = null;
        this.type = existing.type().name();
        this.identifier = null;
        this.resolved = SubjectRef.mapKeySafe(existing);
    }

    public static <I> SqlSubjectRef<I> unresolved(DataStoreContext context, String type, String name) {
        return new SqlSubjectRef<I>(context, -1, type, name);
    }

    public int id() {
        if (this.id == -1) {
            throw new IllegalStateException("Unallocated SubjectRef tried to be used!");
        }
        return this.id;
    }

    public void id(int id) {
        this.id = id;
    }

    boolean isUnallocated() {
        return this.id == -1;
    }

    public String rawType() {
        return this.type;
    }

    public String rawIdentifier() {
        if (this.identifier == null) {
            @Nullable SubjectRef<I> resolved = this.resolved;
            if (resolved == null) {
                throw new IllegalStateException("Unable to get an identifier for this subject ref");
            }
            return resolved.serializedIdentifier();
        }
        return this.identifier;
    }

    @Override
    public String serializedIdentifier() {
        @Nullable SubjectRef<I> resolved = this.resolved;
        if (resolved != null) {
            return resolved.serializedIdentifier();
        }
        return this.identifier;
    }

    @Override
    public SubjectType<I> type() {
        return this.resolved().type();
    }

    @Override
    public I identifier() {
        return this.resolved().identifier();
    }

    public SubjectRef<I> resolved() {
        if (this.resolved != null) {
            return this.resolved;
        }
        this.resolved = this.context.deserializeSubjectRef(this.type, this.identifier);
        return this.resolved;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SqlSubjectRef)) {
            return false;
        }
        SqlSubjectRef that = (SqlSubjectRef)other;
        return Objects.equals(this.type, that.type) && Objects.equals(this.identifier, that.identifier);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.identifier);
    }

    public String toString() {
        return "SubjectRef{id=" + (this.id == -1 ? "<unallocated>" : Integer.valueOf(this.id)) + ",type=" + this.type + ",identifier=" + this.identifier + "}";
    }

    public static <I> SqlSubjectRef<I> from(SubjectRef<I> existing) {
        if (existing instanceof SqlSubjectRef) {
            return (SqlSubjectRef)existing;
        }
        return new SqlSubjectRef<I>(existing);
    }
}

