/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.datastore.sql.dao;

import ca.stellardrift.permissionsex.datastore.sql.SqlDao;
import ca.stellardrift.permissionsex.datastore.sql.dao.LegacyMigration;
import ca.stellardrift.permissionsex.ext.checkerframework.checker.nullness.qual.Nullable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LegacyDao {
    public static final LegacyDao INSTANCE = new LegacyDao();
    private static final Pattern TABLE_PATTERN = Pattern.compile("\\{([^}]+)}");

    protected LegacyDao() {
    }

    public String getSelectEntitiesQuery() {
        return "SELECT (`name`, `type`) FROM {permissions_entity}";
    }

    public String getSelectOptionsQuery() {
        return "SELECT `permission`, `value`, `world` FROM `{permissions}` WHERE `name` = ? AND `type` = ? AND LENGTH(`value`) > 0";
    }

    public String getSelectOptionQuery() {
        return "SELECT `value` FROM `{permissions}` WHERE `name` = ? AND `type` = ? AND `permission` = ? AND `world` = ? AND LENGTH(`value`) > 0";
    }

    public String getInsertOptionQuery() {
        return "INSERT INTO `{permissions}` (`name`, `type`, `permission`, `world`, `value`) VALUES (?, ?, ?, ?, ?) ON DUPLICATE KEY UPDATE `value` = VALUES(`value`)";
    }

    public String getSelectPermissionQuery() {
        return "SELECT `permission`, `world` FROM `{permissions}` WHERE `name` = ? AND `type` = ? AND LENGTH(`value`) = 0 ORDER BY `id` DESC";
    }

    public String getSelectParentsQuery() {
        return "SELECT `id`, `parent`, `world` FROM `{}permissions_inheritance_old` WHERE `child` = ? AND `type` = ? ORDER BY `world`, `id` DESC";
    }

    public PreparedStatement prepareStatement(SqlDao dao, String query) throws SQLException {
        StringBuffer ret = new StringBuffer();
        Matcher m = TABLE_PATTERN.matcher(query);
        while (m.find()) {
            m.appendReplacement(ret, dao.getDataStore().getTableName(m.group(1), true));
        }
        m.appendTail(ret);
        return dao.prepareStatement(ret.toString());
    }

    public boolean hasTable(SqlDao dao, String table) throws SQLException {
        return dao.getConnection().getMetaData().getTables(null, null, dao.getDataStore().getTableName(table, true).toUpperCase(), null).next();
    }

    public void renameTable(SqlDao dao, String oldName, String newName) throws SQLException {
        String expandedOld = dao.getDataStore().getTableName(oldName, true);
        String expandedNew = dao.getDataStore().getTableName(newName, false);
        try (PreparedStatement stmt = this.prepareStatement(dao, "ALTER TABLE `" + expandedOld + "` RENAME `" + expandedNew + "`");){
            stmt.executeUpdate();
        }
    }

    public @Nullable String getOption(SqlDao dao, String name, LegacyMigration.Type type, @Nullable String world, String option) throws SQLException {
        try (PreparedStatement stmt = this.prepareStatement(dao, this.getSelectOptionQuery());){
            stmt.setString(1, name);
            stmt.setInt(2, type.ordinal());
            stmt.setString(3, option);
            if (world == null) {
                stmt.setNull(4, 12);
            } else {
                stmt.setString(4, world);
            }
            ResultSet rs = stmt.executeQuery();
            if (rs.next()) {
                String string = rs.getString(1);
                return string;
            }
            String string = null;
            return string;
        }
    }
}

