/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.datastore.sql.dao;

import ca.stellardrift.permissionsex.ext.geantyref.GenericTypeReflector;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.collector.CollectorFactory;
import ca.stellardrift.permissionsex.ext.pcollections.PSet;
import ca.stellardrift.permissionsex.ext.pcollections.PStack;
import ca.stellardrift.permissionsex.ext.pcollections.PVector;
import ca.stellardrift.permissionsex.impl.util.PCollections;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collector;

final class PCollectionsCollectorFactory
implements CollectorFactory {
    static final PCollectionsCollectorFactory INSTANCE = new PCollectionsCollectorFactory();
    private final Map<Class<?>, Collector<?, ?, ?>> collectors = new IdentityHashMap();

    private PCollectionsCollectorFactory() {
        this.collectors.put(PSet.class, PCollections.toPSet());
        this.collectors.put(PVector.class, PCollections.toPVector());
        this.collectors.put(PStack.class, PCollections.toPStack());
    }

    @Override
    public boolean accepts(Type containerType) {
        Class<?> erased = GenericTypeReflector.erase(containerType);
        return this.collectors.containsKey(erased);
    }

    @Override
    public Optional<Type> elementType(Type containerType) {
        if (!(containerType instanceof ParameterizedType)) {
            return Optional.empty();
        }
        return Optional.ofNullable(((ParameterizedType)containerType).getActualTypeArguments()[0]);
    }

    @Override
    public Collector<?, ?, ?> build(Type containerType) {
        Collector<?, ?, ?> collector = this.collectors.get(GenericTypeReflector.erase(containerType));
        if (collector == null) {
            throw new IllegalArgumentException("Does not accept " + containerType);
        }
        return collector;
    }
}

