/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.ext.caffeine.cache;

import ca.stellardrift.permissionsex.ext.caffeine.cache.CacheLoader;
import ca.stellardrift.permissionsex.ext.caffeine.cache.Caffeine;
import ca.stellardrift.permissionsex.ext.caffeine.cache.MpscGrowableArrayQueue;
import ca.stellardrift.permissionsex.ext.caffeine.cache.Node;
import ca.stellardrift.permissionsex.ext.caffeine.cache.Pacer;
import ca.stellardrift.permissionsex.ext.caffeine.cache.Scheduler;
import ca.stellardrift.permissionsex.ext.caffeine.cache.Ticker;
import ca.stellardrift.permissionsex.ext.caffeine.cache.WSLS;
import ca.stellardrift.permissionsex.ext.caffeine.cache.WriteOrderDeque;

class WSLSW<K, V>
extends WSLS<K, V> {
    final Ticker ticker;
    final WriteOrderDeque<Node<K, V>> writeOrderDeque;
    volatile long expiresAfterWriteNanos;
    final MpscGrowableArrayQueue<Runnable> writeBuffer;
    final Pacer pacer;

    WSLSW(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
        super(builder, cacheLoader, async);
        this.ticker = builder.getTicker();
        this.writeOrderDeque = new WriteOrderDeque();
        this.expiresAfterWriteNanos = builder.getExpiresAfterWriteNanos();
        this.writeBuffer = new MpscGrowableArrayQueue(4, WRITE_BUFFER_MAX);
        this.pacer = builder.getScheduler() == Scheduler.disabledScheduler() ? null : new Pacer(builder.getScheduler());
    }

    @Override
    public final Ticker expirationTicker() {
        return this.ticker;
    }

    @Override
    protected final WriteOrderDeque<Node<K, V>> writeOrderDeque() {
        return this.writeOrderDeque;
    }

    @Override
    protected final boolean expiresAfterWrite() {
        return true;
    }

    @Override
    protected final long expiresAfterWriteNanos() {
        return this.expiresAfterWriteNanos;
    }

    @Override
    protected final void setExpiresAfterWriteNanos(long expiresAfterWriteNanos) {
        this.expiresAfterWriteNanos = expiresAfterWriteNanos;
    }

    @Override
    protected final MpscGrowableArrayQueue<Runnable> writeBuffer() {
        return this.writeBuffer;
    }

    @Override
    protected final boolean buffersWrites() {
        return true;
    }

    @Override
    public final Pacer pacer() {
        return this.pacer;
    }
}

