/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.ext.commandframework;

import ca.stellardrift.permissionsex.ext.checkerframework.checker.nullness.qual.NonNull;
import ca.stellardrift.permissionsex.ext.checkerframework.checker.nullness.qual.Nullable;
import ca.stellardrift.permissionsex.ext.commandframework.CommandComponent;
import ca.stellardrift.permissionsex.ext.commandframework.CommandManager;
import ca.stellardrift.permissionsex.ext.commandframework.Description;
import ca.stellardrift.permissionsex.ext.commandframework.arguments.CommandArgument;
import ca.stellardrift.permissionsex.ext.commandframework.arguments.StaticArgument;
import ca.stellardrift.permissionsex.ext.commandframework.arguments.compound.ArgumentPair;
import ca.stellardrift.permissionsex.ext.commandframework.arguments.compound.ArgumentTriplet;
import ca.stellardrift.permissionsex.ext.commandframework.arguments.compound.FlagArgument;
import ca.stellardrift.permissionsex.ext.commandframework.arguments.flags.CommandFlag;
import ca.stellardrift.permissionsex.ext.commandframework.execution.CommandExecutionHandler;
import ca.stellardrift.permissionsex.ext.commandframework.meta.CommandMeta;
import ca.stellardrift.permissionsex.ext.commandframework.meta.SimpleCommandMeta;
import ca.stellardrift.permissionsex.ext.commandframework.permission.CommandPermission;
import ca.stellardrift.permissionsex.ext.commandframework.permission.Permission;
import ca.stellardrift.permissionsex.ext.commandframework.types.tuples.Pair;
import ca.stellardrift.permissionsex.ext.commandframework.types.tuples.Triplet;
import ca.stellardrift.permissionsex.ext.geantyref.TypeToken;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class Command<C> {
    private final List<@NonNull CommandComponent<C>> components;
    private final List<@NonNull CommandArgument<C, ?>> arguments;
    private final CommandExecutionHandler<C> commandExecutionHandler;
    private final Class<? extends C> senderType;
    private final CommandPermission commandPermission;
    private final CommandMeta commandMeta;

    public Command(@NonNull List<@NonNull CommandComponent<C>> commandComponents, @NonNull CommandExecutionHandler<@NonNull C> commandExecutionHandler, @Nullable Class<? extends C> senderType, @NonNull CommandPermission commandPermission, @NonNull CommandMeta commandMeta) {
        this.components = Objects.requireNonNull(commandComponents, "Command components may not be null");
        this.arguments = this.components.stream().map(CommandComponent::getArgument).collect(Collectors.toList());
        if (this.components.isEmpty()) {
            throw new IllegalArgumentException("At least one command component is required");
        }
        boolean foundOptional = false;
        for (CommandArgument<C, ?> argument : this.arguments) {
            if (argument.getName().isEmpty()) {
                throw new IllegalArgumentException("Argument names may not be empty");
            }
            if (foundOptional && argument.isRequired()) {
                throw new IllegalArgumentException(String.format("Command argument '%s' cannot be placed after an optional argument", argument.getName()));
            }
            if (argument.isRequired()) continue;
            foundOptional = true;
        }
        this.commandExecutionHandler = commandExecutionHandler;
        this.senderType = senderType;
        this.commandPermission = commandPermission;
        this.commandMeta = commandMeta;
    }

    public Command(@NonNull List<@NonNull CommandComponent<C>> commandComponents, @NonNull CommandExecutionHandler<@NonNull C> commandExecutionHandler, @Nullable Class<? extends C> senderType, @NonNull CommandMeta commandMeta) {
        this(commandComponents, commandExecutionHandler, senderType, (CommandPermission)Permission.empty(), commandMeta);
    }

    public Command(@NonNull List<@NonNull CommandComponent<C>> commandComponents, @NonNull CommandExecutionHandler<@NonNull C> commandExecutionHandler, @NonNull CommandPermission commandPermission, @NonNull CommandMeta commandMeta) {
        this(commandComponents, commandExecutionHandler, null, commandPermission, commandMeta);
    }

    @Deprecated
    public Command(@NonNull Map<@NonNull CommandArgument<C, ?>, @NonNull Description> commandArguments, @NonNull CommandExecutionHandler<@NonNull C> commandExecutionHandler, @Nullable Class<? extends C> senderType, @NonNull CommandPermission commandPermission, @NonNull CommandMeta commandMeta) {
        this(Command.mapToComponents(commandArguments), commandExecutionHandler, senderType, commandPermission, commandMeta);
    }

    @Deprecated
    public Command(@NonNull Map<@NonNull CommandArgument<C, ?>, @NonNull Description> commandArguments, @NonNull CommandExecutionHandler<@NonNull C> commandExecutionHandler, @Nullable Class<? extends C> senderType, @NonNull CommandMeta commandMeta) {
        this(Command.mapToComponents(commandArguments), commandExecutionHandler, senderType, commandMeta);
    }

    @Deprecated
    public Command(@NonNull Map<@NonNull CommandArgument<C, ?>, @NonNull Description> commandArguments, @NonNull CommandExecutionHandler<@NonNull C> commandExecutionHandler, @NonNull CommandPermission commandPermission, @NonNull CommandMeta commandMeta) {
        this(Command.mapToComponents(commandArguments), commandExecutionHandler, commandPermission, commandMeta);
    }

    private static <C> @NonNull List<@NonNull CommandComponent<C>> mapToComponents(@NonNull Map<@NonNull CommandArgument<C, ?>, @NonNull Description> commandArguments) {
        return commandArguments.entrySet().stream().map(e -> CommandComponent.of((CommandArgument)e.getKey(), (Description)e.getValue())).collect(Collectors.toList());
    }

    public static <C> @NonNull Builder<C> newBuilder(@NonNull String commandName, @NonNull CommandMeta commandMeta, @NonNull Description description, String ... aliases) {
        ArrayList commands = new ArrayList();
        commands.add(CommandComponent.of(StaticArgument.of(commandName, aliases), description));
        return new Builder(null, commandMeta, null, commands, new CommandExecutionHandler.NullCommandExecutionHandler(), Permission.empty(), Collections.emptyList());
    }

    public static <C> @NonNull Builder<C> newBuilder(@NonNull String commandName, @NonNull CommandMeta commandMeta, String ... aliases) {
        ArrayList commands = new ArrayList();
        commands.add(CommandComponent.of(StaticArgument.of(commandName, aliases), Description.empty()));
        return new Builder(null, commandMeta, null, commands, new CommandExecutionHandler.NullCommandExecutionHandler(), Permission.empty(), Collections.emptyList());
    }

    public @NonNull List<CommandArgument<@NonNull C, @NonNull ?>> getArguments() {
        return new ArrayList(this.arguments);
    }

    public @NonNull List<CommandComponent<@NonNull C>> getComponents() {
        return new ArrayList<CommandComponent<C>>(this.components);
    }

    public CommandExecutionHandler<@NonNull C> getCommandExecutionHandler() {
        return this.commandExecutionHandler;
    }

    public @NonNull Optional<Class<? extends C>> getSenderType() {
        return Optional.ofNullable(this.senderType);
    }

    public @NonNull CommandPermission getCommandPermission() {
        return this.commandPermission;
    }

    public @NonNull CommandMeta getCommandMeta() {
        return this.commandMeta;
    }

    @Deprecated
    public @NonNull String getArgumentDescription(@NonNull CommandArgument<C, ?> argument) {
        for (CommandComponent<C> component : this.components) {
            if (!component.getArgument().equals(argument)) continue;
            return component.getDescription().getDescription();
        }
        throw new IllegalArgumentException("Command argument not found: " + argument);
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (CommandArgument<C, ?> argument : this.getArguments()) {
            stringBuilder.append(argument.getName()).append(' ');
        }
        String build = stringBuilder.toString();
        return build.substring(0, build.length() - 1);
    }

    public boolean isHidden() {
        return this.getCommandMeta().getOrDefault(CommandMeta.HIDDEN, false);
    }

    public static final class Builder<C> {
        private final CommandMeta commandMeta;
        private final List<CommandComponent<C>> commandComponents;
        private final CommandExecutionHandler<C> commandExecutionHandler;
        private final Class<? extends C> senderType;
        private final CommandPermission commandPermission;
        private final CommandManager<C> commandManager;
        private final Collection<CommandFlag<?>> flags;

        private Builder(@Nullable CommandManager<C> commandManager, @NonNull CommandMeta commandMeta, @Nullable Class<? extends C> senderType, @NonNull List<@NonNull CommandComponent<C>> commandComponents, @NonNull CommandExecutionHandler<@NonNull C> commandExecutionHandler, @NonNull CommandPermission commandPermission, @NonNull Collection<CommandFlag<?>> flags) {
            this.commandManager = commandManager;
            this.senderType = senderType;
            this.commandComponents = Objects.requireNonNull(commandComponents, "Components may not be null");
            this.commandExecutionHandler = Objects.requireNonNull(commandExecutionHandler, "Execution handler may not be null");
            this.commandPermission = Objects.requireNonNull(commandPermission, "Permission may not be null");
            this.commandMeta = Objects.requireNonNull(commandMeta, "Meta may not be null");
            this.flags = Objects.requireNonNull(flags, "Flags may not be null");
        }

        public @Nullable Class<? extends C> senderType() {
            return this.senderType;
        }

        public @NonNull CommandPermission commandPermission() {
            return this.commandPermission;
        }

        @Deprecated
        public @NonNull Builder<C> meta(@NonNull String key, @NonNull String value) {
            SimpleCommandMeta commandMeta = SimpleCommandMeta.builder().with(this.commandMeta).with(key, value).build();
            return new Builder<C>(this.commandManager, commandMeta, this.senderType, this.commandComponents, this.commandExecutionHandler, this.commandPermission, this.flags);
        }

        public <V> @NonNull Builder<C> meta(@NonNull CommandMeta.Key<V> key, @NonNull V value) {
            SimpleCommandMeta commandMeta = SimpleCommandMeta.builder().with(this.commandMeta).with(key, value).build();
            return new Builder<C>(this.commandManager, commandMeta, this.senderType, this.commandComponents, this.commandExecutionHandler, this.commandPermission, this.flags);
        }

        public @NonNull Builder<C> manager(@Nullable CommandManager<C> commandManager) {
            return new Builder<C>(commandManager, this.commandMeta, this.senderType, this.commandComponents, this.commandExecutionHandler, this.commandPermission, this.flags);
        }

        public @NonNull Builder<C> literal(@NonNull String main, String ... aliases) {
            return this.argument(StaticArgument.of(main, aliases));
        }

        public @NonNull Builder<C> literal(@NonNull String main, @NonNull Description description, String ... aliases) {
            return this.argument(StaticArgument.of(main, aliases), description);
        }

        public <T> @NonNull Builder<C> argument(@NonNull CommandArgument.Builder<C, T> builder) {
            return this.argument(builder.build(), Description.empty());
        }

        public <T> @NonNull Builder<C> argument(@NonNull CommandArgument<C, T> argument) {
            return this.argument(argument, Description.empty());
        }

        public <T> @NonNull Builder<C> argument(@NonNull CommandArgument<C, T> argument, @NonNull Description description) {
            if (argument.isArgumentRegistered()) {
                throw new IllegalArgumentException("The provided argument has already been associated with a command. Use CommandArgument#copy to create a copy of the argument.");
            }
            argument.setArgumentRegistered();
            ArrayList<CommandComponent<C>> commandComponents = new ArrayList<CommandComponent<C>>(this.commandComponents);
            commandComponents.add(CommandComponent.of(argument, description));
            return new Builder<C>(this.commandManager, this.commandMeta, this.senderType, commandComponents, this.commandExecutionHandler, this.commandPermission, this.flags);
        }

        public <T> @NonNull Builder<C> argument(@NonNull CommandArgument.Builder<C, T> builder, @NonNull Description description) {
            ArrayList<CommandComponent<C>> commandComponents = new ArrayList<CommandComponent<C>>(this.commandComponents);
            commandComponents.add(CommandComponent.of(builder.build(), description));
            return new Builder<C>(this.commandManager, this.commandMeta, this.senderType, commandComponents, this.commandExecutionHandler, this.commandPermission, this.flags);
        }

        public <T> @NonNull Builder<C> argument(@NonNull Class<T> clazz, @NonNull String name, @NonNull Consumer<CommandArgument.Builder<C, T>> builderConsumer) {
            CommandArgument.Builder<C, T> builder = CommandArgument.ofType(clazz, name);
            if (this.commandManager != null) {
                builder.manager(this.commandManager);
            }
            builderConsumer.accept(builder);
            return this.argument(builder.build());
        }

        public <U, V> @NonNull Builder<C> argumentPair(@NonNull String name, @NonNull Pair<@NonNull String, @NonNull String> names, @NonNull Pair<@NonNull Class<U>, @NonNull Class<V>> parserPair, @NonNull Description description) {
            if (this.commandManager == null) {
                throw new IllegalStateException("This cannot be called from a command that has no command manager attached");
            }
            return this.argument(ArgumentPair.of(this.commandManager, name, names, parserPair).simple(), description);
        }

        public <U, V, O> @NonNull Builder<C> argumentPair(@NonNull String name, @NonNull TypeToken<O> outputType, @NonNull Pair<String, String> names, @NonNull Pair<Class<U>, Class<V>> parserPair, @NonNull BiFunction<C, Pair<U, V>, O> mapper, @NonNull Description description) {
            if (this.commandManager == null) {
                throw new IllegalStateException("This cannot be called from a command that has no command manager attached");
            }
            return this.argument(ArgumentPair.of(this.commandManager, name, names, parserPair).withMapper(outputType, mapper), description);
        }

        public <U, V, W> @NonNull Builder<C> argumentTriplet(@NonNull String name, @NonNull Triplet<String, String, String> names, @NonNull Triplet<Class<U>, Class<V>, Class<W>> parserTriplet, @NonNull Description description) {
            if (this.commandManager == null) {
                throw new IllegalStateException("This cannot be called from a command that has no command manager attached");
            }
            return this.argument(ArgumentTriplet.of(this.commandManager, name, names, parserTriplet).simple(), description);
        }

        public <U, V, W, O> @NonNull Builder<C> argumentTriplet(@NonNull String name, @NonNull TypeToken<O> outputType, @NonNull Triplet<String, String, String> names, @NonNull Triplet<Class<U>, Class<V>, Class<W>> parserTriplet, @NonNull BiFunction<C, Triplet<U, V, W>, O> mapper, @NonNull Description description) {
            if (this.commandManager == null) {
                throw new IllegalStateException("This cannot be called from a command that has no command manager attached");
            }
            return this.argument(ArgumentTriplet.of(this.commandManager, name, names, parserTriplet).withMapper(outputType, mapper), description);
        }

        public @NonNull Builder<C> handler(@NonNull CommandExecutionHandler<C> commandExecutionHandler) {
            return new Builder<C>(this.commandManager, this.commandMeta, this.senderType, this.commandComponents, commandExecutionHandler, this.commandPermission, this.flags);
        }

        public @NonNull Builder<C> senderType(@NonNull Class<? extends C> senderType) {
            return new Builder<C>(this.commandManager, this.commandMeta, senderType, this.commandComponents, this.commandExecutionHandler, this.commandPermission, this.flags);
        }

        public @NonNull Builder<C> permission(@NonNull CommandPermission permission) {
            return new Builder<C>(this.commandManager, this.commandMeta, this.senderType, this.commandComponents, this.commandExecutionHandler, permission, this.flags);
        }

        public @NonNull Builder<C> permission(@NonNull String permission) {
            return new Builder<C>(this.commandManager, this.commandMeta, this.senderType, this.commandComponents, this.commandExecutionHandler, Permission.of(permission), this.flags);
        }

        public @NonNull Builder<C> proxies(@NonNull Command<C> command) {
            Builder<C> builder = this;
            for (CommandComponent<C> component : command.getComponents()) {
                CommandArgument<C, ?> argument = component.getArgument();
                if (argument instanceof StaticArgument) continue;
                CommandArgument<C, ?> builtArgument = argument.copy();
                builder = builder.argument(builtArgument, component.getDescription());
            }
            if (this.commandPermission.toString().isEmpty()) {
                builder = builder.permission(command.getCommandPermission());
            }
            return builder.handler(((Command)command).commandExecutionHandler);
        }

        public @NonNull Builder<C> hidden() {
            return this.meta(CommandMeta.HIDDEN, true);
        }

        public <T> @NonNull Builder<C> flag(@NonNull CommandFlag<T> flag) {
            ArrayList flags = new ArrayList(this.flags);
            flags.add(flag);
            return new Builder<C>(this.commandManager, this.commandMeta, this.senderType, this.commandComponents, this.commandExecutionHandler, this.commandPermission, Collections.unmodifiableList(flags));
        }

        public <T> @NonNull Builder<C> flag(@NonNull CommandFlag.Builder<T> builder) {
            return this.flag(builder.build());
        }

        public @NonNull Command<C> build() {
            ArrayList<CommandComponent<C>> commandComponents = new ArrayList<CommandComponent<C>>(this.commandComponents);
            if (!this.flags.isEmpty()) {
                FlagArgument flagArgument = new FlagArgument(this.flags);
                commandComponents.add(CommandComponent.of(flagArgument, Description.of("Command flags")));
            }
            return new Command<C>(Collections.unmodifiableList(commandComponents), this.commandExecutionHandler, this.senderType, this.commandPermission, this.commandMeta);
        }
    }
}

