/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.ext.commandframework;

import ca.stellardrift.permissionsex.ext.checkerframework.checker.nullness.qual.NonNull;
import ca.stellardrift.permissionsex.ext.commandframework.Description;
import ca.stellardrift.permissionsex.ext.commandframework.arguments.CommandArgument;
import java.util.Objects;

public final class CommandComponent<C> {
    private final CommandArgument<C, ?> argument;
    private final Description description;

    private CommandComponent(@NonNull CommandArgument<C, ?> commandArgument, @NonNull Description commandDescription) {
        this.argument = commandArgument;
        this.description = commandDescription;
    }

    public @NonNull CommandArgument<C, ?> getArgument() {
        return this.argument;
    }

    public @NonNull Description getDescription() {
        return this.description;
    }

    public int hashCode() {
        return Objects.hash(this.getArgument(), this.getDescription());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof CommandComponent) {
            CommandComponent that = (CommandComponent)o;
            return this.getArgument().equals(that.getArgument()) && this.getDescription().equals(that.getDescription());
        }
        return false;
    }

    public @NonNull String toString() {
        return String.format("%s{argument=%s,description=%s}", this.getClass().getSimpleName(), this.argument, this.description);
    }

    public static <C> @NonNull CommandComponent<C> of(@NonNull CommandArgument<C, ?> commandArgument, @NonNull Description commandDescription) {
        return new CommandComponent<C>(commandArgument, commandDescription);
    }
}

