/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.ext.commandframework.arguments.compound;

import ca.stellardrift.permissionsex.ext.checkerframework.checker.nullness.qual.NonNull;
import ca.stellardrift.permissionsex.ext.commandframework.arguments.CommandArgument;
import ca.stellardrift.permissionsex.ext.commandframework.arguments.flags.CommandFlag;
import ca.stellardrift.permissionsex.ext.commandframework.arguments.parser.ArgumentParseResult;
import ca.stellardrift.permissionsex.ext.commandframework.arguments.parser.ArgumentParser;
import ca.stellardrift.permissionsex.ext.commandframework.captions.Caption;
import ca.stellardrift.permissionsex.ext.commandframework.captions.CaptionVariable;
import ca.stellardrift.permissionsex.ext.commandframework.captions.StandardCaptionKeys;
import ca.stellardrift.permissionsex.ext.commandframework.context.CommandContext;
import ca.stellardrift.permissionsex.ext.commandframework.exceptions.parsing.ParserException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Queue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class FlagArgument<C>
extends CommandArgument<C, Object> {
    private static final Pattern FLAG_ALIAS_PATTERN = Pattern.compile(" -(?<name>([A-Za-z]+))");
    private static final Pattern FLAG_PRIMARY_PATTERN = Pattern.compile(" --(?<name>([A-Za-z]+))");
    public static final Object FLAG_PARSE_RESULT_OBJECT = new Object();
    public static final String FLAG_META = "__last_flag__";
    private static final String FLAG_ARGUMENT_NAME = "flags";
    private final Collection<@NonNull CommandFlag<?>> flags;

    public FlagArgument(Collection<CommandFlag<?>> flags) {
        super(false, FLAG_ARGUMENT_NAME, new FlagArgumentParser(flags.toArray(new CommandFlag[0])), Object.class);
        this.flags = flags;
    }

    public @NonNull Collection<@NonNull CommandFlag<?>> getFlags() {
        return Collections.unmodifiableCollection(this.flags);
    }

    public static enum FailureReason {
        UNKNOWN_FLAG(StandardCaptionKeys.ARGUMENT_PARSE_FAILURE_FLAG_UNKNOWN_FLAG),
        DUPLICATE_FLAG(StandardCaptionKeys.ARGUMENT_PARSE_FAILURE_FLAG_DUPLICATE_FLAG),
        NO_FLAG_STARTED(StandardCaptionKeys.ARGUMENT_PARSE_FAILURE_FLAG_NO_FLAG_STARTED),
        MISSING_ARGUMENT(StandardCaptionKeys.ARGUMENT_PARSE_FAILURE_FLAG_MISSING_ARGUMENT);

        private final Caption caption;

        private FailureReason(Caption caption) {
            this.caption = caption;
        }

        public @NonNull Caption getCaption() {
            return this.caption;
        }
    }

    public static final class FlagParseException
    extends ParserException {
        private static final long serialVersionUID = -7725389394142868549L;
        private final String input;

        public FlagParseException(@NonNull String input, @NonNull FailureReason failureReason, @NonNull CommandContext<?> context) {
            super(FlagArgumentParser.class, context, failureReason.getCaption(), CaptionVariable.of("input", input), CaptionVariable.of("flag", input));
            this.input = input;
        }

        public String getInput() {
            return this.input;
        }
    }

    public static final class FlagArgumentParser<C>
    implements ArgumentParser<C, Object> {
        private final CommandFlag<?>[] flags;

        private FlagArgumentParser(@NonNull CommandFlag<?>[] flags) {
            this.flags = flags;
        }

        @Override
        public @NonNull ArgumentParseResult<@NonNull Object> parse(@NonNull CommandContext<@NonNull C> commandContext, @NonNull Queue<@NonNull String> inputQueue) {
            HashSet parsedFlags = new HashSet();
            CommandFlag<?> currentFlag = null;
            for (String string : inputQueue) {
                if (string.startsWith("-") && currentFlag == null) {
                    String flagName;
                    if (string.startsWith("--")) {
                        flagName = string.substring(2);
                        for (CommandFlag<?> flag : this.flags) {
                            if (!flagName.equalsIgnoreCase(flag.getName())) continue;
                            currentFlag = flag;
                            break;
                        }
                    } else {
                        flagName = string.substring(1);
                        if (flagName.length() > 1) {
                            boolean oneAdded = false;
                            CommandFlag<?>[] commandFlagArray = this.flags;
                            int n = commandFlagArray.length;
                            block2: for (int flag = 0; flag < n; ++flag) {
                                CommandFlag<?> flag2 = commandFlagArray[flag];
                                if (flag2.getCommandArgument() != null) continue;
                                for (String alias : flag2.getAliases()) {
                                    if (!flagName.toLowerCase(Locale.ENGLISH).contains(alias.toLowerCase(Locale.ENGLISH))) continue;
                                    if (parsedFlags.contains(flag2)) {
                                        return ArgumentParseResult.failure(new FlagParseException(string, FailureReason.DUPLICATE_FLAG, commandContext));
                                    }
                                    parsedFlags.add(flag2);
                                    commandContext.flags().addPresenceFlag(flag2);
                                    oneAdded = true;
                                    continue block2;
                                }
                            }
                            if (oneAdded) continue;
                            return ArgumentParseResult.failure(new FlagParseException(string, FailureReason.NO_FLAG_STARTED, commandContext));
                        }
                        block4: for (CommandFlag<?> flag : this.flags) {
                            for (String alias : flag.getAliases()) {
                                if (!alias.equalsIgnoreCase(flagName)) continue;
                                currentFlag = flag;
                                continue block4;
                            }
                        }
                    }
                    if (currentFlag == null) {
                        return ArgumentParseResult.failure(new FlagParseException(string, FailureReason.UNKNOWN_FLAG, commandContext));
                    }
                    if (parsedFlags.contains(currentFlag)) {
                        return ArgumentParseResult.failure(new FlagParseException(string, FailureReason.DUPLICATE_FLAG, commandContext));
                    }
                    parsedFlags.add(currentFlag);
                    if (currentFlag.getCommandArgument() != null) continue;
                    commandContext.flags().addPresenceFlag(currentFlag);
                    currentFlag = null;
                    continue;
                }
                if (currentFlag == null) {
                    return ArgumentParseResult.failure(new FlagParseException(string, FailureReason.NO_FLAG_STARTED, commandContext));
                }
                ArgumentParseResult result = currentFlag.getCommandArgument().getParser().parse(commandContext, new LinkedList<String>(Collections.singletonList(string)));
                if (result.getFailure().isPresent()) {
                    return ArgumentParseResult.failure(result.getFailure().get());
                }
                if (result.getParsedValue().isPresent()) {
                    CommandFlag<?> erasedFlag = currentFlag;
                    Object value = result.getParsedValue().get();
                    commandContext.flags().addValueFlag(erasedFlag, value);
                    currentFlag = null;
                    continue;
                }
                throw new IllegalStateException("Neither result or value were present. Panicking.");
            }
            if (currentFlag != null) {
                return ArgumentParseResult.failure(new FlagParseException(currentFlag.getName(), FailureReason.MISSING_ARGUMENT, commandContext));
            }
            inputQueue.clear();
            return ArgumentParseResult.success(FLAG_PARSE_RESULT_OBJECT);
        }

        @Override
        public @NonNull List<@NonNull String> suggestions(@NonNull CommandContext<C> commandContext, @NonNull String input) {
            String lastArg = commandContext.getOrDefault(FlagArgument.FLAG_META, "");
            if (lastArg.isEmpty() || !lastArg.startsWith("-")) {
                String rawInput = commandContext.getRawInputJoined();
                LinkedList usedFlags = new LinkedList();
                Matcher primaryMatcher = FLAG_PRIMARY_PATTERN.matcher(rawInput);
                block0: while (primaryMatcher.find()) {
                    String name = primaryMatcher.group("name");
                    for (CommandFlag<?> flag : this.flags) {
                        if (!flag.getName().equalsIgnoreCase(name)) continue;
                        usedFlags.add(flag);
                        continue block0;
                    }
                }
                Matcher aliasMatcher = FLAG_ALIAS_PATTERN.matcher(rawInput);
                while (aliasMatcher.find()) {
                    String name = aliasMatcher.group("name");
                    block3: for (CommandFlag<?> flag : this.flags) {
                        for (String alias : flag.getAliases()) {
                            if (!name.contains(alias)) continue;
                            usedFlags.add(flag);
                            continue block3;
                        }
                    }
                }
                LinkedList<String> strings = new LinkedList<String>();
                for (CommandFlag<?> flag : this.flags) {
                    if (usedFlags.contains(flag)) continue;
                    strings.add(String.format("--%s", flag.getName()));
                }
                boolean suggestCombined = input.length() > 1 && input.charAt(0) == '-' && input.charAt(1) != '-';
                for (CommandFlag<?> flag : this.flags) {
                    if (usedFlags.contains(flag)) continue;
                    for (String alias : flag.getAliases()) {
                        if (suggestCombined && flag.getCommandArgument() == null) {
                            strings.add(String.format("%s%s", input, alias));
                            continue;
                        }
                        strings.add(String.format("-%s", alias));
                    }
                }
                if (suggestCombined) {
                    strings.add(input);
                }
                return strings;
            }
            CommandFlag<?> currentFlag = null;
            if (lastArg.startsWith("--")) {
                String flagName = lastArg.substring(2);
                for (CommandFlag<?> flag : this.flags) {
                    if (!flagName.equalsIgnoreCase(flag.getName())) continue;
                    currentFlag = flag;
                    break;
                }
            } else if (lastArg.startsWith("-")) {
                String flagName = lastArg.substring(1);
                block9: for (CommandFlag<?> flag : this.flags) {
                    for (String alias : flag.getAliases()) {
                        if (!alias.equalsIgnoreCase(flagName)) continue;
                        currentFlag = flag;
                        continue block9;
                    }
                }
            }
            if (currentFlag != null && currentFlag.getCommandArgument() != null) {
                return currentFlag.getCommandArgument().getSuggestionsProvider().apply(commandContext, input);
            }
            commandContext.store(FlagArgument.FLAG_META, "");
            return this.suggestions(commandContext, input);
        }
    }
}

