/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.ext.commandframework.arguments.flags;

import ca.stellardrift.permissionsex.ext.checkerframework.checker.nullness.qual.NonNull;
import ca.stellardrift.permissionsex.ext.checkerframework.checker.nullness.qual.Nullable;
import ca.stellardrift.permissionsex.ext.commandframework.arguments.flags.CommandFlag;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public final class FlagContext {
    public static final Object FLAG_PRESENCE_VALUE = new Object();
    private final Map<String, Object> flagValues = new HashMap<String, Object>();

    private FlagContext() {
    }

    public static @NonNull FlagContext create() {
        return new FlagContext();
    }

    public void addPresenceFlag(@NonNull CommandFlag<?> flag) {
        this.flagValues.put(flag.getName(), FLAG_PRESENCE_VALUE);
    }

    public <T> void addValueFlag(@NonNull CommandFlag<T> flag, @NonNull T value) {
        this.flagValues.put(flag.getName(), value);
    }

    public boolean isPresent(@NonNull String flag) {
        Object value = this.flagValues.get(flag);
        return FLAG_PRESENCE_VALUE.equals(value);
    }

    public <T> @NonNull Optional<T> getValue(@NonNull String name) {
        Object value = this.flagValues.get(name);
        if (value == null) {
            return Optional.empty();
        }
        Object casted = value;
        return Optional.of(casted);
    }

    public <T> @Nullable T getValue(@NonNull String name, @Nullable T defaultValue) {
        return this.getValue(name).orElse(defaultValue);
    }

    public boolean hasFlag(@NonNull String name) {
        return this.getValue(name).isPresent();
    }

    public boolean contains(@NonNull String name) {
        return this.hasFlag(name);
    }

    public <T> @Nullable T get(@NonNull String name) {
        return this.getValue(name).orElse(null);
    }
}

