/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.ext.commandframework.arguments.standard;

import ca.stellardrift.permissionsex.ext.checkerframework.checker.nullness.qual.NonNull;
import ca.stellardrift.permissionsex.ext.checkerframework.checker.nullness.qual.Nullable;
import ca.stellardrift.permissionsex.ext.commandframework.arguments.CommandArgument;
import ca.stellardrift.permissionsex.ext.commandframework.arguments.parser.ArgumentParseResult;
import ca.stellardrift.permissionsex.ext.commandframework.arguments.parser.ArgumentParser;
import ca.stellardrift.permissionsex.ext.commandframework.arguments.standard.IntegerArgument;
import ca.stellardrift.permissionsex.ext.commandframework.context.CommandContext;
import ca.stellardrift.permissionsex.ext.commandframework.exceptions.parsing.NoInputProvidedException;
import ca.stellardrift.permissionsex.ext.commandframework.exceptions.parsing.NumberParseException;
import java.util.List;
import java.util.Queue;
import java.util.function.BiFunction;

public final class ByteArgument<C>
extends CommandArgument<C, Byte> {
    private final byte min;
    private final byte max;

    private ByteArgument(boolean required, @NonNull String name, byte min, byte max, @NonNull String defaultValue, @Nullable BiFunction<@NonNull CommandContext<C>, @NonNull String, @NonNull List<@NonNull String>> suggestionsProvider) {
        super(required, name, new ByteParser(min, max), defaultValue, Byte.class, suggestionsProvider);
        this.min = min;
        this.max = max;
    }

    public static <C> @NonNull Builder<C> newBuilder(@NonNull String name) {
        return new Builder(name);
    }

    public static <C> @NonNull CommandArgument<C, Byte> of(@NonNull String name) {
        return ByteArgument.newBuilder(name).asRequired().build();
    }

    public static <C> @NonNull CommandArgument<C, Byte> optional(@NonNull String name) {
        return ByteArgument.newBuilder(name).asOptional().build();
    }

    public static <C> @NonNull CommandArgument<C, Byte> optional(@NonNull String name, byte defaultNum) {
        return ByteArgument.newBuilder(name).asOptionalWithDefault(Byte.toString(defaultNum)).build();
    }

    public byte getMin() {
        return this.min;
    }

    public byte getMax() {
        return this.max;
    }

    public static final class ByteParseException
    extends NumberParseException {
        private static final long serialVersionUID = -4724241304872989208L;

        public ByteParseException(@NonNull String input, byte min, byte max, @NonNull CommandContext<?> context) {
            super(input, min, max, ByteParser.class, context);
        }

        @Override
        public boolean hasMin() {
            return this.getMin().byteValue() != -128;
        }

        @Override
        public boolean hasMax() {
            return this.getMax().byteValue() != 127;
        }

        @Override
        public @NonNull String getNumberType() {
            return "byte";
        }
    }

    public static final class ByteParser<C>
    implements ArgumentParser<C, Byte> {
        private final byte min;
        private final byte max;

        public ByteParser(byte min, byte max) {
            this.min = min;
            this.max = max;
        }

        @Override
        public @NonNull ArgumentParseResult<Byte> parse(@NonNull CommandContext<C> commandContext, @NonNull Queue<@NonNull String> inputQueue) {
            String input = inputQueue.peek();
            if (input == null) {
                return ArgumentParseResult.failure(new NoInputProvidedException(ByteParser.class, commandContext));
            }
            try {
                byte value = Byte.parseByte(input);
                if (value < this.min || value > this.max) {
                    return ArgumentParseResult.failure(new ByteParseException(input, this.min, this.max, commandContext));
                }
                inputQueue.remove();
                return ArgumentParseResult.success(value);
            }
            catch (Exception e) {
                return ArgumentParseResult.failure(new ByteParseException(input, this.min, this.max, commandContext));
            }
        }

        @Override
        public boolean isContextFree() {
            return true;
        }

        @Override
        public @NonNull List<@NonNull String> suggestions(@NonNull CommandContext<C> commandContext, @NonNull String input) {
            return IntegerArgument.IntegerParser.getSuggestions(this.min, this.max, input);
        }

        public byte getMax() {
            return this.max;
        }

        public byte getMin() {
            return this.min;
        }
    }

    public static final class Builder<C>
    extends CommandArgument.Builder<C, Byte> {
        private byte min = (byte)-128;
        private byte max = (byte)127;

        private Builder(@NonNull String name) {
            super(Byte.class, name);
        }

        public @NonNull Builder<C> withMin(byte min) {
            this.min = min;
            return this;
        }

        public @NonNull Builder<C> withMax(byte max) {
            this.max = max;
            return this;
        }

        public @NonNull ByteArgument<C> build() {
            return new ByteArgument(this.isRequired(), this.getName(), this.min, this.max, this.getDefaultValue(), this.getSuggestionsProvider());
        }
    }
}

