/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.ext.commandframework.arguments.standard;

import ca.stellardrift.permissionsex.ext.checkerframework.checker.nullness.qual.NonNull;
import ca.stellardrift.permissionsex.ext.checkerframework.checker.nullness.qual.Nullable;
import ca.stellardrift.permissionsex.ext.commandframework.arguments.CommandArgument;
import ca.stellardrift.permissionsex.ext.commandframework.arguments.parser.ArgumentParseResult;
import ca.stellardrift.permissionsex.ext.commandframework.arguments.parser.ArgumentParser;
import ca.stellardrift.permissionsex.ext.commandframework.context.CommandContext;
import ca.stellardrift.permissionsex.ext.commandframework.exceptions.parsing.NoInputProvidedException;
import ca.stellardrift.permissionsex.ext.commandframework.exceptions.parsing.NumberParseException;
import java.util.List;
import java.util.Queue;
import java.util.function.BiFunction;

public final class FloatArgument<C>
extends CommandArgument<C, Float> {
    private final float min;
    private final float max;

    private FloatArgument(boolean required, @NonNull String name, float min, float max, @NonNull String defaultValue, @Nullable BiFunction<@NonNull CommandContext<C>, @NonNull String, @NonNull List<@NonNull String>> suggestionsProvider) {
        super(required, name, new FloatParser(min, max), defaultValue, Float.class, suggestionsProvider);
        this.min = min;
        this.max = max;
    }

    public static <C> @NonNull Builder<C> newBuilder(@NonNull String name) {
        return new Builder(name);
    }

    public static <C> @NonNull CommandArgument<C, Float> of(@NonNull String name) {
        return FloatArgument.newBuilder(name).asRequired().build();
    }

    public static <C> @NonNull CommandArgument<C, Float> optional(@NonNull String name) {
        return FloatArgument.newBuilder(name).asOptional().build();
    }

    public static <C> @NonNull CommandArgument<C, Float> optional(@NonNull String name, float defaultNum) {
        return FloatArgument.newBuilder(name).asOptionalWithDefault(Float.toString(defaultNum)).build();
    }

    public float getMin() {
        return this.min;
    }

    public float getMax() {
        return this.max;
    }

    public static final class FloatParseException
    extends NumberParseException {
        private static final long serialVersionUID = -1162983846751812292L;

        public FloatParseException(@NonNull String input, float min, float max, @NonNull CommandContext<?> commandContext) {
            super(input, Float.valueOf(min), Float.valueOf(max), FloatParser.class, commandContext);
        }

        @Override
        public boolean hasMin() {
            return this.getMin().floatValue() != Float.MIN_VALUE;
        }

        @Override
        public boolean hasMax() {
            return this.getMax().floatValue() != Float.MAX_VALUE;
        }

        @Override
        public @NonNull String getNumberType() {
            return "float";
        }
    }

    public static final class FloatParser<C>
    implements ArgumentParser<C, Float> {
        private final float min;
        private final float max;

        public FloatParser(float min, float max) {
            this.min = min;
            this.max = max;
        }

        @Override
        public @NonNull ArgumentParseResult<Float> parse(@NonNull CommandContext<C> commandContext, @NonNull Queue<String> inputQueue) {
            String input = inputQueue.peek();
            if (input == null) {
                return ArgumentParseResult.failure(new NoInputProvidedException(FloatParser.class, commandContext));
            }
            try {
                float value = Float.parseFloat(input);
                if (value < this.min || value > this.max) {
                    return ArgumentParseResult.failure(new FloatParseException(input, this.min, this.max, commandContext));
                }
                inputQueue.remove();
                return ArgumentParseResult.success(Float.valueOf(value));
            }
            catch (Exception e) {
                return ArgumentParseResult.failure(new FloatParseException(input, this.min, this.max, commandContext));
            }
        }

        @Override
        public boolean isContextFree() {
            return true;
        }

        public float getMax() {
            return this.max;
        }

        public float getMin() {
            return this.min;
        }
    }

    public static final class Builder<C>
    extends CommandArgument.Builder<C, Float> {
        private float min = Float.NEGATIVE_INFINITY;
        private float max = Float.POSITIVE_INFINITY;

        private Builder(@NonNull String name) {
            super(Float.class, name);
        }

        public @NonNull Builder<C> withMin(int min) {
            this.min = min;
            return this;
        }

        public @NonNull Builder<C> withMax(int max) {
            this.max = max;
            return this;
        }

        public @NonNull FloatArgument<C> build() {
            return new FloatArgument(this.isRequired(), this.getName(), this.min, this.max, this.getDefaultValue(), this.getSuggestionsProvider());
        }
    }
}

