/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.ext.commandframework.arguments.standard;

import ca.stellardrift.permissionsex.ext.checkerframework.checker.nullness.qual.NonNull;
import ca.stellardrift.permissionsex.ext.checkerframework.checker.nullness.qual.Nullable;
import ca.stellardrift.permissionsex.ext.commandframework.arguments.CommandArgument;
import ca.stellardrift.permissionsex.ext.commandframework.arguments.parser.ArgumentParseResult;
import ca.stellardrift.permissionsex.ext.commandframework.arguments.parser.ArgumentParser;
import ca.stellardrift.permissionsex.ext.commandframework.arguments.standard.IntegerArgument;
import ca.stellardrift.permissionsex.ext.commandframework.context.CommandContext;
import ca.stellardrift.permissionsex.ext.commandframework.exceptions.parsing.NoInputProvidedException;
import ca.stellardrift.permissionsex.ext.commandframework.exceptions.parsing.NumberParseException;
import java.util.List;
import java.util.Queue;
import java.util.function.BiFunction;

public final class LongArgument<C>
extends CommandArgument<C, Long> {
    private final long min;
    private final long max;

    private LongArgument(boolean required, @NonNull String name, long min, long max, String defaultValue, @Nullable BiFunction<@NonNull CommandContext<C>, @NonNull String, @NonNull List<@NonNull String>> suggestionsProvider) {
        super(required, name, new LongParser(min, max), defaultValue, Long.class, suggestionsProvider);
        this.min = min;
        this.max = max;
    }

    public static <C> @NonNull Builder<C> newBuilder(@NonNull String name) {
        return new Builder(name);
    }

    public static <C> @NonNull CommandArgument<C, Long> of(@NonNull String name) {
        return LongArgument.newBuilder(name).asRequired().build();
    }

    public static <C> @NonNull CommandArgument<C, Long> optional(@NonNull String name) {
        return LongArgument.newBuilder(name).asOptional().build();
    }

    public static <C> @NonNull CommandArgument<C, Long> optional(@NonNull String name, long defaultNum) {
        return LongArgument.newBuilder(name).asOptionalWithDefault(Long.toString(defaultNum)).build();
    }

    public long getMin() {
        return this.min;
    }

    public long getMax() {
        return this.max;
    }

    public static final class LongParseException
    extends NumberParseException {
        private static final long serialVersionUID = 4366856282301198232L;

        public LongParseException(@NonNull String input, long min, long max, @NonNull CommandContext<?> commandContext) {
            super(input, min, max, LongParser.class, commandContext);
        }

        @Override
        public boolean hasMin() {
            return this.getMin().longValue() != Long.MIN_VALUE;
        }

        @Override
        public boolean hasMax() {
            return this.getMax().longValue() != Long.MAX_VALUE;
        }

        @Override
        public @NonNull String getNumberType() {
            return "long";
        }
    }

    private static final class LongParser<C>
    implements ArgumentParser<C, Long> {
        private final long min;
        private final long max;

        private LongParser(long min, long max) {
            this.min = min;
            this.max = max;
        }

        @Override
        public @NonNull ArgumentParseResult<Long> parse(@NonNull CommandContext<C> commandContext, @NonNull Queue<@NonNull String> inputQueue) {
            String input = inputQueue.peek();
            if (input == null) {
                return ArgumentParseResult.failure(new NoInputProvidedException(LongParser.class, commandContext));
            }
            try {
                long value = Long.parseLong(input);
                if (value < this.min || value > this.max) {
                    return ArgumentParseResult.failure(new LongParseException(input, this.min, this.max, commandContext));
                }
                inputQueue.remove();
                return ArgumentParseResult.success(value);
            }
            catch (Exception e) {
                return ArgumentParseResult.failure(new LongParseException(input, this.min, this.max, commandContext));
            }
        }

        @Override
        public boolean isContextFree() {
            return true;
        }

        @Override
        public @NonNull List<@NonNull String> suggestions(@NonNull CommandContext<C> commandContext, @NonNull String input) {
            return IntegerArgument.IntegerParser.getSuggestions(this.min, this.max, input);
        }
    }

    public static final class Builder<C>
    extends CommandArgument.Builder<C, Long> {
        private long min = Long.MIN_VALUE;
        private long max = Long.MAX_VALUE;

        private Builder(@NonNull String name) {
            super(Long.class, name);
        }

        public @NonNull Builder<C> withMin(long min) {
            this.min = min;
            return this;
        }

        public @NonNull Builder<C> withMax(long max) {
            this.max = max;
            return this;
        }

        public @NonNull LongArgument<C> build() {
            return new LongArgument(this.isRequired(), this.getName(), this.min, this.max, this.getDefaultValue(), this.getSuggestionsProvider());
        }
    }
}

