/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.ext.commandframework.arguments.standard;

import ca.stellardrift.permissionsex.ext.checkerframework.checker.nullness.qual.NonNull;
import ca.stellardrift.permissionsex.ext.checkerframework.checker.nullness.qual.Nullable;
import ca.stellardrift.permissionsex.ext.commandframework.arguments.CommandArgument;
import ca.stellardrift.permissionsex.ext.commandframework.arguments.parser.ArgumentParseResult;
import ca.stellardrift.permissionsex.ext.commandframework.arguments.parser.ArgumentParser;
import ca.stellardrift.permissionsex.ext.commandframework.context.CommandContext;
import ca.stellardrift.permissionsex.ext.geantyref.TypeToken;
import java.util.List;
import java.util.Queue;
import java.util.function.BiFunction;

public final class StringArrayArgument<C>
extends CommandArgument<C, String[]> {
    private StringArrayArgument(boolean required, @NonNull String name, @Nullable BiFunction<CommandContext<C>, String, List<String>> suggestionsProvider) {
        super(required, name, new StringArrayParser(), "", TypeToken.get(String[].class), suggestionsProvider);
    }

    public static <C> @NonNull StringArrayArgument<C> of(@NonNull String name, @NonNull BiFunction<CommandContext<C>, String, List<String>> suggestionsProvider) {
        return new StringArrayArgument<C>(true, name, suggestionsProvider);
    }

    public static <C> @NonNull StringArrayArgument<C> optional(@NonNull String name, @NonNull BiFunction<CommandContext<C>, String, List<String>> suggestionsProvider) {
        return new StringArrayArgument<C>(false, name, suggestionsProvider);
    }

    public static final class StringArrayParser<C>
    implements ArgumentParser<C, String[]> {
        @Override
        public @NonNull ArgumentParseResult<String @NonNull []> parse(@NonNull CommandContext<@NonNull C> commandContext, @NonNull Queue<@NonNull String> inputQueue) {
            String[] result = new String[inputQueue.size()];
            for (int i = 0; i < result.length; ++i) {
                result[i] = inputQueue.remove();
            }
            return ArgumentParseResult.success(result);
        }
    }
}

