/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.ext.commandframework.arguments.standard;

import ca.stellardrift.permissionsex.ext.checkerframework.checker.nullness.qual.NonNull;
import ca.stellardrift.permissionsex.ext.checkerframework.checker.nullness.qual.Nullable;
import ca.stellardrift.permissionsex.ext.commandframework.arguments.CommandArgument;
import ca.stellardrift.permissionsex.ext.commandframework.arguments.parser.ArgumentParseResult;
import ca.stellardrift.permissionsex.ext.commandframework.arguments.parser.ArgumentParser;
import ca.stellardrift.permissionsex.ext.commandframework.captions.CaptionVariable;
import ca.stellardrift.permissionsex.ext.commandframework.captions.StandardCaptionKeys;
import ca.stellardrift.permissionsex.ext.commandframework.context.CommandContext;
import ca.stellardrift.permissionsex.ext.commandframework.exceptions.parsing.NoInputProvidedException;
import ca.stellardrift.permissionsex.ext.commandframework.exceptions.parsing.ParserException;
import java.util.List;
import java.util.Queue;
import java.util.UUID;
import java.util.function.BiFunction;

public final class UUIDArgument<C>
extends CommandArgument<C, UUID> {
    private UUIDArgument(boolean required, @NonNull String name, @NonNull String defaultValue, @Nullable BiFunction<@NonNull CommandContext<C>, @NonNull String, @NonNull List<@NonNull String>> suggestionsProvider) {
        super(required, name, new UUIDParser(), defaultValue, UUID.class, suggestionsProvider);
    }

    public static <C> @NonNull Builder<C> newBuilder(@NonNull String name) {
        return new Builder(name);
    }

    public static <C> @NonNull CommandArgument<C, UUID> of(@NonNull String name) {
        return UUIDArgument.newBuilder(name).asRequired().build();
    }

    public static <C> @NonNull CommandArgument<C, UUID> optional(@NonNull String name) {
        return UUIDArgument.newBuilder(name).asOptional().build();
    }

    public static <C> @NonNull CommandArgument<C, UUID> optional(@NonNull String name, @NonNull UUID defaultUUID) {
        return UUIDArgument.newBuilder(name).asOptionalWithDefault(defaultUUID.toString()).build();
    }

    public static final class UUIDParseException
    extends ParserException {
        private static final long serialVersionUID = 6399602590976540023L;
        private final String input;

        public UUIDParseException(@NonNull String input, @NonNull CommandContext<?> context) {
            super(UUIDParser.class, context, StandardCaptionKeys.ARGUMENT_PARSE_FAILURE_UUID, CaptionVariable.of("input", input));
            this.input = input;
        }

        public String getInput() {
            return this.input;
        }
    }

    public static final class UUIDParser<C>
    implements ArgumentParser<C, UUID> {
        @Override
        public @NonNull ArgumentParseResult<UUID> parse(@NonNull CommandContext<C> commandContext, @NonNull Queue<@NonNull String> inputQueue) {
            String input = inputQueue.peek();
            if (input == null) {
                return ArgumentParseResult.failure(new NoInputProvidedException(UUIDParser.class, commandContext));
            }
            try {
                UUID uuid = UUID.fromString(input);
                inputQueue.remove();
                return ArgumentParseResult.success(uuid);
            }
            catch (IllegalArgumentException e) {
                return ArgumentParseResult.failure(new UUIDParseException(input, commandContext));
            }
        }

        @Override
        public boolean isContextFree() {
            return true;
        }
    }

    public static final class Builder<C>
    extends CommandArgument.Builder<C, UUID> {
        private Builder(@NonNull String name) {
            super(UUID.class, name);
        }

        public @NonNull UUIDArgument<C> build() {
            return new UUIDArgument(this.isRequired(), this.getName(), this.getDefaultValue(), this.getSuggestionsProvider());
        }
    }
}

