/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.ext.commandframework.bukkit;

import ca.stellardrift.permissionsex.ext.checkerframework.checker.nullness.qual.NonNull;
import ca.stellardrift.permissionsex.ext.commandframework.Command;
import ca.stellardrift.permissionsex.ext.commandframework.arguments.CommandArgument;
import ca.stellardrift.permissionsex.ext.commandframework.bukkit.BukkitCommandManager;
import ca.stellardrift.permissionsex.ext.commandframework.exceptions.ArgumentParseException;
import ca.stellardrift.permissionsex.ext.commandframework.exceptions.CommandExecutionException;
import ca.stellardrift.permissionsex.ext.commandframework.exceptions.InvalidCommandSenderException;
import ca.stellardrift.permissionsex.ext.commandframework.exceptions.InvalidSyntaxException;
import ca.stellardrift.permissionsex.ext.commandframework.exceptions.NoPermissionException;
import ca.stellardrift.permissionsex.ext.commandframework.exceptions.NoSuchCommandException;
import ca.stellardrift.permissionsex.ext.commandframework.meta.CommandMeta;
import java.util.List;
import java.util.concurrent.CompletionException;
import java.util.logging.Level;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginIdentifiableCommand;
import org.bukkit.plugin.Plugin;

final class BukkitCommand<C>
extends org.bukkit.command.Command
implements PluginIdentifiableCommand {
    private static final String MESSAGE_INTERNAL_ERROR = ChatColor.RED + "An internal error occurred while attempting to perform this command.";
    private static final String MESSAGE_NO_PERMS = ChatColor.RED + "I'm sorry, but you do not have permission to perform this command. Please contact the server administrators if you believe that this is in error.";
    private static final String MESSAGE_UNKNOWN_COMMAND = "Unknown command. Type \"/help\" for help.";
    private final CommandArgument<C, ?> command;
    private final BukkitCommandManager<C> manager;
    private final Command<C> cloudCommand;

    BukkitCommand(@NonNull String label, @NonNull List<@NonNull String> aliases, @NonNull Command<C> cloudCommand, @NonNull CommandArgument<C, ?> command, @NonNull BukkitCommandManager<C> manager) {
        super(label, cloudCommand.getCommandMeta().getOrDefault(CommandMeta.DESCRIPTION, ""), "", aliases);
        this.command = command;
        this.manager = manager;
        this.cloudCommand = cloudCommand;
        if (this.command.getOwningCommand() != null) {
            this.setPermission(this.command.getOwningCommand().getCommandPermission().toString());
        }
    }

    public boolean execute(@NonNull CommandSender commandSender, @NonNull String s, @NonNull String @NonNull [] strings) {
        StringBuilder builder = new StringBuilder(this.command.getName());
        for (String string : strings) {
            builder.append(" ").append(string);
        }
        C sender = this.manager.getCommandSenderMapper().apply(commandSender);
        this.manager.executeCommand(sender, builder.toString()).whenComplete((commandResult, throwable) -> {
            if (throwable != null) {
                if (throwable instanceof CompletionException) {
                    throwable = throwable.getCause();
                }
                Throwable finalThrowable = throwable;
                if (throwable instanceof InvalidSyntaxException) {
                    this.manager.handleException(sender, InvalidSyntaxException.class, (InvalidSyntaxException)throwable, (c, e) -> commandSender.sendMessage(ChatColor.RED + "Invalid Command Syntax. Correct command syntax is: " + ChatColor.GRAY + "/" + ((InvalidSyntaxException)finalThrowable).getCorrectSyntax()));
                } else if (throwable instanceof InvalidCommandSenderException) {
                    this.manager.handleException(sender, InvalidCommandSenderException.class, (InvalidCommandSenderException)throwable, (c, e) -> commandSender.sendMessage(ChatColor.RED + finalThrowable.getMessage()));
                } else if (throwable instanceof NoPermissionException) {
                    this.manager.handleException(sender, NoPermissionException.class, (NoPermissionException)throwable, (c, e) -> commandSender.sendMessage(MESSAGE_NO_PERMS));
                } else if (throwable instanceof NoSuchCommandException) {
                    this.manager.handleException(sender, NoSuchCommandException.class, (NoSuchCommandException)throwable, (c, e) -> commandSender.sendMessage(MESSAGE_UNKNOWN_COMMAND));
                } else if (throwable instanceof ArgumentParseException) {
                    this.manager.handleException(sender, ArgumentParseException.class, (ArgumentParseException)throwable, (c, e) -> commandSender.sendMessage(ChatColor.RED + "Invalid Command Argument: " + ChatColor.GRAY + finalThrowable.getCause().getMessage()));
                } else if (throwable instanceof CommandExecutionException) {
                    this.manager.handleException(sender, CommandExecutionException.class, (CommandExecutionException)throwable, (c, e) -> {
                        commandSender.sendMessage(MESSAGE_INTERNAL_ERROR);
                        this.manager.getOwningPlugin().getLogger().log(Level.SEVERE, "Exception executing command handler", finalThrowable.getCause());
                    });
                } else {
                    commandSender.sendMessage(MESSAGE_INTERNAL_ERROR);
                    this.manager.getOwningPlugin().getLogger().log(Level.SEVERE, "An unhandled exception was thrown during command execution", (Throwable)throwable);
                }
            }
        });
        return true;
    }

    public String getDescription() {
        return this.cloudCommand.getCommandMeta().getOrDefault(CommandMeta.DESCRIPTION, "");
    }

    public Plugin getPlugin() {
        return this.manager.getOwningPlugin();
    }

    public String getPermission() {
        return this.cloudCommand.getCommandPermission().toString();
    }

    public String getUsage() {
        return this.manager.getCommandSyntaxFormatter().apply(this.cloudCommand.getArguments(), null);
    }
}

